package math.trans;

import math.axes.CartesianAxPanel;
import math.matrix.Matrix;
import math.matrix.MatrixException;

import javax.swing.*;
import java.awt.*;

public class Trans15 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Trans15(new TransPanel15()));
    }

    public Trans15(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class TransPanel15 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        TransUtil.drawRect(2, 5, 5, 5, 5, 8, 2, 8, g2, Color.BLUE);
        double[] tpoint = {3.5, 6.5, 1};
        double shx = 0.5;
        double shy = 0;
        //-
        double[][] pointa = {{2}, {5}, {1}};
        Matrix mata = new Matrix(pointa);
        Matrix transa1 = new Matrix(3, 3);
        Matrix transa2 = new Matrix(3, 3);
        Matrix transa3 = new Matrix(3, 3);
        try {
            transa1.setToIdentity();
            transa2.setToIdentity();
            transa3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transa1.setToTranslate(-tpoint[0], -tpoint[1]);
        Matrix aa1 = transa1.multiply2(mata);
        transa2.setToShear(shx, shy);
        Matrix aa2 = transa2.multiply2(aa1);
        transa3.setToTranslate(tpoint[0], tpoint[1]);
        Matrix aa3 = transa3.multiply2(aa2);
        //-
        double[][] pointb = {{5}, {5}, {1}};
        Matrix matb = new Matrix(pointb);
        Matrix transb1 = new Matrix(3, 3);
        Matrix transb2 = new Matrix(3, 3);
        Matrix transb3 = new Matrix(3, 3);
        try {
            transb1.setToIdentity();
            transb2.setToIdentity();
            transb3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transb1.setToTranslate(-tpoint[0], -tpoint[1]);
        Matrix bb1 = transb1.multiply2(matb);
        transb2.setToShear(shx, shy);
        Matrix bb2 = transb2.multiply2(bb1);
        transb3.setToTranslate(tpoint[0], tpoint[1]);
        Matrix bb3 = transb3.multiply2(bb2);
        //-
        double[][] pointc = {{5}, {8}, {1}};
        Matrix matc = new Matrix(pointc);
        Matrix transc1 = new Matrix(3, 3);
        Matrix transc2 = new Matrix(3, 3);
        Matrix transc3 = new Matrix(3, 3);
        try {
            transc1.setToIdentity();
            transc2.setToIdentity();
            transc3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transc1.setToTranslate(-tpoint[0], -tpoint[1]);
        Matrix cc1 = transc1.multiply2(matc);
        transc2.setToShear(shx, shy);
        Matrix cc2 = transc2.multiply2(cc1);
        transc3.setToTranslate(tpoint[0], tpoint[1]);
        Matrix cc3 = transc3.multiply2(cc2);
        //-
        double[][] pointd = {{2}, {8}, {1}};
        Matrix matd = new Matrix(pointd);
        Matrix transd1 = new Matrix(3, 3);
        Matrix transd2 = new Matrix(3, 3);
        Matrix transd3 = new Matrix(3, 3);
        try {
            transd1.setToIdentity();
            transd2.setToIdentity();
            transd3.setToIdentity();
        } catch (MatrixException e) {
            e.printStackTrace();
        }
        transd1.setToTranslate(-tpoint[0], -tpoint[1]);
        Matrix dd1 = transd1.multiply2(matd);
        transd2.setToShear(shx, shy);
        Matrix dd2 = transd2.multiply2(dd1);
        transd3.setToTranslate(tpoint[0], tpoint[1]);
        Matrix dd3 = transd3.multiply2(dd2);
        //-
        try {
            TransUtil.drawRect((float) aa3.getCell(0, 0),
                    (float) aa3.getCell(1, 0), (float) bb3.getCell(0, 0),
                    (float) bb3.getCell(1, 0), (float) cc3.getCell(0, 0),
                    (float) cc3.getCell(1, 0), (float) dd3.getCell(0, 0),
                    (float) dd3.getCell(1, 0), g2, Color.RED);
        } catch (MatrixException e) {
            e.printStackTrace();
        }
    }
}
