package math.shapes;

import java.awt.*;
import java.awt.geom.*;

public class Circle implements Shape {
    private final float startX;
    private final float startY;
    private final float r;
    private static final double alfa = Math.PI / 4;
    private static final double alfa2 = Math.PI / 8;
    private final GeneralPath path;

    public Circle(float startX, float startY, float r) {
        this.startX = startX;
        this.startY = startY;
        this.r = r;
        path = new GeneralPath();
        path.moveTo(startX + r, startY);
        path.quadTo(startX + r, startY + r * Math.tan(alfa2),
                startX + r * Math.cos(alfa), startY + r * Math.cos(alfa));
        path.quadTo(startX + r * Math.tan(alfa2), startY + r, startX, startY
                + r);
        path.quadTo(startX - r * Math.tan(alfa2), startY + r,
                startX - r * Math.cos(alfa), startY + r * Math.cos(alfa));
        path.quadTo(startX - r, startY + r * Math.tan(alfa2), startX - r,
                startY);
        path.quadTo(startX - r, startY - r * Math.tan(alfa2),
                startX - r * Math.cos(alfa), startY - r * Math.cos(alfa));
        path.quadTo(startX - r * Math.tan(alfa2), startY - r, startX, startY
                - r);
        path.quadTo(startX + r * Math.tan(alfa2), startY - r,
                startX + r * Math.cos(alfa), startY - r * Math.cos(alfa));
        path.quadTo(startX + r, startY - r * Math.tan(alfa2), startX + r,
                startY);
    }

    @Override
    public boolean contains(Point2D p) {
        return path.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return path.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return path.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return path.contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return path.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return path.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return path.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return path.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return path.intersects(x, y, w, h);
    }

    public GeneralPath getPath() {
        return path;
    }

    public float getStartX() {
        return startX;
    }

    public float getStartY() {
        return startY;
    }

    public float getR() {
        return r;
    }
}
