package math.fractals;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import math.axes.*;
import math.utils.*;

class Fractal29 extends JFrame{
	private static final long serialVersionUID = 431281611636634328L;
	public static final int fw = 1000;
	public static final int fh = 1000;

	public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> new Fractal29(new AxPanel03()));
	}

	Fractal29(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds(
				(Toolkit.getDefaultToolkit().getScreenSize().width / 2)
						- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2),
				fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		setResizable(false);
		JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}

class AxPanel03 extends JPanel{
	private static final long serialVersionUID = 5218506428064759030L;
	private static final int w = 860;
	private static final int h = 860;
	private static final int offset = 30;
	private final BufferedImage bimage;
	private final WritableRaster raster;
	private final int[] rgb = {0, 0, 0, 255};

	public AxPanel03(){
		setPreferredSize(new Dimension(w, h));
		setSize(w, h);
		setBackground(Color.WHITE);
		bimage = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);
		raster = bimage.getRaster();
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2.drawRect(offset, offset, w - 2 * offset, h - 2 * offset);
		Ax diag1 = new Ax(0, 0, w - 2 * offset, h - 2 * offset, 0, 0, 4, 1, g2,
				0.5f, 0.25f, offset);
		diag1.drawGrid(Color.LIGHT_GRAY);
		diag1.drawTitle("Liczebność populacji w zależności od wartości r");
		diag1.drawXLegend(false);
		diag1.drawYLegend(false);
		g2.drawString("r", 840, 855);
		g2.drawString("N/K - nasycenie populacji", 5, 12);
		float b = diag1.getRh();
		float r = 0f;
		float dt = 1f;
		for(int x = 0; x < w - 2 * offset; x++){
			r = diag1.getRzut().getRX(x);
			for(int i = 0; i < 500; i++){
				float N = (1f + MathUtil.randomInRange(0, 999)) / 1000f;
				for(float t = 0; t < 500; t += dt){
					N = N * r * (1 - N);
				}
				int y = (int) diag1.getRzut().getSY(b - N);
				raster.setPixel(x, y, rgb);
			}
		}
		g2.drawImage(bimage, 0 + offset, 0 + offset, this);
	}
}
