<?php
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: ps_html.php,v 1.7 2005/01/29 08:09:20 soeren_nb Exp $
* @package mambo-phpShop
* Contains code from PHPShop(tm):
* 	@copyright (C) 2000 - 2004 Edikon Corporation (www.edikon.com)
*	Community: www.phpshop.org, forums.phpshop.org
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*
* This Class provides some utility functions
* to easily create drop-down lists
*/

class ps_html {
  var $classname = "ps_html";

  /**************************************************************************
  ** name: dropdown_display()
  ** created by: gday
  ** description:  Print an HTML dropdown box named $name using $arr to
  **               load the drop down.  If $value is in $arr, then $value
  **               will be the selected option in the dropdown.
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function dropdown_display($name, $value, $arr) {
    
      if( !empty( $arr ) ) {
        echo "<select class=\"inputbox\" name=\"$name\" size=\"1\">\n";

        while (list($key, $val) = each($arr)) {
           if(strcmp($value, $key) == 0) {
              echo "<option value=\"$key\" selected>$val\n";
           }
           else {
              echo "<option value=\"$key\">$val\n";
           }
           echo "</option>";
        }
  
        echo "</select>\n";
      }
      return True;
   }


  /****************************************************************************
   *    function:  list_user_title
   *  created by: pablo
   * description: Lists some titles.
   ****************************************************************************/
  function list_user_title($t) {
     global $PHPSHOP_LANG;
     
     $title = array($PHPSHOP_LANG->_PHPSHOP_REGISTRATION_FORM_MR, 
                          $PHPSHOP_LANG->_PHPSHOP_REGISTRATION_FORM_MRS, 
                          $PHPSHOP_LANG->_PHPSHOP_REGISTRATION_FORM_DR, 
                          $PHPSHOP_LANG->_PHPSHOP_REGISTRATION_FORM_PROF);
     echo "<select class=\"inputbox\" name=\"title\">\n";
     echo "<option value=\"\">".$PHPSHOP_LANG->_PHPSHOP_REGISTRATION_FORM_NONE."</option>\n";
     for ($i=0;$i<count($title);$i++) {
        echo "<option value=\"" . $title[$i]."\"";
        if ($title[$i] == $t)
           echo " selected=\"selected\" ";
        echo ">" . $title[$i] . "</option>\n";
     }
     echo "</select>\n";
  
  }



  /**************************************************************************
  ** name: list_month($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the credit cards 
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_month($list_name, $selected_item="") {
      global $PHPSHOP_LANG;
       $list = array("Month",
                    "01" => _JAN,
                    "02" => _FEB,
                    "03" => _MAR,
                    "04" => _APR,
                    "05" => _MAY,
                    "06" => _JUN,
                    "07" => _JUL,
                    "08" => _AUG,
                    "09" => _SEP,
                    "10" => _OCT,
                    "11" => _NOV,
                    "12" => _DEC);
       $this->dropdown_display($list_name, $selected_item, $list);
       return 1;
   }


  /**************************************************************************
  ** name: list_year($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the credit cards
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_year($list_name,$selected_item="") {
       $list = array("2005" => "2005",
                    "2006" => "2006",
                    "2007" => "2007",
                    "2008" => "2008",
                    "2009" => "2009",
                    "2010" => "2010",
                    "2011" => "2011",
                    "2012" => "2012");
       $this->dropdown_display($list_name, $selected_item, $list);
       return 1;
   }

  /**************************************************************************
  ** name: list_states($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for US states
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_states($list_name,$selected_item="") {
      global $PHPSHOP_LANG;
      
      $list = array("" => $PHPSHOP_LANG->_PHPSHOP_SELECT,
                          " " => "----- american -----",
                          "AL" => "Alabama",
                          "AK" => "Alaska",
                          "AZ" => "Arizona",
                          "AR" => "Arkansas",
                          "CA" => "California",
                          "CO" => "Colorado",
                          "CT" => "Connecticut",
                          "DE" => "Delaware",
                          "DC" => "District Of Columbia",
                          "FL" => "Florida",
                          "GA" => "Georgia",
                          "HI" => "Hawaii",
                          "ID" => "Idaho",
                          "IL" => "Illinois",
                          "IN" => "Indiana",
                          "IA" => "Iowa",
                          "KS" => "Kansas",
                          "KY" => "Kentucky",
                          "LA" => "Louisiana",
                          "ME" => "Maine",
                          "MD" => "Maryland",
                          "MA" => "Massachusetts",
                          "MI" => "Michigan",
                          "MN" => "Minnesota",
                          "MS" => "Mississippi",
                          "MO" => "Missouri",
                          "MT" => "Montana",
                          "NE" => "Nebraska",
                          "NV" => "Nevada",
                          "NH" => "New Hampshire",
                          "NJ" => "New Jersey",
                          "NM" => "New Mexico",
                          "NY" => "New York",
                          "NC" => "North Carolina",
                          "ND" => "North Dakota",
                          "OH" => "Ohio",
                          "OK" => "Oklahoma",
                          "OR" => "Oregon",
                          "PA" => "Pennsylvania",
                          "RI" => "Rhode Island",
                          "SC" => "South Carolina",
                          "SD" => "South Dakota",
                          "TN" => "Tennessee",
                          "TX" => "Texas",
                          "UT" => "Utah",
                          "VT" => "Vermont",
                          "VA" => "Virginia",
                          "WA" => "Washington",
                          "WV" => "West Virginia",
                          "WI" => "Wisconsin",
                          "WY" => "Wyoming",
                          "  " => "----- canadian -----",
                          "AB" => "Alberta",
                          "BC" => "British Columbia",
                          "MB" => "Manitoba",
                          "NB" => "New Brunswick",
                          "NL" => "Newfoundland and Labrador",
                          "NT" => "Northwest Territories",
                          "NS" => "Nova Scotia",
                          "NU" => "Nunavut",
                          "ON" => "Ontario",
                          "PE" => "Prince Edward Island",
                          "QC" => "Quebec",
                          "SK" => "Saskatchewan",
                          "YT" => "Yukon",
                          "   " => "------ british ------",
                          "England" => "England",
                          "Northern Ireland" => "Northern Ireland",
                          "Scotland" => "Scotland",
                          "Wales" => "Wales",
                          "    " => "---- australian ----",
                          "ACT" => "Australian Capital Territory",
                          "NSW" => "New South Wales",
                          "NT " => "Northern Territory",
                          "QLD" => "Queensland",
                          "SA" => "South Australia",
                          "TAS" => "Tasmania",
                          "VIC" => "Victoria",
                          "WA " => "Western Australia",
                          "     " => "----- mexican -----",
                          "AGS" => "Aguascalientes",
                          "BCN" => "Baja California Norte",
                          "BCS" => "Baja California Sur",
                          "CAM" => "Campeche",
                          "CHIS" => "Chiapas",
                          "CHIH" => "Chihuahua",
                          "COAH" => "Coahuila",
                          "COL" => "Colima",
                          "DF" => "Distrito Federal",
                          "DGO" => "Durango",
                          "GTO" => "Guanajuato",
                          "GRO" => "Guerrero",
                          "HGO" => "Hidalgo",
                          "JAL" => "Jalisco",
                          "MEX" => "Mxico (Estado de)",
                          "MICH" => "Michoacn",
                          "MOR" => "Morelos",
                          "NAY" => "Nayarit",
                          "NL " => "Nuevo Len",
                          "OAX" => "Oaxaca",
                          "PUE" => "Puebla",
                          "QRO" => "Quertaro",
                          "QROO" => "Quintana Roo",
                          "SLP" => "San Luis Potos",
                          "SIN" => "Sinaloa",
                          "SON" => "Sonora",
                          "TAB" => "Tabasco",
                          "TAMPS" => "Tamaulipas",
                          "TLAX" => "Tlaxcala",
                          "VER" => "Veracruz",
                          "YUC" => "Yucatn",
                          "ZAC" => "Zacatecas",
                          "      " => "----- brazilian -----",
                          "AC" => "Acre",
                          "AL " => "Alagoas",
                          "AP" => "Amap",
                          "AM" => "Amazonas",
                          "BA" => "Baha",
                          "CE" => "Cear",
                          "DF " => "Distrito Federal",
                          "ES" => "Espirito Santo",
                          "GO" => "Gois",
                          "MA " => "Maranho",
                          "MT " => "Mato Grosso",
                          "MS " => "Mato Grosso do Sul",
                          "MG" => "Minas Geras",
                          "PR" => "Paran",
                          "PB" => "Paraba",
                          "PA " => "Par",
                          "PE " => "Pernambuco",
                          "PI" => "Piau",
                          "RN" => "Rio Grande do Norte",
                          "RS" => "Rio Grande do Sul",
                          "RJ" => "Rio de Janeiro",
                          "RO" => "Rondnia",
                          "RR" => "Roraima",
                          "SC " => "Santa Catarina",
                          "SE" => "Sergipe",
                          "SP" => "So Paulo",
                          "TO" => "Tocantins",
                          "       " => "----- chinese -----",
                          "Anhui" => "Anhui",
                          "Beijing" => "Beijing",
                          "Fujian" => "Fujian",
                          "Gansu" => "Gansu",
                          "Guangdong" => "Guangdong",
                          "Guangxi Zhuang" => "Guangxi Zhuang",
                          "Guizhou" => "Guizhou",
                          "Hainan" => "Hainan",
                          "Hebei" => "Hebei",
                          "Heilongjiang" => "Heilongjiang",
                          "Henan" => "Henan",
                          "Hubei" => "Hubei",
                          "Hunan" => "Hunan",
                          "Jiangsu" => "Jiangsu",
                          "Jiangxi" => "Jiangxi",
                          "Jilin" => "Jilin",
                          "Liaoning" => "Liaoning",
                          "Nei Mongol" => "Nei Mongol",
                          "Ningxia Hui" => "Ningxia Hui",
                          "Qinghai" => "Qinghai",
                          "Shaanxi" => "Shaanxi",
                          "Shandong" => "Shandong",
                          "Shanghai" => "Shanghai",
                          "Shanxi" => "Shanxi",
                          "Sichuan" => "Sichuan",
                          "Tianjin" => "Tianjin",
                          "Xinjiang Uygur" => "Xinjiang Uygur",
                          "Xizang" => "Xizang",
                          "Yunnan" => "Yunnan",
                          "Zhejiang" => "Zhejiang",
                          "        " => "- - - - - - - - - - - -",
                          "n/a" => "Non-USA / Non-Canadian / Not Listed");
       $this->dropdown_display($list_name, $selected_item, $list);
       return 1;
   }
   
   
  /**************************************************************************
  ** name: list_weight_uom($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the weight uom's
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_weight_uom($list_name) {
       global $PHPSHOP_LANG;
       
       $list = array($PHPSHOP_LANG->_PHPSHOP_SELECT,
                    "LBS" => "Pounds",
                    "KGS" => "Kilograms",
                    "G" => "Grams");
       $this->dropdown_display($list_name, "", $list);
       return 1;
   }



  /**************************************************************************
  ** name: list_country($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the countries
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_country($list_name, $value="") {
     global $PHPSHOP_LANG;
   
     $db = new ps_DB;
     
     $q = "SELECT * from #__pshop_country ORDER BY country_name ASC";
     $db->query($q);
     echo "<select class=\"inputbox\" name=\"$list_name\">\n";
     echo "<option value=\"\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
     while ($db->next_record()) {
       echo "<option value=\"" . $db->f("country_3_code")."\"";
       if ($value == $db->f("country_3_code")) {
	 echo " selected";
       }
       echo ">" . $db->f("country_name") . "</option>\n";
     }
     echo "</select>\n";
     return True;
   }
   
  /**************************************************************************
  ** name: list_currency($list_name, $value)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the countries
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_currency($list_name, $value="") {
     global $PHPSHOP_LANG;
     $db = new ps_DB;
     
     $q = "SELECT * from #__pshop_currency ORDER BY currency_name ASC";
     $db->query($q);
     echo "<select class=\"inputbox\" name=\"$list_name\">\n";
     echo "<option value=\"\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
     while ($db->next_record()) {
       echo "<option value=" . $db->f("currency_code");
       if ($value == $db->f("currency_code")) {
	 echo " selected";
       }
       echo ">" . $db->f("currency_name") . "</option>\n";
     }
     echo "</select>\n";
     return True;
   }
   
  /**************************************************************************
  ** name: list_currency_id($list_name, $value)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the countries
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_currency_id($list_name, $value="") {
     global $PHPSHOP_LANG;
     $db = new ps_DB;
     
     $q = "SELECT * from #__pshop_currency ORDER BY currency_name ASC";
     $db->query($q);
     echo "<select class=\"inputbox\" name=\"$list_name\">\n";
     echo "<option value=\"\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
     while ($db->next_record()) {
       echo "<option value=" . $db->f("currency_id");
       if ($value == $db->f("currency_id")) {
	 echo " selected";
       }
       echo ">" . $db->f("currency_name") . "</option>\n";
     }
     echo "</select>\n";
     return True;
   }
   
	/**
	* @param int The row index
	* @param int The record id
	* @param string The name of the form element
	* @param string The name of the checkbox element
	* @return string
	*/
	function idBox( $rowNum, $recId, $frmName="adminForm", $name='cid' ) {

			return '<input type="checkbox" id="cb'.$rowNum.'" name="'.$name.'[]" value="'.$recId.'" onclick="ms_isChecked(this.checked, \''.$frmName.'\');" />';

	}
}
 
?>
