<?php
/**
* @version $Id: events.searchbot.php,v 1.7 2004/11/02 20:47:42 mleinmueller Exp $
* @package Mambo_4.5.1
* @copyright (C) 2000 - 2004 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onSearch', 'botSearchEvents' );

// CHECK LANGUAGE
if (!defined( '_CAL_LANG_INCLUDED' )) {
    if (file_exists($mosConfig_absolute_path."/components/com_events/language/".$mosConfig_lang.".php") ) { 
        include_once($mosConfig_absolute_path."/components/com_events/language/".$mosConfig_lang.".php");
    } else { 
        include_once($mosConfig_absolute_path."/components/com_events/language/english.php");
    }
}

/**
* Search method
*
* The sql must return the following fields that are used in a common display
* routine: href, title, section, created, text, browsernav
* @param string Target search string
* @param integer The state to search for -1=archived, 0=unpublished, 1=published [default]
* @param string A prefix for the section label, eg, 'Archived '
*/
function botSearchEvents( $text, $phrase='', $ordering='' ) {
	global $my, $database;
	$_SESSION['searchword'] = $text;

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	$wheres = array();
	switch ($phrase) {
		case 'exact':
			$wheres2 = array();
			$wheres2[] = "LOWER(a.title) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.content) LIKE '%$text%'";
			$where = '(' . implode( ') OR (', $wheres2 ) . ')';
			break;
		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$wheres2 = array();
				$wheres2[] = "LOWER(a.title) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.content) LIKE '%$word%'";
				$wheres[] = implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

	$morder = '';
	switch ($ordering) {
		case 'newest':
		default:
			$order = 'a.created DESC';
			break;
		case 'oldest':
			$order = 'a.created ASC';
			break;
		case 'popular':
			$order = 'a.hits DESC';
			break;
		case 'alpha':
			$order = 'a.title ASC';
			break;
		case 'category':
			$order = 'b.title ASC, a.title ASC';
			$morder = 'a.title ASC';
			break;
	}

	$eventstitle=_CAL_LANG_CAL_TITLE;
	$database->setQuery( "SELECT a.title AS title,"
	. "\n	a.created AS created,"
	. "\n	a.content AS text,"
	. "\n	CONCAT('$eventstitle','/',b.title) AS section,"
	. "\n	CONCAT('index.php?option=com_events&task=view_detail&agid=',a.id) AS href,"
	. "\n	'2' AS browsernav"
	. "\nFROM #__events AS a"
	. "\nINNER JOIN #__categories AS b ON b.id=a.catid AND b.access <='$my->gid'"
	. "\nLEFT JOIN #__sections AS u ON u.id = a.catid"
	. "\nWHERE ($where)"
	. "\n	AND a.state='1' AND a.access<='$my->gid'"
	. "\nORDER BY " . ($morder ? $morder : $order)
	);

	$list = $database->loadObjectList();
	
	//return array_merge( $list );
	return $list;

}
?>