<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @copyright (C) Rob Clayburn
 * @version $Revision: 1.11 $
 */

// MOS Intruder Alerts

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//require_once( "includes/HTML_toolbar.php" );


Class mosform_html_content {
	
	 /**
     * Static method to create the template object
     * @return patTemplate
     */
     
    function &createTemplate() {
    	
        global $option, $mosConfig_absolute_path;
        
        if(file_exists($mosConfig_absolute_path . '/includes/patTemplate/patTemplate.php')){
        	
	        require_once( $mosConfig_absolute_path . '/includes/patTemplate/patTemplate.php' );
	        
        }else{
        	
        	 require_once( $mosConfig_absolute_path . '/components/' . $option . '/patTemplate/patTemplate.php' );
        	 
        }
 
        $tmpl =& patFactory::createTemplate( $option, false, false );

        $tmpl->setRoot( dirname( __FILE__ ) . '/tmpl' );

        return $tmpl;
        
    }
    
    /**
     * draws the view only data with the specified template
     * @param object form
     * @param array of element objects with their group info attached
     * @param array data to populate template with
     * @param array html drop down lists
     */
    function drawViewOnlyTemplate( $oForm, $groupElements, $data, $lists ){
    	
    	global $option, $mosConfig_absolute_path, $mosConfig_live_site, $mainframe;
    	
    	$tmpl =& mosform_html_content::createTemplate();
        
        if(!$oForm->view_only_template){
        	
			$tmpl->setAttribute( 'body', 'src', 'viewonly/standard.html');
			
        }else{
        	
        	$tmpl->setAttribute( 'body', 'src', 'viewonly/' . $oForm->view_only_template );
        }
        
        // load in the patTemplates css file - if it has one!
		
		$ab_css_file = $mosConfig_absolute_path . "/components/$option/tmpl/viewonly/" . $oForm->view_only_template . ".css";
		
		$live_css_file = $mosConfig_live_site . "/components/$option/tmpl/viewonly/" . $oForm->view_only_template. ".css";
		
		if(file_exists($ab_css_file)){
			
			$mainframe->addCustomHeadTag( "<link rel=\"stylesheet\" media=\"screen\" type=\"text/css\" href=\"$live_css_file\"  />" );

		}
		
        $tmpl->setAttribute( 'body', 'parse', 'on' );
        
 		$tmpl->addVar( 'body', 'title', $oForm->form_title );
 		
 		$tmpl->addVar( 'body', 'intro', $oForm->form_introtext );
 		
 		$groupName = "";
 		
 		$groupCounter = 1;
 		
 		foreach($groupElements as $element){
 		
	 		if($groupName != $element->group_name){
	 			
	 			$groupName = $element->group_name;
	 			
	 			$tmpl->addVar( 'body', "group$groupCounter", $groupName );
	 			
	 			$groupCounter ++;
 		
	 		}
	 		
	 		$elName = $element->element_name;
	 		
	 		$tmpl->addVar( 'body', "$elName", $data[$elName] );
 		}
 		//TODO : mosforms : 0.4 : show images 
 		
 		 $tmpl->displayParsedTemplate( 'body' );
    }
    	
    
	/**
	 * writes out a table view for a table! - using pattemplate
	 * @param object table
	 * @param object each table element combined with its group and form data
	 * @param
	 * @param string component name
	 * @param array ordering state info $column=>direction
	 * @param array contains any lists used on the page
	 * @param int page nav limit start
	 * @param string html pagenav 
	 * @param int number of records to show per page
	 */
	 
	 function writeTable( $oTable, $formGroupEls, $elementData, $option, $aOrder, $lists, $limitStart, $pageNav , $pageLimit){
		
		require_once( "includes/HTML_toolbar.php" );
		
		global $mosConfig_live_site, $Itemid, $my, $mainframe, $mosConfig_absolute_path;
		
		mosCommonHTML::loadOverlib();
		
		//mosCommonHTML::loadCalendar(); have to manually do this as loadCaleneder loads a css file which we can't have in the body

		?>
		
		<!-- import the calendar script -->
		<script type="text/javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/calendar/calendar.js"></script>
		
		<!-- import the language module -->
		<script type="text/javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/calendar/lang/calendar-en.js"></script>
			
		<?php $mainframe->addCustomHeadTag( "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"$mosConfig_live_site/includes/js/calendar/calendar-mos.css\" title=\"green\" />" ); ?>
		
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/mambojavascript.js"></script>
		
		<script language="javascript" type="text/javascript">
		
		<!--
		function submitTestForm(){

			var form = document.testform;

			form.submit();
			
			return false;		
		}

		function submitMosformTable(act){
			
			document.getElementById('act').value = act;
			
			if(act == 'filter'){
			
				document.getElementById('limitstart').value = 0;
				
			}
			
			document.mosformtable.submit();
			
			return false;
		
		}
		
		function mosformNav($limitStart){
		
			document.getElementById('limitstart').value = $limitStart;
			
			form = document.mosformtable;

			document.mosformtable.submit();
			
			return false;	
		}
		
		function mosformNavLimit($pageLimit){
			
			document.getElementById('pagelimit').value = $pageLimit;
			
			document.mosformtable.submit();
			
		}
		
		function mosFormNavOrder(orderby, orderdir){
		
			document.getElementById('orderby').value = orderby;
			
			document.getElementById('orderdir').value = orderdir;
			
			document.mosformtable.submit();
		
		}	
			
				//-->
		</script>
		<?php 
		
		$tmpl =& mosform_html_content::createTemplate();
        
        if($oTable->filter_action == 'submitform'){
	
	        $tmpl->addVar( 'filter-form', 'filterform', '1' );
	        
	        
        }else{
        	
        	$tmpl->addVar( 'filter-form', 'filterform', '0' );
        	
        }
        
        if(!$oTable->table_template){
        	
			$tmpl->setAttribute( 'body', 'src', 'table/standard.html');
			
        }else{
        	
        	$tmpl->setAttribute( 'body', 'src', 'table/' . $oTable->table_template );
        	
        }
		
		// load in the patTemplates css file - if it has one!
		
		$ab_css_file = $mosConfig_absolute_path . "/components/$option/tmpl/table/" . $oTable->table_template . ".css";
		
		$live_css_file = $mosConfig_live_site . "/components/$option/tmpl/table/" . $oTable->table_template . ".css";
		
		if(file_exists($ab_css_file)){
			
			$mainframe->addCustomHeadTag( "<link rel=\"stylesheet\" media=\"screen\" type=\"text/css\" href=\"$live_css_file\"  />" );

		}
		
        $tmpl->setAttribute( 'body', 'parse', 'on' );
        
 		$tmpl->addVar( 'body', 'label', $oTable->label );

		$tmpl->addVar( 'body', 'introduction', $oTable->introduction );	
		
		$tmpl->addVar( 'body', 'mosform_pagenav', $pageNav );		

		if($oTable->allow_add <= $my->gid ){ 
			
			$link = sefRelToAbs("index.php?option=com_mosforms&amp;act=viewform&amp;Itemid=$Itemid&amp;mosform=$oTable->form_id&amp;tableid=$oTable->id&amp;rowid=");

			$tmpl->addVar( 'show-add', 'addrecordlink', $link );	
			
			$tmpl->addVar('show-add', 'showAdd', 1);
			
		}		
		
		$aCols = array();
		
		$aLinkElements = array();

		foreach($lists['filters'] as $name => $filter){
			
			$filters[] = array('name'=>$name, 'value'=>$filter);
			
		}

		$tmpl->addRows( 'filters', $filters );	

		$aTableData = array();
		
		$k = 0;

		$rows=array();
		
		$aTableHeadings = array();
		
		//-------- set the table row headings ---------------
		
		foreach($formGroupEls as $el){

			$aCols[] = $el->element_name;

			if( $el->link_to_detail == '1'){
				
				$aLinkElements[] = "$el->element_name";
			
			}
			
			if($el->can_order == '1'){
				
				$aOrder[$el->element_name] == "desc" ? $orderDir = "asc" : $orderDir = "desc";
				
				$aTableHeadings[] =  "<a href='javascript:mosFormNavOrder(\"$el->element_name\", \"$orderDir\")'>$el->element_label</a>";
			
			}else{
				
				$aTableHeadings[] = "$el->element_label";	
				
			}
			
		}
		
		if($oTable->allow_delete <= $my->gid ){
			
			$aTableHeadings[] = "Delete";	
			
		}
	
		$rows[] = $aTableHeadings;
		
		$aNamedData = array();
		
		//---------put in the table data ----------------

		if(is_array($elementData)){
		
			foreach($elementData as $row){ // for each row from the table
	
				$aRow = array();
				
				$aNamedRow = array();
				
				$i = 0;		
				
				$primaryKeyVal = "";	
	
				foreach($row as $key=>$val){ // for each field in the table's row
					
					if(in_array($key, $aCols)){
						
						if(( in_array($key, $aLinkElements) || $key == $oTable->db_primary_key) and ($oTable->allow_view_details <= $my->gid || $oTable->allow_edit_details <= $my->gid )){
							
							if($key == $oTable->db_primary_key){
								
								$primaryKeyVal = $val;
								
							}
													
							$nextaction = "viewtablerowdetails";
							
							if($oTable->allow_edit_details <= $my->gid){
								
								$nextaction = "viewform";
								
							}
							
							$link = sefRelToAbs("index.php?option=com_mosforms&amp;act=$nextaction&amp;Itemid=$Itemid&amp;mosform=$oTable->form_id&amp;rowid=$primaryKeyVal&amp;tableid=$oTable->id");
							
							$aRow[] = "<a href='$link'>$val</a>";
							
							$aNamedRow[$key] = "<a href='$link'>$val</a>";
							
							$aNamedRow["mosform_link"] = $link;
							
						}else{
	
							$aRow[] = "$val";
							
							$aNamedRow[$key] ="$val";
						}
						
						$i ++;
					}
					
				}
				
				if($oTable->allow_delete <= $my->gid ){
					
					$aRow[] = "<input type=\"checkbox\" name='ids[]' value='$primaryKeyVal'>";
					
					$aNamedRow["mosform_delete"] = "<input type=\"checkbox\" name='ids[]' value='$primaryKeyVal'>";
				}	
	
				$rows[] = $aRow;
				
				$aNamedData[] = $aNamedRow;
				
				$k = 1 - $k;
			}	
			
		}	

		// this is used to display a table 
		$tmpl->addVar( 'row', 'value', $rows );
		
		if(count($aNamedData) > 0){
			$tmpl->addVar( 'row-show', 'rowcount', 1 );
		}
		//this is used to display individaully named elements
		
		$tmpl->addRows(  'named-rows', $aNamedData );		
		
			
		// add hidden fields to the form --------------------------
		$aHiddenFields =   array(
		        array( 'name'=>'option', 'value'=>$option, 'id'=>'option' ),
		        array( 'name'=>'orderdir', 'value'=>'', 'id'=>'orderdir' ),
		        array( 'name'=>'orderby', 'value'=>'', 'id'=>'orderby' ),
		        array( 'name'=>'tableid', 'value'=>$oTable->id, 'id'=>'tableid' ),
		        array( 'name'=>'Itemid', 'value'=>$Itemid, 'id'=>'Itemid' ),
		        array( 'name'=>'pagelimit', 'value'=>$pageLimit, 'id'=>'pagelimit' ),
		        array( 'name'=>'limitstart', 'value'=>$limitStart, 'id'=>'limitstart' ),
		        array( 'name'=>'act', 'value'=>'viewtable', 'id'=>'act' )
			);	

		$tmpl->addRows( 'hidden-fields', $aHiddenFields );		
		
		//-------------------------------------------------------
			
		if($oTable->allow_delete <= $my->gid ){
			
			$tmpl->addVar( 'body', 'mosform_deletebutton', "<input class='button' type='button' onclick=\"submitMosformTable('delete')\" value='Delete' name='delete'/>" );	 
		}

		$tmpl->displayParsedTemplate( 'body' );

	}
	
		/**
	 * writes out a table view for a table! - should get replaced with
	 * pattemplate function (see writetable() above)
	 * @param object table
	 * @param object each table element combined with its group and form data
	 * @param
	 * @param string component name
	 * @param array ordering state info $column=>direction
	 * @param array contains any lists used on the page
	 * @param int page nav limit start
	 * @param string html pagenav 
	 * @param int number of records to show per page
	 */
	 
	function writeTableOld( $oTable, $formGroupEls, $elementData, $option, $aOrder, $lists, $limitStart, $pageNav , $pageLimit){
		require_once( "includes/HTML_toolbar.php" );
		global $mosConfig_live_site, $Itemid, $my;
		mosCommonHTML::loadCalendar();	
		mosCommonHTML::loadOverlib(); ?>
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/mambojavascript.js"></script>
		<script language="javascript" type="text/javascript">
		<!--
		function submitTestForm(){

			var form = document.testform;

			form.submit();
			
			return false;		
		}

		function submitMosformTable(act){
			
			document.getElementById('act').value = act;
			
			document.mosformtable.submit();
			
			return false;
		
		}
		
		function mosformNav($limitStart){
		
			document.getElementById('limitstart').value = $limitStart;
			
			form = document.mosformtable;

			document.mosformtable.submit();
			
			return false;	
		}
		
		function mosformNavLimit($pageLimit){
			
			document.getElementById('pagelimit').value = $pageLimit;
			
			document.mosformtable.submit();
			
		}
		
		function mosFormNavOrder(orderby, orderdir){
		
			document.getElementById('orderby').value = orderby;
			
			document.getElementById('orderdir').value = orderdir;
			
			document.mosformtable.submit();
		
		}	
			
				//-->
		</script>
		<?php 

		echo "<h1>$oTable->label</h1>";
		
		echo "<p>$oTable->introduction</p>";	
				
		echo "<form action=\"index.php\" method=\"post\"  name=\"mosformtable\">";
		
		//echo "<form action=\"index.php\" method=\"post\" name=\"mosformtable\" id=\"mosformtableid\" >";
		
		echo "<table  width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" >\n<tr>";
		
		if($oTable->allow_add <= $my->gid ){
			$link = sefRelToAbs("index.php?option=com_mosforms&amp;Itemid=$Itemid&amp;mosform=$oTable->form_id&amp;tableid=$oTable->id&amp;rowid=");
			echo "<span class=\"pagenav\"><a href='$link'>Add Record</a></span>\n";	
		}		
		$aCols = array();
		echo "<br />";
		foreach($lists['filters'] as $name => $filter){
			echo "$name : $filter";
		}
		
		
		
		foreach($formGroupEls as $el){
			$aCols[] = $el->element_name;
			if($el->can_order == '1'){
				
				$aOrder[$el->element_name] == "desc" ? $orderDir = "asc" : $orderDir = "desc";
				echo "<th class='sectiontableheader'><a href='javascript:mosFormNavOrder(\"$el->element_name\", \"$orderDir\")'>$el->element_label</a></th>\n";
			}else{
				echo "<th class='sectiontableheader'>$el->element_label</th>\n";	
			}
		}
		if($oTable->allow_delete <= $my->gid ){
			echo "<th class='sectiontableheader'>Delete</th>";	
		}
		echo "</tr>\n";
		
		$k = 0;
		foreach($elementData as $row){

			$i = 0;
			
			echo "<tr class='sectiontableentry$k'>";
			
			foreach($row as $key=>$val){
				
				if(in_array($key, $aCols)){
					
					if($key == $oTable->db_primary_key and ($oTable->allow_view_details <= $my->gid || $oTable->allow_edit_details <= $my->gid )){
						
						$primaryKeyVal = $val;
						
						$nextaction = "viewtablerowdetails";
						
						if($oTable->allow_edit_details <= $my->gid){
							
							$nextaction = "viewform";
							
						}
						$link = sefRelToAbs("index.php?option=com_mosforms&amp;act=$nextaction&amp;Itemid=$Itemid&amp;mosform=$oTable->form_id&amp;rowid=$primaryKeyVal&amp;tableid=$oTable->id");
						
						echo "<td><a href='$link'>$val</a></td>";
						
					}else{
						
						echo "<td>$val</td>";
						
					}
					
					$i ++;
				}
				
			}
			
			if($oTable->allow_delete <= $my->gid ){
				echo "<td><input type=\"checkbox\" name='ids[]' value='$primaryKeyVal'></td>";	
			}	
			echo "</tr>";
			
			$k = 1 - $k;
		}
		
		echo "</tr>\n</table>";
		
		echo $pageNav;
		
		echo "<input type='hidden' name='option' value='$option' />\n";
		
		echo "<input type='hidden' id='orderdir' name='orderdir' value='' />\n"; 
		
		echo "<input type='hidden' id='orderby' name='orderby' value='' />\n";
		
		echo "<input type='hidden' name='tableid' value='$oTable->id' />\n";
		
		echo "<input type='hidden' name='Itemid' value='$Itemid' />\n";
		
		echo "<input type='hidden' name='pagelimit' value='$pageLimit' />\n";
			
		if($oTable->allow_delete <= $my->gid ){
			
			echo "<input class='button' type='button' onclick=\"submitMosformTable('delete')\" value='Delete' name='delete'/>";
		}
		
		echo "<input type='hidden' name='limitstart' id='limitstart' value='$limitStart' />\n";
		
		echo "<input type='hidden' name='pagelimit' id='pagelimit' value='$pageLimit' />\n";
		
		echo "<input type=\"hidden\" name=\"act\" id=\"act\" value=\"viewtable\" />";
		
		echo "</form>";

	}

	/**
	 * once the form has been sucessfully completed, and if no jump page is
	 * specified then show the thanks message
	 * @param string thanks message title
	 * @param string thanks message string
	 */
	function displayThanks(&$title, &$message){
		require_once( "includes/HTML_toolbar.php" );
		//echo("here is the thanks message:");

	  ?>

          <div class="componentheading"> <?php echo $title ?></div>

          <p> <?php echo $message ?></p>



          <?php 

	}

/**
 * writes out the mosform - USES TEMPALTING SYSTEM
 * @param object form info
 * @param object form groups and elements - the main guts of the form
 * @param int form id
 * @param array array of error messages 
 * @param array default data to insert into the fields
 * @param string form's main error message
 * @param string form encoding type - depends on if there is a file upload in
 * the form
 * @param int table id passed if the form is generated from editing a table row
 * @param int if editing a table row - this is its id
 * @param array any drop down lists used for foreign joins on other database
 * tables

 * @param bol whether the form is being shown in admin(true) or in frontend
 * (false)
 */
	function displayFormNew($oForm, $groupElements, $formId, $arErrors, $data, $form_err_message, $enctype, $tableId, $rowId, $lists, $admin=false){
		
		global $mosConfig_live_site, $Itemid, $mainframe;
		
		if(!$admin){
			
			require_once( "includes/HTML_toolbar.php" );
			
		}?>
		
		<script type="text/javascript" language="Javascript" src="http://swordfish.datasphere-clients.co.uk/includes/js/overlib_mini.js"></script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		
		<!-- import the calendar script -->
		<script type="text/javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/calendar/calendar.js"></script>
		
		<!-- import the language module -->
		<script type="text/javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/calendar/lang/calendar-en.js"></script>
			
		<?php $mainframe->addCustomHeadTag( "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"$mosConfig_live_site/includes/js/calendar/calendar-mos.css\" title=\"green\" />" ); ?>
		
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/mambojavascript.js"></script>
		
		
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/mambojavascript.js"></script>
		
		<script type="text/javascript">
		
			function submit_form(){
				<?php
				foreach($groupElements as $el){
					if($el->elementtype_id == '5' and $el->use_wysiwyg == '1'){
						
						$parsedName = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);
						
						 getEditorContents( "$parsedName", "$parsedName" ) ;
						 
					}
				}?>
				return false;
			}
			
			function submitbutton(button){
			
				if(button=="cancel"){
					
					document.location = 'index2.php?option=com_mosforms&act=tables&task=viewdatabase&cid=' + '<?php echo $tableId; ?>';
							
				}
				
			}
		</script>
		
		<?php 

		$formwidth = $oForm->width;

		$formalign = $oForm->align;
		
		$formTemplate = $oForm->form_template;

	 	//TODO : mosforms : 0.5 : these should be defined in the admin section 

	 	$default_group_css = "left:10px;right:10px;background-color:#DCDCDC;padding:10px;border:0px solid black;";
		
		//echo("<div style=\"text-align:$formalign;\">\n");
		
		if($admin){
			
			$formName = "adminForm";
			
			$rootPath = $mosConfig_live_site . "/administrator/index2.php";
			
			$js = "onsubmit=\"javascript:submit_form();\"";	
			
		}else{
			
			$formName = "mosform1";
			
			$rootPath = $mosConfig_live_site . "/index.php";
			
			$js = "";
			
		}
		// templateing code
		
		$tmpl =& mosform_html_content::createTemplate();
        
        if(!$formTemplate){
        	
			$tmpl->setAttribute( 'body', 'src', 'form/standard.html');
			
        }else{
        	
        	$tmpl->setAttribute( 'body', 'src', 'form/' . $formTemplate );
        	
        }
		
		// load in the patTemplates css file - if it has one!
		
		$ab_css_file = $mosConfig_absolute_path . "/components/$option/tmpl/form/$formTemplate.css";
		
		$live_css_file = $mosConfig_live_site . "/components/$option/tmpl/form/$formTemplate.css";
		
		if(file_exists($ab_css_file)){
			
			$mainframe->addCustomHeadTag( "<link rel=\"stylesheet\" media=\"screen\" type=\"text/css\" href=\"$live_css_file\"  />" );

		}
		
        $tmpl->setAttribute( 'body', 'parse', 'on' );
        
 		$tmpl->addVar( 'body', 'mosform_title', $oForm->form_title );
 		
 		if (count($arErrors != 0) and is_array($arErrors)) {
	
		   $tmpl->addVar( 'body', 'mosform_error', $oForm->err_message ); 
	
		}
		
		$tmpl->addVar( 'body', 'mosform_intro', $oForm->form_introtext ); 
		
		$tmpl->addVar( 'body', 'mosform_form_action', $rootPath . "?option=com_mosforms" ); 
		
		$tmpl->addVar( 'body', 'mosform_form_js', $js);
		
		$tmpl->addVar( 'body', 'mosform_form_name', $formName);
		
		$tmpl->addVar( 'body', 'mosform_form_enctype', $enctype);

	 	$tmpl->addVar( 'body', 'mosform_form_css', "width:$oFormwidth;");
 		 
 		$curGroupID = "";

		$action_id ="";

		$counter = 0;

		$uploadCounter = 1;		
 		
 		//assing the hidden form data
 		
		$aHiddenFields =   array(
	        array( 'name'=>'tableid', 'value'=>$tableId ),
	        array( 'name'=>'mosform', 'value'=>$formId ),
	        array( 'name'=>'rowid', 'value'=>$rowId ),
	        array( 'name'=>'Itemid', 'value'=>$Itemid ),
	        array( 'name'=>'act', 'value'=>'processform' ),
	        array( 'name'=>'option', 'value'=>'com_mosforms' ),
	        array( 'name'=>'form_id', 'value'=>$formId )
		);	

		$tmpl->addRows( 'mosform-hidden-fields', $aHiddenFields );	
 		
		$tmpl->addVar( 'show-reset', 'mosform_form_reset_on', $oForm->reset_button);
		
		$tmpl->addVar( 'show-reset', 'mosform_form_reset_label', $oForm->reset_button_label);
		
		$tmpl->addVar( 'body', 'mosform_form_submit_label', $oForm->submit_button_label);

		$counter = 0;
		
		$curGroupID = "";
		
		$aFormData = array(); //main array to hold all group arrays
		
		$aGroupData = array(); //contains the element data , reset each time its added to aFormData

		foreach($groupElements as $groupelement){
			
			$counter ++;
			
			$aElement = array();

			$elementid = "mosform_$counter";
			
			if($curGroupID != $groupelement->group_id){
			
				if($curGroupID != ""){
				
					$aFormData[] = $aGroupData; // add the element array to the row
				
				}
				
				$aGroupData = array();

				$curGroupID = $groupelement->group_id;
				
				$group_css = $groupelement->group_css;
				
				$rubbish = array("<br />","<br>");

				$group_css = trim(str_replace( $rubbish, "", $group_css));	
				
				$aGroupData['mosform_group_title'] = $groupelement->group_title;	
				
				$aGroupData['mosform_group_id'] = 	$curGroupID;	
				
				$aGroupData['mosform_group_css'] = 	$group_css;	

			}

			$hidden = $groupelement->hidden;

			$groupeltype = $groupelement->elementtype_id;
			
			$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

			$err_msg = "";
			
			if (isset($arErrors[$parsed_name])) {
			
				foreach($arErrors[$parsed_name] as $el_err_msg){
					$err_msg .= "$el_err_msg<br/>";
				}
			
			}	
				    
			if ($groupeltype == '8') { // file upload element has extra error messages 
			
				if (isset($arErrors['ul_userfile'])) {
				
					foreach($arErrors['ul_userfile'] as $el_err_msg){
					
						$err_msg .= "$el_err_msg<br/>";
						
					}
				
				}
				
			}
			
			$aElement['error'] = 	$err_msg;

			if($groupeltype == '7' || $groupeltype == '9' ){

				$elLabel =   $groupelement->element_label  ;		

			}else{	

				if (!$hidden){	

					$elLabel = "<label for=\"$elementid\">" . $groupelement->element_label  . "</label>\n";					
	
				}
			
			}
			
			$echo = false; // makes all draw functions return the html	
					
			switch($groupeltype){

				case '1':

					//this should not be available !!!

				case '2':
					
					$el = mosform_html_content::drawField($groupelement, $elementid, $data, $arErrors, $echo);
					
					break;

				case '3': 
					
					$el = mosform_html_content::drawCheckBox($groupelement, $elementid, $data, $arErrors, $echo);
					
					break;

				case '4': 
					
					$el = mosform_html_content::drawRadioButton($groupelement, $elementid, $data, $arErrors, $echo);
					
					break;

				case '5': 
					
					$el = mosform_html_content::drawTextArea($groupelement, $elementid, $data, $arErrors, $echo);
					
					break;

				case '6': 
					
					$el = mosform_html_content::drawDropDown($groupelement, $elementid, $data, $arErrors, $echo);
					
					break;

				case '7': 

					$el = mosform_html_content::drawText($groupelement, $elementid, $data, $arError, $echo);
					
					break;

				case '8': 
					
					$el = mosform_html_content::drawFileUpload($groupelement, $elementid, $data, $arErrors, $uploadCounter, $echo);
					
					$uploadCounter ++;
					
					break;

				case '9': 
					
					$el = mosform_html_content::drawImage($groupelement, $elementid, $data, $arErrors, $echo);

					break;		
					
				case '10': 
					
					$el = mosform_html_content::drawUsername($groupelement, $elementid, $data, $arErrors, $echo);
					
					break;		
					
				case '11':
					
					$el = mosform_html_content::drawDate($groupelement, $elementid, $data, $echo)	;
				
					break;						
				
				case '12':
				

					if( $groupelement->join_conn_id != '0'){
						
						$el = 	mosform_html_content::drawDbDropDown($lists, $groupelement, $elementid, $echo)	;
					
					}else{
						$el = "";
					}
					
					break;
					
				case '13':
					
					$el = mosform_html_content::drawButton($groupelement, $elementid, $echo);				
					
					break;							
			} // switch
			
			
			$aSingleElement = array("error"=>"$err_msg", "label"=>"$elLabel", "element"=>"$el");
			
			$aGroupData[] = $aSingleElement;
			

			




		}		
		
		$aSingleElement = array(
		array("error"=>"error message", "label"=>"element label text", "element"=>"<input type='checkbox', value='1' />"),
		array("error"=>"error message", "label"=>"element label text", "element"=>"<input type='checkbox', value='1' />")
		); // this works passing it into group-elements
		
		$tmpl->addRows( 'group-elements', $aGroupData );	
		
		$aFormData = array(
		array("mosform_group_title"=> "group title needs to go here"),
		array("mosform_group_title"=> "Another group title needs to go here")
		);
		
	//	$tmpl->addRows( 'groups', $aFormData);
		
		$tmpl->displayParsedTemplate( 'body' );

	}

	
/**
 * writes out the mosform - DOENST USE TEMPLATING SYSTEM!!! :o
 * @param object form info
 * @param object form groups and elements - the main guts of the form
 * @param int form id
 * @param array array of error messages 
 * @param array default data to insert into the fields
 * @param string form's main error message
 * @param string form encoding type - depends on if there is a file upload in
 * the form
 * @param int table id passed if the form is generated from editing a table row
 * @param int if editing a table row - this is its id
 * @param array any drop down lists used for foreign joins on other database
 * tables

 * @param bol whether the form is being shown in admin(true) or in frontend
 * (false)
 */
	function displayForm($oForm, $groupElements, $formId, $arErrors, $data, $form_err_message, $enctype, $tableId, $rowId, $lists, $admin=false){
		
		global $mosConfig_live_site, $Itemid, $mainframe;
		
		if(!$admin){
			
			require_once( "includes/HTML_toolbar.php" );
			
		}
		
		$calenderCSSFile = "<link rel=\"stylesheet\" media=\"all\" type=\"text/css\" href=\"$mosConfig_live_site/includes/js/calendar/calendar-mos.css\"   title=\"green\" />"; 

		$mainframe->addCustomHeadTag( $calenderCSSFile );
		
		//	mosCommonHTML::loadCalendar();	
		
	//	mosCommonHTML::loadOverlib(); 
		?>

	
		<!-- import the calendar script -->
	
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/calendar/calendar.js"></script>
	
		<!-- import the language module -->
	
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/calendar/lang/calendar-en.js"></script>
	
		<script type="text/javascript" language="Javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/overlib_mini.js"></script>
	
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/mambojavascript.js"></script>
		
		<script type="text/javascript">
		
			function submit_form(){
				
				<?php
				foreach($groupElements as $el){
					
					if($el->elementtype_id == '5' and $el->use_wysiwyg == '1'){
						
						$parsedName = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);
						
						 getEditorContents( "$parsedName", "$parsedName" ) ;
						 
					}
					
				}?>
				
				return false;
			}
			
			function submitbutton(button){
			
				if(button=="cancel"){
					
					document.location = 'index2.php?option=com_mosforms&act=tables&task=viewdatabase&cid=' + '<?php echo $tableId; ?>';
							
				}
				
			}
		</script>
		
		<?php 

		$formwidth = $oForm->width;

		$formalign = $oForm->align;

	 	//TODO : mosforms : 0.5 : these should be defined in the admin section 

	 	$default_group_css = "left:10px;right:10px;background-color:#DCDCDC;padding:10px;border:0px solid black;";
		
		echo("<div style=\"text-align:$formalign;\">\n");
		
		if($admin){
			
			$formName = "adminForm";
			
			$rootPath = $mosConfig_live_site . "/administrator/index2.php";
			
			$js = "onsubmit=\"javascript:submit_form();\"";	
			
		}else{
			
			$formName = "mosform" . $oForm->id;
			
			$rootPath = $mosConfig_live_site . "/index.php";
			
			$js = "";
			
		}
		
		echo("<div class=\"componentheading\">" . $oForm->form_title . "</div>\n");
		
		if ((count($arErrors) > 0) and is_array($arErrors)) {
	
		    echo("<p class=\"mosformerror\">" . $oForm->form_errmessage .  "</p>");
	
		}

		if($oForm->form_introtext != ""){

		 	echo("<p>" .  $oForm->form_introtext . "</p>\n");	

		}
			 	
	 	?>
			
		<form action="<?php echo $rootPath; ?>?option=com_mosforms" <?php echo $js;?> method="post" name="<?php echo $formName; ?>" id="<?php echo $formName; ?>"  enctype="<?php echo $enctype; ?>"  >
		
		<?php

		echo("<div style=\"width:$oFormwidth;border:0px solid black;\">\n");

		$curGroupID = "";

		$action_id ="";

		$counter = 0;

		$uploadCounter = 1;	
		
		foreach($groupElements as $groupelement){

			$counter ++;

			$elementid = "mosform_$counter";

			if($curGroupID != $groupelement->group_id){

				if($curGroupID != ""){echo "</div>\n";}

				$curGroupID = $groupelement->group_id;
				
				if ($groupelement->group_title != ""){
					
					echo "<div class=\"mosformgrouptitle\" id=\"title$curGroupID\">" . $groupelement->group_title . "</div>\n";
				
				}

				$group_css = $groupelement->group_css;

				$rubbish = array("<br />","<br>");

				$group_css = trim(str_replace( $rubbish, "", $group_css));

				if($group_css == ""){

					echo "<div class=\"mosFormGroup\" id=\"group$curGroupID\" >\n";

				}else{

					echo "<div class=\"mosFormGroup\" style=\"$group_css\"  id=\"group$curGroupID\" >\n";

				}

			}

			$hidden = $groupelement->hidden;
			
//			if ($hidden == "1") {
//
//				$name = $groupelement->element_name;
//
//				$value = $groupelement->default;
//	    			
//	    		echo "<input type=\"hidden\" name=\"$name\" value=\"$value\" />\n ";
//
//			}else{

				$groupeltype = $groupelement->elementtype_id;
				
				$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

				$err_msg = "";
				
				if (isset($arErrors[$parsed_name])) {
				
					foreach($arErrors[$parsed_name] as $el_err_msg){
						$err_msg .= "$el_err_msg<br/>";
					}
				
				}
					    
				if ($groupeltype == '8') { // file upload element has extra error messages 
				
					if (isset($arErrors['ul_userfile'])) {
					
						foreach($arErrors['ul_userfile'] as $el_err_msg){
						
							$err_msg .= "$el_err_msg<br/>";
							
						}
					
					}
					
				}
				
				
				if ($err_msg != "") {

					echo("<div class=\"mosformerror\">$err_msg</div>\n");
						    
				}


				if($groupeltype == '7' ){

					echo "<div class=\"mosFormText\">" . $groupelement->element_label  . "</div>";		

				}else{	

					if ($groupeltype == '9') { //if its an image then you dont need the label html tag
					
						echo "<div class=\"mosFormLabel\">" . $groupelement->element_label  . "</div>\n";		
					    
					}else{

						if (!$hidden){
							
							if($groupeltype != '13'){ // dont show the label for the button
								
								echo "<div class=\"mosFormLabel\"><label for=\"$elementid\">" . $groupelement->element_label  . "</label></div>\n";
								
							}					
			
						}

					}

				
				}	
					
				switch($groupeltype){

					case '1':

						//this should not be available !!!

					case '2': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawField($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;

					case '3': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawCheckBox($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;

					case '4': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawRadioButton($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;

					case '5': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawTextArea($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;

					case '6': 
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawDropDown($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;

					case '7': 

						mosform_html_content::drawText($groupelement, $elementid, $data, $arErrors);

						break;

					case '8': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawFileUpload($groupelement, $elementid, $data, $arErrors, $uploadCounter);
						
						$uploadCounter ++;
						
						echo  "</div>\n";
						
						break;

					case '9': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawImage($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;		
						
					case '10': 
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawUsername($groupelement, $elementid, $data, $arErrors);
						
						echo  "</div>\n";
						
						break;		
						
					case '11':
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawDate($groupelement, $elementid, $data);
						
						echo  "</div>\n";
						
						break;						
					
					case '12':
					
						echo ("<div class=\"mosFormElement\">\n");

						if( $groupelement->join_conn_id != '0'){
							
							mosform_html_content::drawDbDropDown($lists, $groupelement, $elementid)	;
						}
						
						echo  "</div>\n";
						
						break;
						
					case '13':
					
						echo ("<div class=\"mosFormElement\">\n");
						
						mosform_html_content::drawButton($groupelement, $elementid);
										
						echo  "</div>\n";
						
						break;
													
				} // switch

			}

		
		if(count($groupElements) != 0){
			
			echo("<br style=\"clear:both;\" />\n" );
			
			echo("</div>\n");

		}
			
		echo "<input type='hidden' name='tableid' value='$tableId' class=''/>\n";
		
		echo "<input type='hidden' name='mosform' value='$formId' class='' />\n";
		
		echo "<input type='hidden' name='rowid' value='$rowId' class='' />\n";
		
		echo "<input type='hidden' name='Itemid' value='$Itemid'  class='' />\n";
		
		echo "<input type='hidden' name='act' value='processform' class='' />\n";

		echo "<input type='hidden' name='option' value='com_mosforms' class='' />\n";
		
		echo "<input type='hidden' name='form_id' value='" .  $formId . "' class='' />\n";
		
		echo("<br style=\"clear:both;\" />\n" );

		echo("</div>\n");
		
		echo ("<div class=\"mosFormActions\">\n");
			
		if ($oForm->reset_button == "1" ) {
	    
			echo "<input type=\"reset\" class=\"button\" name=\"Reset\" value=\"$oForm->reset_button_label\" />\n";
		} 
		
		if( $oForm->submit_button_label != ""){ // only show the submit button if it has a label
			
			echo  "<input type=\"submit\" class=\"button\" name=\"Submit\" value=\"$oForm->submit_button_label\" />\n " ;
	
		}
		
		echo "</div>"; //end of mosformactions div
		
		echo "<br style=\"clear:both;\" />\n"  ;
	
		echo "</form>\n</div>\n" ;


	}

/**
 * draws the database drop down element
 * @param array list of db drop downs in the form
 * @param object current element
 * @param string element id
 * @param bol directly write out the element (true) or return the html (falase)
 */
 
   function drawDbDropDown($lists, $groupelement, $id, $echo=true ){
   		
		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$str = ($lists[$parsed_name]['dropdown']);
		
		//put in the id

		$strReplace = "<select id=\"$id\"";
		
		$str = preg_replace("/(<select)/", $strReplace , $str);
		
		if($echo){
		
			print_r( $str );
			
		}else{
			
			return $str;
			
		}

   }
							

	function drawField($groupelement, $id, $data, $arErrors, $echo=true ){

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);
		
		$size = $groupelement->element_field_width;
		
		$maxlength = $groupelement->maxlength;
		
		if ($maxlength == "0" or $maxlength == "") {
			
			$maxlength = $size;
		}

		if(isset($data[$parsed_name])) {
			
			$value = $data[$parsed_name];
			
		}else{
			
			$value = $groupelement->default;
			
		}

		if($groupelement->eval == "1") {
			
			@eval("\$value = $value;");
			
		}
				
		
		if($groupelement->password == "1"){
			
			$type = "password";
			
		}else{
			
			$type = "text";
			
		}
		
		if($groupelement->hidden == '1'){
			
			$type = "hidden";
			
		}
		
		$value = 	stripslashes(urldecode($value));

		$str .= "<input class=\"inputbox\" type=\"$type\" name=\"$parsed_name\" id=\"$id\" size=\"$size\" maxlength=\"$maxlength\" value=\"$value\" />\n";

		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}	
	
	}



	function drawCheckBox($groupelement, $id, $data, $arErrors, $echo=true ){

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$arVals = split("\|", $groupelement->dd_values);
		
		$arTxt = split("\|", $groupelement->dd_text);

		$arSelected = array();
		
		$arSelected = split("\|", $groupelement->dd_intial_selection);
		
		if(isset($data[$parsed_name])){
			
			$arSelected = $data[$parsed_name]	;
			
		}
 
		//TODO : mosforms : 0.4 : test if checkboxes are selected when passing data to them eg when its value = "somerandomtext"
		
		for($ii = 0; $ii < count($arVals); $ii++) {
			
			$thisId = $id . "_" . $ii;

			if(in_array($arVals[$ii], $arSelected) || $data[$parsed_name] == '1' || $data[$parsed_name] == '-1' || strtolower($data[$parsed_name]) == 'yes'){
					
				$str .= "<label for='$thisId'>$arTxt[$ii]</label><input type=\"checkbox\" name=\"$parsed_name" . "[]" . "\" value=\"$arVals[$ii]\" id=\"$thisId\" checked=\"checked\" />\n";
				
			}else{

				$str .= "<label for='$thisId'>$arTxt[$ii]</label><input type=\"checkbox\" name=\"$parsed_name" . "[]" . "\" value=\"$arVals[$ii]\" id=\"$thisId\" />\n";

			}
			
		}
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}
		
	}


	function drawRadioButton($groupelement, $id, $data, $aErrors, $echo=true ){
		
		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$arVals = split("\|", $groupelement->dd_values);
		
		$arTxt = split("\|", $groupelement->dd_text);
		
		$arSelected = split("\|", $groupelement->dd_intial_selection);
		
		if(isset($data[$parsed_name])){
			
			$arSelected = array($data[$parsed_name])	;
			
		}
		
		for($ii = 0; $ii < count($arVals); $ii++) {
			
			$thisId = $id . "_" . $ii;
			
			if(in_array($arVals[$ii], $arSelected)){
					
				$str .= "<label>$arTxt[$ii]<input type=\"radio\" name=\"$parsed_name\" value=\"$arVals[$ii]\" id=\"$thisId\" checked=\"checked\" /></label>\n";

			}else{
					
				$str .= "<label>$arTxt[$ii]<input type=\"radio\" name=\"$parsed_name\" value=\"$arVals[$ii]\" id=\"$thisId\" />\n</label>";

			}
		}
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}			
	}

	function drawTextArea($groupelement, $id, $data, $arErrors, $echo=true ){

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$use_wysiwyg = $groupelement->use_wysiwyg;
		
		$cols = $groupelement->element_width;

		$rows = $groupelement->element_height;
		
		if(isset($data[$parsed_name])) {
		
			$value = $data[$parsed_name];
			
		}else{
		
			$value = $groupelement->default;
			
		}
		
		$value = 	stripslashes(urldecode($value));
		
		if($use_wysiwyg){
			//TODO: mosforms : 0.4 : work out how to pass this to the $str variable rahter than echoing it
			editorArea( "$parsed_name",  $value , "$parsed_name", '100%', '200', "$cols", "$rows" ) ;
			 
		}else{
					
			$str .= "<textarea class=\"inputbox\" name=\"$parsed_name\" id=\"$id\" cols=\"$cols\" rows=\"$rows\">" . $value . "</textarea>\n";

		}
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}	
		
	}


	function drawDropDown($groupelement, $id, $data, $arErrors, $echo=true ){

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$vals = $groupelement->dd_values;

		$txt = $groupelement->dd_text;

		if(isset($data[$parsed_name])) {
		
			$intital_value = $data[$parsed_name];
			
		}else{
		
			$intital_value = $groupelement->dd_intial_selection;
			
		}

		$arVals = split("\|", $vals);

		$arTxt = split("\|", $txt);

		$multiple = $groupelement->multiple;

		$str = "<select class=\"inputbox\"";

		if($multiple == "on"){

			$name .= "[]"; //add this in to allow for multiple selections //

			$str .=  " multiple=\"multiple\" ";

		}	

		$str .= " name=\"$parsed_name\" id=\"$id\" ";

		$str .= ">\n";

		$i = 0;

		foreach($arVals as $tmpval){

			$tmptxt = addslashes(htmlspecialchars($arTxt[$i]));
			
			//$tmpval = addslashes(htmlspecialchars($tmpval));

			$str .= "<option value=\"$tmpval\" ";

			if($tmpval == $intital_value){
				
				$str .=  "selected=\"selected\" ";

			}

			$str .= ">$tmptxt</option>\n";

			

			$i++;

		}

		$str .= "</select>\n";
			
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}	

	}

	function drawText($groupelement, $data, $id, $echo=true ){}


/**
 * creates the upload file elements
 * @param object upload element to draw
 * @param int element id
 * @param array existing data
 * @param array error messages
 * @param int counter for upload field
 */
	function drawFileUpload($groupelement, $elementid, $data, $arErrors, $uploadCount = '1', $echo=true ){
		
		//TODO: mosforms : 0.4 : when form contains error the file upload selected is not maintained
			
		$ul_max_file_size = $groupelement->ul_max_file_size;
		
		$ul_directory = $groupelement->ul_directory;
		
		$ul_file_types = $groupelement->ul_file_types;
		
		$ul_file_increment = $groupelement->ul_file_increment;
		
		$ul_email_file = $groupelement->ul_email_file;

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);
		
		if(isset($_FILES[$parsed_name]['name'])){
			
			$value = $_FILES[$parsed_name]['name'];
			
		}else{
			
			$value = $groupelement->default;
			
		}
		
		$str .=('<input type="hidden" name="' . $parsed_name . '[ul_max_file_size]" value="' . $ul_max_file_size . '" />' . "\n");
		
		$str .=('<input type="hidden" name="' . $parsed_name . '[ul_directory]" value="' . $ul_directory . '" />' . "\n");
		
		$str .=('<input type="hidden" name="' . $parsed_name . '[ul_file_types]" value="' . $ul_file_types . '" />' . "\n");
		
		$str .=('<input type="hidden" name="' . $parsed_name . '[ul_file_increment]" value="' . $ul_file_increment . '" />' . "\n");
		
		$str .=('<input type="hidden" name="' . $parsed_name . '[ul_email_file]" value="' . $ul_email_file . '" />' . "\n");

		$str .=  '<input name="' . $parsed_name . '" value="' . $value . '" type="file" id="' . $elName . $elementid . '" />' . "\n";
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}		
	
	}



	function drawImage($groupelement, $data, $echo=true ){

		global $mosConfig_absolute_path;
		
		$align =  $groupelement->image_float;
		
		if($align !="none" and $align != ""){
			
			$style = "style=\"float:$align;\"";
			
		}else{
			
			$style = "";
			
		}		

		if($groupelement->link_url != ""){
			
			$str .= "<a href=\"" . $groupelement->link_url . " \" target=\"_blank\" />";
			
			$str .=('<img ' .$style . ' src="images/stories/' . $groupelement->image_name . '" alt="' . $groupelement->image_name  . '"/>' . "\n");
			
			$str .= "</a>";
			
		}else{
			
			$str .=('<img ' .$style . ' src="images/stories/' . $groupelement->image_name . '" alt="' . $groupelement->image_name  . '"/>' . "\n");
			
		}	
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}			

	}

	function drawUsername($groupelement, $id, $echo=true ){

		global $my;

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$value = $my->username;

		$str .= "<input type=\"hidden\" name=\"$parsed_name\" value=\"$value\" id=\"$id\" />\n";
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}
			
	}
	
	function drawDate($groupelement, $id, $data, $echo=true ){
		
		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);
		
		if(isset($data[$parsed_name])) {
			
			$value = $data[$parsed_name];
			
		}else{
			
			$value = $groupelement->default;
			
		}
		
		$str = '<input class="text_area" type="text" name="' .  $parsed_name  .'" size="25" maxlength="19" value="' . $value  . '" id="' . $id . '"  />';
	
		$str .= "\n" . '<input type="reset" class="button" value="..." onClick="return showCalendar(\'' .  $id . '\', \'y-mm-dd\');" />';
				
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
			
		}
	
	}
	
	/**
	 * draw a button
	 * @param object element
	 * @param element html id
	 * @param bol return string (false) or write out now
	 */
	 
	function drawButton($groupelement, $id, $echo=true ){
	
		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);

		$js = str_replace( "'", '"', $groupelement->button_javascript);
	
		$str = "<input type='button'  class='button' id='$id' onclick='$js' name='$parsed_name' value='$groupelement->element_label' />";
		
		if($echo){
		
			echo $str;
			
		}else{
			
			return $str;
				
		}		 
		
	}

}// end class

?>

