<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2004 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: mbfcontent.searchbot.php,v 1.1 2004/12/09 23:50:12 akede Exp $
//

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onSearch', 'botSearchMBFContent' );

/**
* Search method
*
* The sql must return the following fields that are used in a common display
* routine: href, title, section, created, text, browsernav
* @param string Target search string
* @param integer The state to search for -1=archived, 0=unpublished, 1=published [default]
* @param string A prefix for the section label, eg, 'Archived '
*/
function botSearchMBFContent( $text, $phrase='', $ordering='' ) {
	global $my, $database;
	global $mosConfig_abolute_path, $mosConfig_lang, $mosConfig_offset;
	$_SESSION['searchword'] = $text;
	
	$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	$wheres = array();
	switch ($phrase) {
		case 'exact':
			$where = "LOWER(mbfc.value) LIKE '%$text%'";
			break;
		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$wheres[] = "LOWER(mbfc.value) LIKE '%$word%'";
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

	$morder = '';
	switch ($ordering) {
		case 'newest':
		default:
			$order = 'a.created DESC';
			break;
		case 'oldest':
			$order = 'a.created ASC';
			break;
		case 'popular':
			$order = 'a.hits DESC';
			break;
		case 'alpha':
			$order = 'a.title ASC';
			break;
		case 'category':
			$order = 'b.title ASC, a.title ASC';
			$morder = 'a.title ASC';
			break;
	}

	$database->setQuery( "SELECT a.title AS title,"
	. "\n a.created AS created,"
	. "\n a.introtext,"
	. "\n CONCAT( CONCAT_WS( '/', u.title, b.title ), ' - ', mbfl.name) AS section,"
	. "\n CONCAT( 'index.php?option=com_content&task=view&lang=', mbfl.iso, '&id=', a.id  ) AS href,"
	. "\n '2' AS browsernav,"
	. "\n a.id as id, mbfl.mambo as mbflang"
	. "\n FROM #__content AS a"
	. "\n INNER JOIN #__categories AS b ON b.id=a.catid AND b.access <= '$my->gid'"
	. "\n LEFT JOIN #__sections AS u ON u.id = a.sectionid"
	. "\n LEFT JOIN #__mbf_content as mbfc ON reference_id = a.id"
	. "\n LEFT JOIN #__mbf_language as mbfl ON mbfc.language_id = mbfl.id"
	. "\n WHERE ( $where )"
	. "\n AND a.state = '1' AND a.access <= '$my->gid'"
	. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now' )"
	. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )"
	. "\n AND mbfc.reference_table = 'content'"
	. "\n ORDER BY $order"
	);
	
	$rows = $database->loadObjectList();
	
	// In order to make the output syntax conform with the search fields we have to adjust the
	// object attributes. It is necessary to do this later because of the content translation
	for( $i=0; $i<count($rows); $i++ ) {
		$row =& $rows[$i];
		$row->text = $row->introtext;
	}
	
	return $rows;
}
?>