<?php

/*
 * shared functions between the admin and front end
 */
 


/**
  * switches the database depending on the table connection or mosform id
  * @param object table
  * @param string component name
  * @return array (database object, table name);
  */
  
 function switchDatabase($oTable, $option, $oConn){
 
  	global $database;
 	
 	if( $oTable->connection_id != '-1'){
		
		$mosformDb = $oConn->loadTableConnectionDB($oTable->connection_id, $option);

		$table = $oTable->db_table_name;
		
	}else{
	
		$mosformDb = $database;
		
		$table = "#__mosform_formdata_" . $oTable->form_id;
			
	}
	
	return array($mosformDb, $table);	
 }
 

 /**
* this parses all the element data to be shown in the table and replaces any
* data marked as a foreign key with the foriegn key value
* @param object origional element data
* @param object form elements
*/
  
function getForiegnKeys($elementData, $formGroupEls){
  	
  	global $database;
	 
  	foreach($formGroupEls as $el){ // go through all the elements checking for joins

  		if($el->elementtype_id == "12"){ // a join connection has been set up

  			$cn = new mosForm_Connection( $database );
  			
  			$cn->load($el->join_conn_id);
  		
  			if ($cn->testConnection()) {
	
				$joinDb = new database($cn->host, $cn->user, $cn->password, $cn->database, "");
	
				$table 	= $el->join_db_name;
				$key	= $el->join_key_column;
				$val	= $el->join_val_column;
				$col	= $el->element_name;
	
				// reapeat through all the origional data to swap the foregin key with its text equivalent
				
				for($i=0; $i<count($elementData); $i++ ){
					$data = $elementData[$i];
	
					$DataVal = $data->$col;
					
					$sql = "select $key as value, $val as text from $table where $key = '$DataVal' ";
	
					$joinDb->setQuery($sql);
					
					if($joinDb->query()){
						
						$joinData = $joinDb->loadRow();
						
						$elementData[$i]->$col = $joinData[1];
						
					}else{
						
						echo "db error for $sql <br />";	
						
					}
	
				}
			
  			}else{
  				
  				echo "could not connect to database<br />";
  				
  			}
	
  		}
  			
  	}
  	
  	return $elementData;
  	
  }
 

/**
 * makes the table navigation html to traverse the table data
 * @param int the total number of records in the table
 * @param int number of records to show per page
 * @param int which record number to start at
 */
	 
function pageNav( $total, $pageLimit, $limitStart ){

		$b = $limitStart + $pageLimit;
		
		if($b > $total){ $b = $total;}
		
		$prevLimitStart = $limitStart - $pageLimit;
		
		if($prevLimitStart < 0){$prevLimitStart = 0;}
		
		$pageCount = ceil(($total -1) / $pageLimit);
		
		$nextLimitStart = $limitStart + $pageLimit;
		
		$lastLimit = floor(($total - 1) / $pageLimit) * $pageLimit;
		
		if($nextLimitStart >= $total){$nextLimitStart = $lastLimit;}
				
		$str =  "<table class=\"adminlist\"><tr><th>\n<span class=\"pagenav\">\n";
		
		if($limitStart == 0){
			
			$str .= "&lt;&lt;Start ";
			
		}else{
			
			$str .=  "<a href=\"javascript: mosformNav(0);\">&lt;&lt;Start</a> \n";
			
		}
		
		$str .= "</span>\n<span class=\"pagenav\">\n";
		
		if($limitStart == $prevLimitStart){
			
			$str .= "&lt;Previous ";
			
		}else{
			
			$str .=  "<a href=\"javascript: mosformNav($prevLimitStart);\">&lt;Previous</a> \n";
			
		}

		$str .= "</span>\n\n";
		
		for($i=0;$i<$pageCount;$i++){
			
			$thisLimit = $i * $pageLimit;
			
			$j = $i +1;
			
			if($limitStart == $thisLimit){
				
				$str .= "<span class=\"pagenav\">$j</span> ";
				
			}else{
				
				$str .=  "<span class=\"pagenav\"><a  href=\"javascript: mosformNav($thisLimit);\">$j</a></span> \n";
				
			}
			
		}
		
		$str .= "<span class=\"pagenav\">\n";
		
		if($limitStart == $nextLimitStart){
			
			$str .= "Next&gt; ";
			
		}else{
			
			$str .=  "<a href=\"javascript: mosformNav($nextLimitStart);\">Next&gt;</a> \n";
			
		}
		
		$str .= "</span>\n<span class=\"pagenav\">\n";
		
		if($limitStart == $lastLimit){
			
			$str .= "Last&gt;&gt;";
		}else{
			
			$str .=  "<a href=\"javascript: mosformNav($lastLimit);\">Last&gt;&gt;</a>\n";
		}
		
		$str .= "</span>\n";
		
		$str .=  "</th</tr><tr><td style=\"text-align:center;\">Display # ";
		
		$str .= getLimitBox ($pageLimit  ) ;

		$str .=  " Results $limitStart to $b of $total</td></tr></table>";
		
		return $str;
		
}

	/**
	* Returns the html limit # input box
	* @param string The basic link to include in the href
	* @return string
	*/
	function getLimitBox ( $pageLimit ) {
		$limits = array();
		for ($i=5; $i <= 30; $i+=5) {
			$limits[] = mosHTML::makeOption( "$i" );
		}
		$limits[] = mosHTML::makeOption( "50" );

		// build the html select list
		//$link = sefRelToAbs($link.'&amp;limit=\' + this.options[selectedIndex].value + \'&amp;limitstart='.$this->limitstart);
		return mosHTML::selectList( $limits, 'limit',
		'class="inputbox" size="1" onchange="mosformNavLimit(this.options[this.selectedIndex].value);"',
		'value', 'text', $pageLimit );
	}
	
	/**
	 * adds an forward slash to end of string if one is not already there
	 *@param string to add end slash to 
	 */
	 
	 function addEndSlash($str){
	 	if(!endsWith( $str, "/" )){

	 		$str .= "/";

	 	}
	 	return $str;	
	 }
	 
	 /**
	  * @param string haystack
	  * @param string needle search to end with
	  *@return bol tru if $str ends with $sub
	  */ 
	  
	function endsWith( $str, $sub ) {
	   return ( substr( $str, strlen( $str ) - strlen( $sub ) ) == $sub );
	}
	
	/**
	 * recursive file name incrementation untill no file with exsiting name
	 * exists
	 * @param string intial file name
	 * @param string this recursions file name
	 * @param int file version
	 */
	 
	function incrementFileName($origFileName, $newFileName, $version){
	
		if(file_exists($newFileName)){
			
			$orig_f_ext = substr($origFileName, -4);
			$orig_f_name = substr($origFileName, 0, strlen($origFileName)-4);
			$newFileName = $orig_f_name . $version . $orig_f_ext;
			$version ++;
			$newFileName = incrementFileName($origFileName, $newFileName, $version);
		}	
		return $newFileName;	
	}
	
	/**
 * maintains the session array that contains the state for the table's ordering
 * @param string the current column to order on
 * @param string the direction in which to order the current ordering column
 */
 
function updateOrderSession($orderBy, $orderDir){

	if(!isset($_SESSION['aOrder'])){
		
		$_SESSION['aOrder'] = array();
	
	}
	
	if($orderBy != ''){
		$_SESSION['aOrder'][$orderBy] = $orderDir;
	}
	
}
?>