<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.11 $
 */
 
require_once("../components/" . $option . "/mosform_table.class.php");
 
require_once("../components/" . $option . "/mosforms.class.php");

/**
 * creates a form object to process the forms data
 * @param string component name
 * @param int form id
 * @param int table id
 * @param int row id
 */

function processForm($option, $formId, $tableId, $rowId){
		
	global $database;
	
	$oForm = new mosForms( $database );
		
	$oForm->load($formId);
	
	$oForm->setAdmin(true);
	
	$oForm->processForm($_POST, $tableId, $rowId, $option, '' );
}

/**
 * creates the form, allowing the table view to add/edit forms
 * @param int formid
 * @param string component name
 * @param int row id 
 * @param int table id
 */
 
function showForm($formId, $option, $rowId, $tableId){
	//TODO : mosforms : 0.5 : put "save" button in top right (next to cancel) as in all mambo components
	require_once("../components/" . $option . "/mosforms.html.php");
	
	require_once("../components/" . $option . "/mosform_connection.class.php");

	global $database;
	
	$oForm = new mosForms( $database );
	
	$oForm->setAdmin(true);
	
	$oForm->load($formId);
	
	$row = $oForm;

	$groups = $oForm->getFormGroups( 0 );

	$enctype = $oForm->getFormEncType();
	
	$editable = true;
	
	$admin = true;
	
	if($tableId != '' and $rowId != ''){
		
		$oTable = $oForm->loadTable($tableId, $option);	
	
		$oCnn = new mosForm_Connection( $database );
		
		$oCnn->load( $oTable->connection_id );
		
		$mosformDb = $oCnn->loadTableConnectionDB();
		
		if(!$mosformDb){
			
			echo "could not connect to database";
			
			exit();
			
		}
			
		$table = $oTable->db_table_name;
		
		$key = $oTable->db_primary_key;
		
		$sql = "select * from $table";
		
		$rowId = urldecode($rowId); // if key is text it could contain quotes which will mess up the query

		$sql .= " where $key = '$rowId'";
		
		$mosformDb->setQuery($sql);
	
		$elementData = $mosformDb->loadObjectList();
			
		$formDefaultData = mosObjectToArray($elementData[0]);
		
	}else{
			
		$formDefaultData = $_POST;
		
	}
	
	$lists = $oForm->getForeginKeyDropDowns( $formDefaultData, $option );
	
	//make sure that all the data keys contain alpha numberic chars only
	
	foreach($formDefaultData as $key=>$val){
		
		$key =  preg_replace("/[^A-Za-z0-9]/", "_", $key);
		
		$parsedDefaultData[$key] = $val;
		
	}
	
	mosform_html_content::displayForm($row, $groups, $formId, $arErrors, $parsedDefaultData, $form_err_message, $enctype, $tableId, $rowId, $lists, $editable, $admin);
}
		
/**
* Edit a form
* @param integer form id
* @param string scope?
* @param string component name
*/

function editMosForm($id = 0, $scope = '', $option = 'com_mosforms')
{
	//TODO : mosforms : 0.5 : get generic settings for emails etc and ensure these are entered as default
	global $database, $my;

	$lists = array();
	
	$row = new mosForms($database);

	$row->load($id); 
	
	if (isset($row->checked_out )) { // fail if checked out not by 'me'
	
		if ($row->checked_out && $row->checked_out <> $my->id) {
		
			mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=The form $row->title is currently being edited by another administrator");
		
		} 
	    
		if ($id != "0") {
		
			$row->checkout($my->id);
			
		} else {
		
			$row->scope = $scope;
			
		} 
		
	}

	// get available elements to list as possible email receipt fields//
	$sql = "SELECT element_name AS value, element_label as text 
	FROM #__mosform_formgroup
	LEFT JOIN #__mosform_elements ON #__mosform_formgroup.group_id = #__mosform_elements.group_id
	WHERE #__mosform_formgroup.form_id = '$id'
	and (elementtype_id = '2' or elementtype_id = '5')";

	$database->setQuery($sql);

	$possible_email_receipt_fields = $database->loadObjectList();
	

	$possible_email_receipt_fields[] = mosHTML::makeOption('', _NONE);

	
	if (isset($row->receipt_email)) {
	
	    $receipt_email = $row->receipt_email;
		
	}else{
	
		$receipt_email  = "";
		
	}
	
	$lists['email_receipt_list'] = mosHTML::selectList($possible_email_receipt_fields , 'receipt_email', 'class="inputbox" size="1"', 'value', 'text', $receipt_email );

	$database->setQuery("SELECT  id AS value,  CONCAT_WS(': ', name,  email) as text FROM #__users");

	$users = $database->loadObjectList();

	if (isset($row->action_id)) {
	
	    $action_id = intval($row->action_id);
		
	}else{
	
		$action_id = 0;
		
	}
	
	$lists['userslist'] = mosHTML::selectList($users, 'action_id', 'class="inputbox" size="1"', 'value', 'text', $action_id);
	 
	// get a list of used groups
	
	$sql = "SELECT  #__mosform_formgroup.group_id AS value,  

		#__mosform_groups.group_name as text

		FROM #__mosform_formgroup 

		left join #__mosform_groups 

		on #__mosform_formgroup.group_id = #__mosform_groups.id

		where  #__mosform_formgroup.form_id = '$id' 

		order by  #__mosform_formgroup.ordering";

	$database->setQuery($sql);

	$current_groups = $database->loadObjectList();
	
	$lists['current_grouplist'] = mosHTML::selectList($current_groups, 'current_groups', "class=\"inputbox\" style=\"width:170px;\" size=\"10\" ", 'value', 'text', '/');
	
	// get a list of available groups - need to make the sql only return groups not already listed in mos_mosform_fromgroup for $id
	
	$sql = "SELECT id AS value,  group_name as text FROM #__mosform_groups ";
	
	$i = 0;
	
	foreach($current_groups as $cg){
		
		if ($i == 0) {
			
		    $sql .= " WHERE ";
		    
		}else{
			
			$sql .= " AND ";
			
		}
		
		$val = $cg->value;
		
		$sql .= " id <> '$val'";
		
		$i++;
		
	} 

	$database->setQuery($sql);

	$groups = $database->loadObjectList();

	$lists['grouplist'] = mosHTML::selectList($groups, 'groups', "class=\"inputbox\" size=\"10\" style=\"width:170px;\" ", 'value', 'text', null); 	
	
	// make a list of alignment options
	
	$align_options = array(mosHTML::makeOption('left', 'left'), mosHTML::makeOption('center', 'center'), mosHTML::makeOption('right', 'right'));

	$lists['align'] = mosHTML::selectList($align_options, 'align', "class=\"inputbox\" size=\"1\" ", 'value', 'text', $row->align);
	
	$tabs = new mosTabs(1);
	
	$lists['menuselect'] = mosAdminMenus :: MenuSelect();
	
	$and = "\n AND link like 'index.php?option=com_mosforms&act=viewform&mosform=".$row->id."'";

	$menus = mosAdminMenus :: Links2Menu('url', $and);
	
	if($row->id == '0'){ // this is a new form so fill in some default values
	
		$row->reset_button_label = _RESET;
		
		$row->submit_button_label = _SUBMIT;
		
	}	
	
	//get the view only templates
	
	$templates =  mosReadDirectory("../components/$option/tmpl/viewonly", ".htm");
	
		foreach ($templates as $file) {
			
			if(substr($file, strlen($file)-4, strlen($file))  != ".css") {

					$oTemplates[] = mosHTML::makeOption($file);
			
			}
		} 
	
	$lists['viewOnlyTemplates'] = mosHTML::selectList($oTemplates, 'view_only_template', 'class="inputbox"','value','text',$row->view_only_template);

	//get the form templates
	
	$oTemplates = array();
	
	$templates =  mosReadDirectory("../components/$option/tmpl/form", ".htm");
	
		foreach ($templates as $file) {

				if(substr($file, strlen($file)-4, strlen($file))  != ".css") {
					
					$oTemplates[] = mosHTML::makeOption($file);
					
				}

		} 
		
	// build list of users

	$active = (intval($row->created_by) ? intval($row->created_by) : $my->id);
	
	$lists['created_by'] = mosAdminMenus :: UserSelect('created_by', $active);
		
	$lists['formTemplates'] = mosHTML::selectList($oTemplates, 'form_template', 'class="inputbox"','value','text',$row->form_template);	
	
	html_form_content::editForms($option, $row, $tabs, $lists, $menus);
} 

/**
* Save the form
* @param string component name
* @return boolean false if not saved
*/

function saveMosForm( $aData )
{
	global $database, $my;

	$oForm = new mosForms($database);
	
	if (!$oForm->bind($aData)) {
		
		echo "<script> alert('BIND:- " . $oForm->getError() . "'); window.history.go(-1); </script>\n";
		
		exit();
		
	} 

	if (!$oForm->check()) {
		
		echo "<script> alert('CHECK:-" . $oForm->getError() . "'); window.history.go(-1); </script>\n";

		exit();
		
	} 

	if (!$oForm->store(true)) {
		
		echo "<script> alert('(true) STORE:-" . $oForm->getError() . "'); window.history.go(-1); </script>\n";

		exit();
		
	} 

	$oForm->checkin();

	return $oForm->id; 

} 

/**
* Save the group
* @param string component name
* @param int form id
* @param string csv of group names to associate with the form
* @param bol record in database
* @param string component task
* @param string component action
* @return bol true if you should display the form list, false if you're
* redirected elsewhere
*/

function saveMosFormFormGroup($option, $form_id, $current_groups_str, $record_in_database = '1', $task ='', $act='')
{
	
	global $database, $my;
	
	require_once("../components/$option/mosform_connection.class.php");
	
	$oForm = new mosForms($database);
	
	$oForm->load($form_id);

	
	$oTable = new mosForm_Table( $database );
	
	if($oForm->table_id == '0'){
		
		$oForm->findAndUpdateTableId();	
		
	}
	
	$oTable->load($oForm->table_id);
	
	$oConn = new mosForm_Connection( $database );
	
	$oConn->load( $oTable->connection_id);
	
	$tableDatabase = $oConn->loadTableConnectionDB();
	
	$dbTableName = $oTable->db_table_name;
	
	$menu = mosGetParam($_POST, 'menu', 'mainmenu');
	
	$menuid = mosGetParam($_POST, 'menuid', 0);
	
	$database->setQuery("delete from #__mosform_formgroup where form_id = '$form_id'");	// delete the old form groups 

	if (!$database->query()) {
	
		$msg .= $database->getErrorMsg() . "\n";
	} 

	if ($record_in_database == '1') {
		
		if (!$oForm->DatabaseTableExists( $dbTableName, $tableDatabase )) {//need to pass the correct database obj here
		
			$oForm->CreateFormTable( );
			
		} else {
			
			$oForm->AmmendTable( $dbTableName, $tableDatabase );
			
		} 
		
	} 
	
	$orderid = 1;
	
	$current_groups = explode(",", $current_groups_str);

	$err = false;
	
	foreach($current_groups as $group_id) {

		$sql = "insert into #__mosform_formgroup (form_id, group_id, ordering) values ('$form_id','$group_id','$orderid')"; 

		$database->setQuery($sql);
		
		if (!$database->query()) {
		
			$err = true;
			
			echo $database->getErrorMsg() . "\n";
			
		} 
		
		$orderid ++;
	} 

	
	switch ($task) {

		case 'go2menu' :
		
			mosRedirect("index2.php?option=com_menus&menutype=".$menu);
			
			break;
	
		case 'go2menuitem' :
		
			mosRedirect("index2.php?option=com_menus&menutype=".$menu."&task=edit&hidemainmenu=1&id=".$menuid);
			
			break;
	
		case 'menulink' :
			
			$oForm = new mosForms( $database ); 
			
			$oForm->load($form_id);

			$oForm->menuLink( $option, $act, "viewform", "mosform=$form_id");

			return false;
			
			break;
	
	
		default :
		
			return true;
			
			break;

	}
	
	return false;
} 

/**
* copy a form
* @param array of form ids to copy
* @param string component name
*/
function copyForm( $cid, $option ){
	if (!is_array( $cid ) || count( $cid ) < 1) {
		echo "<script> alert('Select an item to move'); window.history.go(-1);</script>\n";
		exit;
	}
	
	foreach($cid as $id){
		$row = new mosForms($database);	
		$ar = array();
		$row->copyRow( $id, $ar	);
	}
	
	displayMosFormElement($option);
}

/**
* Display all the available forms
* @param string component name
*/

function displayMosForm($option, $msg='')
{
	global $database, $mainframe, $mosConfig_offset; 
	// get the total number of records
	$database->setQuery("SELECT count(*) FROM #__mosform_forms");

	$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_forms LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		echo $database->stderr();

		return false;
	} 

	html_form_content::showAllForms($rows, $pageNav, $option, $msg);
} 

/**
* Delete a form
* @param integer form id
* @param string component name
*/

function deleteMosForm($cid, $option)
{
	global $database;
	$msg = '';
	for ($i = 0, $n = count($cid); $i < $n; $i++) {

		$sql = "delete from #__mosform_forms where id = '" . $cid[$i] . "'";
		$database->setQuery($sql);
		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 
		
		$sql = "drop table #__mosform_formdata_" . $cid[$i] ;
		$database->setQuery( $sql );
		// TODO : mosforms : 0.5 : ask if the user wants to delete database table
		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 
	} 

	displayMosForm($option);
	
} 


/**
* Assign groups to the form once it has been saved
* @param integer form id
* @param string component name
* @param integer defines if the form records results in a database table
*/


//function editFormGroups($id, $option, $record_in_database=null ){
//	
//	global $database, $my;
//	
//	//if record_in_database not specified get the info from the form (with id = $id)
//	if (!isset($record_in_database)) {
//	
//			$database->setQuery("SELECT  record_in_database  FROM #__mosform_forms where id = '$id'");
//			
//			$record_in_database = $database->loadResult();
//	    
//	}
//	
//	$sql = "select COUNT(*) as co from #__mosform_groups";
//	
//	$database->setQuery($sql);
//
//	$count = $database->loadObjectList();
//	
//	$count = $count[0];
//
//	if ($count->co == 0) {
//	    $nogroups = true;
//	}else{
//		$nogroups = false;
//	}
//	// get a list of used groups
//	$sql = "SELECT  #__mosform_formgroup.group_id AS value,  
//
//		#__mosform_groups.group_name as text
//
//		FROM #__mosform_formgroup 
//
//		left join #__mosform_groups 
//
//		on #__mosform_formgroup.group_id = #__mosform_groups.group_id
//
//		where  #__mosform_formgroup.form_id = '$id' 
//
//		order by  #__mosform_formgroup.ordering";
//
//	$database->setQuery($sql);
//
//	$current_groups = $database->loadObjectList();
//	
//	$current_grouplist = mosHTML::selectList($current_groups, 'current_groups', "class=\"inputbox\" size=\"10\" ", 'value', 'text', '/');
//	
//	// get a list of available groups - need to make the sql only return groups not already listed in mos_mosform_fromgroup for $uid
//	$sql = "SELECT  group_id AS value,  group_name as text FROM #__mosform_groups ";
//	$i = 0;
//	foreach($current_groups as $cg){
//		if ($i == 0) {
//		    $sql .= " WHERE ";
//		}else{
//			$sql .= " AND ";
//		}
//		$val = $cg->value;
//		$sql .= " group_id <> '$val'";
//		$i++;
//	} 
//
//	$database->setQuery($sql);
//
//	$groups = $database->loadObjectList();
//	
//	$grouplist = mosHTML::selectList($groups, 'groups', "class=\"inputbox\" size=\"10\" ", 'value', 'text', null); 
//
//	html_content::editFormGroup2($option, $id, $grouplist, $current_grouplist, $record_in_database, $nogroups);
//}





///**
//* Create a talbe to store the forms' data depending upon what groups are assigned to the form
//* @param integer form if
//*/
//
//
//function CreateFormTable($form_id)
//
//{
//	global $database, $my;
//	$sql = "create table #__mosform_formdata_" . $form_id . "( id int not null auto_increment, time_date timestamp not null" ;
//	
//	$current_groups_str = $_POST['current_groups_str'];
//	$arGroups = explode(",", $current_groups_str);
//	$arAddedObj = array();
//		
//	foreach($arGroups as $group_id) {
//		$groupsql = "select * from #__mosform_elements where group_id = '$group_id'";
//		$database->setQuery($groupsql);
//		$elements = $database->loadObjectList();
//		foreach($elements as $obj) {
//			$objname = $obj->element_name;
//			$objname = preg_replace("/[^A-Za-z0-9]/", "_", $objname); // replace all non alphanumeric characters with _
//			if(!in_array($objname, $arAddedObj)){ // any elements that are names the same (eg radio buttons) can not be entered twice into the database
//				$arAddedObj[] = $objname;
//				$objtypeid = $obj->elementtype_id;
//				switch ($objtypeid) {
//					case "2":
//						$objtype = "varchar (255)";
//					case "3":
//						$objtype = "varchar (3)";
//					case "4":
//						$objtype = "varchar (3)";
//					case "5":
//						$objtype = "text ()";
//					case "6":
//						$objtype = "varchar (255)";
//					case "7":
//						$objtype = "";
//					case "8":
//						$objtype = "binary ()";
//					case "9":
//						$objtype = "";
//					case "10":
//						$objtype = "varchar (25)";
//					default:
//						$objtype = "varchar (255)";
//				} 
//				if ($objtype != "") {
//					$sql .= ", $objname $objtype null ";
//				} 
//			}
//		} 
//	} 
//
//	$sql .= ",  primary key (id))";
//	$database->setQuery($sql);
//	if (!$database->query()) {
//		echo $database->getErrorMsg();
//		exit;
//	} 
//} 

///**
//* Alter the forms' data collection table when the forms' groups and/or elements are altered
//* @param integer form id
//* @param string table name (this overrides form id)
//*/
//
//function AmmendTable($form_id, $tableName = '')
//{
//	global $database, $my, $mosConfig_dbprefix;
//	$ammend = false;
//	
//	if($tableName == ''){
//		$tableName = $mosConfig_dbprefix . "mosform_formdata_" . $form_id;	
//	}
//	
//	$sql = "describe $tableName";
//	
//	$database->setQuery($sql);
//	$dbdescriptions = $database->loadObjectList();
//	foreach($dbdescriptions as $dbdescription) {
//		$fieldname = $dbdescription->Field;
//		$exitingfields[] = $fieldname;
//	} 
//
//	$lastfield = $fieldname;
//	
//	$sql = "alter table $tableName " ;
//	if (!isset($_POST['current_groups_str'])) {
//		// get a list of groups used by the form
//		$groupsql = "SELECT  group_id FROM #__mosform_formgroup where form_id = '$form_id'";
//
//		$database->setQuery($groupsql);
//		$groups = $database->loadObjectList();
//
//		echo $database->getErrorMsg();
//		$arGroups = array();
//		foreach($groups as $g) {
//			$arGroups[] = $g->group_id;
//		} 
//	} else {
//		$current_groups_str = $_POST['current_groups_str'];
//		$arGroups = explode(",", $current_groups_str);
//
//	} 
//	$arAddedObj = array();
//	
//	foreach($arGroups as $group_id) {
//		$groupsql = "select * from #__mosform_elements where group_id = '$group_id'";
//		$database->setQuery($groupsql);
//		$elements = $database->loadObjectList();
//		
//		foreach($elements as $obj) {
//			$objname = $obj->element_name;
//			$objname = preg_replace("/[^A-Za-z0-9]/", "_", $objname); // replace all non alphanumeric characters with _
//			if (!in_array($objname, $exitingfields)) { // make sure that the object is not already in the table
//				if(!in_array($objname, $arAddedObj)){ // any elements that are names the same (eg radio buttons) can not be entered twice into the database
//					$arAddedObj[] = $objname;
//					$objtypeid = $obj->elementtype_id;
//					switch ($objtypeid) {
//						case "2":
//							$objtype = "varchar (255)";
//						case "3":
//							$objtype = "varchar (3)";
//						case "4":
//							$objtype = "varchar (3)";
//						case "5":
//							$objtype = "text ()";
//						case "6":
//							$objtype = "varchar (255)";
//						case "7":
//							$objtype = "";
//						case "8":
//							$objtype = "binary ()";
//						case "9":
//							$objtype = "";
//						case "10":
//							$objtype = "varchar (25)";
//						default:
//							$objtype = "varchar (255)";
//					} 
//					if ($objtype != "") {
//						$ammend = true;
//						$sql .= ", add column $objname $objtype null after $lastfield";
//					} 				
//				}
//
//			} 
//		} 
//	} 
//
//
//	if ($ammend) {
//		$database->setQuery($sql);
//		if (!$database->query()) {
//			echo $database->getErrorMsg();
//			exit;
//		} 
//	} 
//} 

/**
* Create a menu item for the form
* @param integer form id
*/

function createMosFormMenu(&$form_id){

	global $database, $mosConfig_absolute_path;

	$menu = new mosMenu($database);

	$menu->type = 'url';

	$menu->link = 'index.php?option=com_mosforms&act=viewform&mosform=' . $form_id;

	$menu->menutype = 'mainmenu';

	$menu->browserNav = 0;

	$menu->ordering = 9999;

	$menu->parent = 0;

	if (!$menu->store()) {
		echo "<script> alert('" . $menu->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$cid = array();

	$cid[ 0 ] = $menu->id;

	$menutype = 'mainmenu';

	$option = 'com_menus';

	$task = 'edit';

	$type= 'url'; //rob: fix for 4.5.2

	$menu->updateOrder("menutype='$menu->menutype' AND parent='$menu->parent'");

	require("$mosConfig_absolute_path/administrator/components/com_menus/url/url.menu.php");
} 

//moved to parent mosform class

///**
// * Link the table item to a menu
// *  @param int table id to create link for
//  * @param string component name
// */
 
//function menuLink($id, $option, $act) {
//
//	global $database;
//
//	$menu = mosGetParam($_POST, 'menuselect', '');
//	$link = mosGetParam($_POST, 'link_name', '');
//
//	$row = new mosMenu($database);
//	$row->menutype = $menu;
//	$row->name = $link;
//	$row->type = 'url';
//	$row->published = 1;
//	$row->link = "index.php?option=$option&act=viewform&mosform=".$id;
//	$row->ordering = 9999;
//	
//
//
//	if (!$row->check()) {
//		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
//		exit ();
//	}
//
//	if (!$row->store()) {
//		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
//		exit ();
//	}
//
//	$row->checkin();
//
//	$row->updateOrder("menutype='$row->menutype' ");
//
//	$msg = $link.' (Link - Static Content) in menu: '.$menu.' successfully created';
//
//	mosRedirect("index2.php?option=$option&act=$act&task=edit&cid=".$id, $msg);
//}
