<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.5 $
 */
 
 require_once("../components/" . $option . "/mosform_connection.class.php");


/**
 * trys to connection to the database
 * @param array/int connection ids to test
 * @param string component name
 * @param string current action
 * @return bol true if connection ok otherwise false
 */
 
function testMosConnection($cid, $option, $act){

	global $database;
	
	$msg = _CONNECTION . " " . _SUCCESSFUL;
	
	if(is_array($cid)){
		
		foreach($cid as $id){
		
			$row = new mosForm_Connection($database);
			
			$row->load($id); 
			
			if($row->testConnection() == false){
				
				$msg = _CONNECTION . " " . _FAILED;
			
			}
		}
			
	}else{
		
		$row = new mosForm_Connection($database);
		
		$row->load($cid); 
		
		if($row->testConnection() == false){
			
			$msg = _CONNECTION . " " . _FAILED;
		
		}
		
	}
	
	
	echo "<span class=\"message\">$msg</span>";
	
	
}

/**
 * lets you edit the connection 
 * @param int connection id - 0 if new connection
 * @param string component name
 * @param string component action
 */
 
function editMosConnection($cid, $option, $act){
	
	global $database, $my;

	$row = new mosForm_Connection($database);

	$row->load($cid); 
		
	html_connection_content::editConnection($row, $option, $act);
}

/**
 * saves the connection to the database
 * @param string component name
 * @param string component action
 */
 
function saveMosConnection($option, $act){
		
	global $database;

	$row = new mosForm_Connection($database);
	
	if($_POST['passwordConf'] != $_POST['password']){
		
		echo "<script> alert('" . _PASSWORDS_DO_NOT_MATCH . "'); window.history.go(-1); </script>\n";

		exit();
	} 		
	
	if($_POST['id'] != '0'){ // if we're editing an existing connection and no new password has been added we want to delete the post password data
		
		if($_POST['password'] == '' ){
			
			unset($_POST['password']);
			
		}
		
	}	
	

	if (!$row->bind($_POST)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 
	
	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 
	
	displayMosConnections($option, $act, '');
}

function copyMosConnection($cid, $option, $act){
	
	global $database;
	
	if(is_array($cid)){	
		
		foreach($cid as $id){
			
			$maxOrder ++;
			
			$row = new mosForm_Connection($database);
			
			$row->load($id);
			
			//remove the id to ensure that we create a new element rather than overwriting the origional element?
			$row->id = null;
			
			if (!$row->check()) {
				
				echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
				
				exit();
			}
			if (!$row->store()) {
				
				echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
				
				exit();
			}
		}
	}
	
	displayMosConnections($option, $act, '');
	
}

function deleteMosConnection($cid, $option, $act){
	
	global $database;

	$msg = '';

	for ($i = 0, $n = count($cid); $i < $n; $i++) {

		if($cid[$i] == '1'){
			
			$msg .= _CAN_NOT_DELETE_FIRST_CONNECTION;
			
		}else{
			
			$sql = "delete from #__mosform_connections where id = '" . $cid[$i] . "'";
	
			$database->setQuery($sql);
	
			if (!$database->query()) {
				$msg .= $database->getErrorMsg() . "\n";
			} 
	
		}

	} 
	
	if($msg == ''){
		
		$msg = _DELETE_CONNECTION_OK;
		
	}

	displayMosConnections($option, $act, $msg);
	
}

/**
 * show list of database connection
 * @param string component name
 * @param string component action
 * @param string message
 */
function displayMosConnections($option, $act, $msg = ''){

	global $database, $mainframe, $mosConfig_offset; 
	// get the total number of records
	$database->setQuery("SELECT count(*) FROM #__mosform_connections");
	
	$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_connections LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		
		echo $database->stderr();

		return false;
	} 

	html_connection_content::showAllConnections($rows, $pageNav, $option, $act, $msg);
}

 function do_publish( $cid, $state){
 	global $database;
	$row = new mosForm_Connection($database);
 	$row->publish($cid, $state);
 }
 ?>
 