<?php
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: ps_product_attribute.php,v 1.17 2005/06/13 20:49:00 soeren_nb Exp $
* @package mambo-phpShop
* Contains code from PHPShop(tm):
* 	@copyright (C) 2000 - 2004 Edikon Corporation (www.edikon.com)
*	Community: www.phpshop.org, forums.phpshop.org
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*
**********************
* CLASS DESCRIPTION
*
* ps_product_attribute
*
* The class is is used to manage the product attributes.
*************************************************************************/
class ps_product_attribute {
  var $classname = "ps_product_attribute";

  /**************************************************************************
  ** name: validate()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/  
  function validate(&$d) {
    $valid = true;
    if ($d["attribute_name"] == "") {
        $d["error"] .= "An attribute name must be entered.";
        $valid = false;
    }
    elseif ($d["old_attribute_name"] != $d["attribute_name"]) {
      $db = new ps_DB;
      $q  = "SELECT attribute_name FROM #__pshop_product_attribute_sku ";
      $q .= "WHERE attribute_name = '" . $d["attribute_name"] . "'";
      $q .= "AND product_id = '" . $d["product_id"] . "'";
      $db->setQuery($q);  $db->query();
      if ($db->next_record()) {
        $d["error"] .= "A unique attribute name must be entered.";
        $valid = false;                                                         
      }
    }
    foreach ($d as $key => $value) {
      if (!is_array($value))
        $d[$key] = addslashes($value);
    }
    return $valid;
  }
  
  /**************************************************************************
  ** name: validate_delete()
  ** created by:
  ** description: 
  ** parameters:
  ** returns:
  ***************************************************************************/  
  function validate_delete(&$d) {
    require_once(CLASSPATH. 'ps_product.php' );
    
    $ps_product = new ps_product;

    $db = new ps_DB;
    $q  = "SELECT product_id FROM #__pshop_product_attribute_sku ";
    $q .= "WHERE product_id = '" . $d["product_id"] . "' ";
    $db->setQuery($q);  $db->query();
    if ($db->num_rows() == 1 and 
             $ps_product->parent_has_children($d["product_id"])) {
      $d["error"] .= "ERROR: Cannot delete last attribute while product has ";
      $d["error"] .= "Items. Delete all Items first.";
      return false;                                                         
    }
  
    return true;

  }
  /**************************************************************************
  ** name: add()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/  
  function add(&$d) {
    if (!$this->validate($d)) {
      return false; 
    }

    $db = new ps_DB;
    $q  = "INSERT INTO #__pshop_product_attribute_sku (product_id,attribute_name,";
    $q .= "attribute_list) VALUES ('" . $d["product_id"] . "','";
    $q .= $d["attribute_name"] . "','" . $d["attribute_list"] . "')";

    $db->setQuery($q);  $db->query();

    /** Insert new Attribute Name into child table **/
    $ps_product = new ps_product;
    $child_pid = $ps_product->get_child_product_ids($d["product_id"]);

    for($i = 0; $i < count($child_pid); $i++) {
      $q  = "INSERT INTO #__pshop_product_attribute (product_id,attribute_name) ";
      $q .= "VALUES ('$child_pid[$i]','" . $d["attribute_name"] . "')";
      $db->setQuery($q);  $db->query();
    }

    return true;
  }

  /**************************************************************************
  ** name: update()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function update(&$d) {
    if (!$this->validate($d)) {
      return false;
    }

    $db = new ps_DB;

    $q  = "UPDATE #__pshop_product_attribute_sku SET ";
    $q .= "attribute_name='" . $d["attribute_name"] . "',";
    $q .= "attribute_list='" . $d["attribute_list"] . "' ";
    $q .= "WHERE product_id='" . $d["product_id"] . "' ";
    $q .= "AND attribute_name='" . $d["old_attribute_name"] . "' ";

    $db->setQuery($q);  $db->query();
    
    if ($d["old_attribute_name"] != $d["attribute_name"]) {
      $ps_product = new ps_product;
      $child_pid = $ps_product->get_child_product_ids($d["product_id"]);

      for($i = 0; $i < count($child_pid); $i++) {
        $q  = "UPDATE #__pshop_product_attribute SET ";
        $q .= "attribute_name='" . $d["attribute_name"] . "' ";
        $q .= "WHERE product_id='$child_pid[$i]' ";
        $q .= "AND attribute_name='" . $d["old_attribute_name"] . "' ";
        $db->setQuery($q);  $db->query();
      }
    }
    return true;
  }

  /**************************************************************************
  ** name: delete()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/  
  function delete(&$d) {
    if (!$this->validate_delete($d)) {
      return false;
    }                                                                           

 
    $db = new ps_DB;

    $q  = "DELETE FROM #__pshop_product_attribute_sku ";
    $q .= "WHERE product_id = '" . $d["product_id"] . "' ";
    $q .= "AND attribute_name = '" . $d["attribute_name"] . "'";

    $db->setQuery($q);  $db->query();
    $ps_product = new ps_product;
    $child_pid = $ps_product->get_child_product_ids($d["product_id"]);

    for($i = 0; $i < count($child_pid); $i++) {
      $q  = "DELETE FROM #__pshop_product_attribute ";
      $q .= "WHERE product_id = '$child_pid[$i]' ";
      $q .= "AND attribute_name = '" . $d["attribute_name"] . "' ";
      $db->setQuery($q);  $db->query();
    }
    return True;
  }

  /**************************************************************************
   ** name: list_attribute($product_id, $attribute_name)
   ** created by: pablo
   ** description: 
   ** parameters: product_id (may be a product or item)
   ** returns:
   ***************************************************************************/
  function list_attribute($product_id) {

    global $PHPSHOP_LANG, $CURRENCY_DISPLAY;
    
    require_once (CLASSPATH . 'ps_product.php' );
    $ps_product = new ps_product;
    $Itemid = mosGetParam( $_REQUEST, 'Itemid', "" );
    $category_id = mosGetParam( $_REQUEST, 'category_id', "" );
    $db = new ps_DB;    
    $db_sku = new ps_DB;
    $db_item = new ps_DB;

    $html = "";
    // Get list of children
    $q = "SELECT product_id,product_name FROM #__pshop_product WHERE product_parent_id='$product_id'";
    $db->setQuery($q);
    $db->query();
    if( $db->num_rows() < 1 ) {
      // Try to Get list of sisters & brothers
      $q = "SELECT product_parent_id FROM #__pshop_product WHERE product_id='$product_id'";
      $db->setQuery($q);
      $db->query();
      $child_id = $product_id;
      $product_id = $db->f("product_parent_id")!="0" ? $db->f("product_parent_id") : $product_id;
      $q = "SELECT product_id,product_name FROM #__pshop_product WHERE product_parent_id='".$db->f("product_parent_id")."' AND product_parent_id<>0";
      $db->setQuery($q);
      $db->query();
    }
    if( $db->num_rows() > 0 ) {
      $flypage = $ps_product->get_flypage( $product_id );
      $html .= "<label for=\"product_id_field\">".$PHPSHOP_LANG->_PHPSHOP_PLEASE_SEL_ITEM."</label>: <br />";
      $html .= "<select class=\"inputbox\" onchange=\"var id = document.getElementById('addtocart').product_id[selectedIndex].value; if(id != '') {window.location='index.php?option=com_phpshop&page=shop.product_details&flypage=$flypage&Itemid=$Itemid&category_id=$category_id&product_id=' + id } ;\" id=\"product_id_field\" name=\"product_id\">\n";
      $html .= "<option value=\"$product_id\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>";	
      while ($db->next_record()) {
        $selected = isset($child_id) ? ($db->f("product_id")==$child_id ? "selected=\"selected\"" : "") : "";
        // Get item price
        $price = $ps_product->get_price($db->f("product_id"));
        if( $_SESSION["auth"]["show_price_including_tax"] == 1 ) {
          $tax_rate = 1 + $ps_product->get_product_taxrate($db->f("product_id"));
          $price['product_price'] *= $tax_rate;
        }
        // Start row for this child
        $html .= "<option value=\"" . $db->f("product_id") . "\" $selected>";	
        $html .= $db->f("product_name") . " - ";	
        
        // For each child get attribute values by looping through attribute list
        $q = "SELECT attribute_name FROM #__pshop_product_attribute_sku ";
        $q .= "WHERE product_id='$product_id' ORDER BY attribute_list ASC";
        $db_sku->setQuery($q);  $db_sku->query();
        
        while ($db_sku->next_record()) {
          $q = "SELECT attribute_name, attribute_value, product_id ";
          $q .= "FROM #__pshop_product_attribute WHERE ";
          $q .= "product_id='" . $db->f("product_id") . "' AND ";
          $q .= "attribute_name='" . $db_sku->f("attribute_name") . "'";
          $db_item->setQuery($q);  $db_item->query();
          while ($db_item->next_record()) {
            $html .= $db_item->f("attribute_name") . " ";
            $html .= "(" . $db_item->f("attribute_value") . ") - ";
          }
        }
        // Attributes for this item are done.
        $html .= $CURRENCY_DISPLAY->getFullValue($price["product_price"]);
        $html .= "</option>\n";
      }
      $html .= "</select>\n";
    }
    else {
      $html = "<input type=\"hidden\" name=\"product_id\" value=\"$product_id\" />\n";
    }
    
    return $html;
  }

  
// begin addition for advanced attribute list
/************************************************************************** 
   ** name: list_advanced_attribute($product_id) 
   ** created by: Sean Tobin (byrdhuntr@hotmail.com) 
   ** description: Creates drop-down boxes from advanced attribute format. 
   ** parameters: product_id (may be a product or item) 
   ** returns: html 
   ***************************************************************************/ 
  function list_advanced_attribute($product_id) { 
    global $CURRENCY_DISPLAY;
    $db = new ps_DB;    
    
    $q = "SELECT attribute FROM #__pshop_product WHERE product_id='$product_id'"; 
    $db->query($q); 
    $db->next_record(); 

    $advanced_attribute_list=$db->f("attribute"); 
    if ($advanced_attribute_list) {
      $has_advanced_attributes=1; 
      $fields=explode(";",$advanced_attribute_list); 
      $html = "";
      foreach($fields as $field) {
        
        $base=explode(",",$field); 
        $title=array_shift($base); 
        $titlevar=str_replace(" ","_",$title); 
        $html .= "<div style=\"width:30%;float:left;text-align:right;margin:3px;\">";
        $html .= "<label for=\"".$titlevar."_field\">$title</label>:</div>";
        $html .= "<div style=\"width:60%;float:left;margin:3px;\"><select class=\"inputbox\" id=\"".$titlevar."_field\" name=\"$titlevar\">"; 
        foreach ($base as $base_value) { 
            // the Option Text
            $attribtxt=substr($base_value,0,strrpos($base_value, '['));
            if( $attribtxt != "") {
              $vorzeichen=substr($base_value,strrpos($base_value, '[')+1,1); // negative, equal or positive?
              if( $_SESSION["auth"]["show_price_including_tax"] == 1 ) {
                $price = floatval(substr($base_value,strrpos($base_value, '[')+2))*(1+ $_SESSION['product_info'][$product_id]['tax_rate']); // calculate Tax
              }
              else {
                $price = floatval(substr($base_value,strrpos($base_value, '[')+2));
              }
              if ($price=="0") $attribut_hint = "test";
              $base_var=str_replace(" ","_",$base_value); 
              $html.="<option value=\"$base_var\">$attribtxt&nbsp;(&nbsp;".$vorzeichen."&nbsp;".$CURRENCY_DISPLAY->getFullValue($price)."&nbsp;)</option>"; 
            }
            else {
              $base_var=str_replace(" ","_",$base_value); 
              $html.="<option value=\"$base_var\">$base_value</option>"; 
            }
        } 
        $html.="</select></div><br style=\"clear:both;\" />\n"; 
      }
      //$html.="</table>";
    } 

    if ($advanced_attribute_list) { 
      return $html; 
    } 
  }
// end addition for advanced attribute list

/************************************************************************** 
   ** name: list_custom_attribute($product_id) 
   ** created by: Denie van Kleef (denievk@in2sports)
   ** description: Created textfields for custom products
   ** parameters: product_id (may be a product or item) 
   ** returns: html 
   ***************************************************************************/ 

  function list_custom_attribute($product_id) { 

    $db = new ps_DB;    
    
    $q = "SELECT custom_attribute from #__pshop_product WHERE product_id='$product_id'"; 
    $db->query($q); 
    $db->next_record(); 

    $custom_attr_list=$db->f("custom_attribute"); 
    if ($custom_attr_list) {
      $has_custom_attributes=1; 
      $fields=explode(";",$custom_attr_list); 
      $html = "";
      foreach($fields as $field) 
	  {
        $titlevar=str_replace(" ","_",$field); 
        $title=ucfirst($field); 
        $html .= "<div style=\"width:30%;float:left;text-align:right;margin:3px;\">";
        $html .= "<label for=\"".$titlevar."_field\">$title</label>:</div>";
        $html .= "<div style=\"width:60%;float:left;margin:3px;\">";
        $html .= "<input type=\"text\" class=\"inputbox\" id=\"".$titlevar."_field\" size=\"30\" name=\"$titlevar\" />";
        $html.="</div>\n"; 
      }
    } 

    if ($custom_attr_list) { 
      return $html; 
    } 
  }
}
?>
