<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.6 $
 */
 
 require_once("../components/" . $option . "/mosform_groups.class.php");



/**
* Show all groups
* @param string component name
* @return boolean false if database error
*/


function displayMosFormGroup($option)
{
	global $database, $mainframe, $mosConfig_offset; 
	// get the total number of records
		$database->setQuery("SELECT count(*) FROM #__mosform_groups");
	
		$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_groups LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	//include_once("includes/pageNavigation.php");
	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();
	
	if ($database->getErrorNum()) {
		echo $database->stderr();

		return false;
	} 
	
	$arElcount = array();
	
	foreach ($rows as $row){
		$group_id = $row->id;
		
		$sql = "SELECT count( * ) AS total
		FROM `#__mosform_groups` AS g
		LEFT JOIN `#__mosform_elements` AS e ON g.id = e.group_id
		WHERE g.id = '$group_id' and e.id <> ''";
		
		$database->setQuery($sql);
		

		$total = $database->loadResult();
		
		$arElcount[$group_id] = $total;
		
		if ($database->getErrorNum()) {
		
			echo $database->stderr();
			
		} 
		
	}

	html_content::showAllGroups($rows, $pageNav, $option, $arElcount);
} 

/**
* Delete a group
* @param integer groupid
* @param string component name
* @param string action
*/


function deleteMosFormGroup($cid, $option, $act)
{
	// TODO: mosforms : 0.5 : before deleteing show page with summary of group's elements and option to delete these elements at the same time
	global $database;

	$msg = '';

	for ($i = 0, $n = count($cid); $i < $n; $i++) {
		$sql = "delete from #__mosform_groups where id = '" . $cid[$i] . "'";

		$database->setQuery($sql);

		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 

		$sql = "delete from #__mosform_formgroup where group_id = '" . $cid[$i] . "'";

		$database->setQuery($sql);

		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 
	} 

	mosRedirect("index2.php?option=$option&mosmsg=$msg&act=$act");
} 

/**
 * delete all groups elements - not plugged into admin yet 
 * @param int group id
 * @return string error message
 */
 
function deleteMosFormGroupElements($groupId){

	global $database;
	
	$datasbase->setQuery("delete from #__mosform_elements where group_id = '$groupId'");
	
	if (!$database->query()) {
		
		return  $database->getErrorMsg() . "\n";
		
	} 

	return "";
}

/**
* Save the group
* @param string component name
* @param string action
* @return boolean false if not saved
*/


function saveMosFormGroup( $aData )
{
	global $database, $my;

	$row = new mosForm_Group($database);

	if (!$row->bind($aData)) { // $aData was $_POST
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	if (!$row->check()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$row->checkin();

	$isNew = ($row->id == 0);

	if ($isNew) {

		$groupId = $database->insertid();
		
	} else {
		
		$groupId = $row->id; 

	} 

	return $groupId;
	
} 

/**
* Edit a group
* @param integer groupid
* @param string scope??
* @param string component name
* @param string message
*/


function editMosFormGroup($uid = 0, $scope = '', $option = 'com_mosforms', $msg = '')
{
	
	global $database, $my;
	//TODO : mosforms : 0.5 : gui bilder for group css
	$row = new mosForm_Group($database);

	$row->load($uid); 
	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=The form $row->title is currently being edited by another administrator");
	} 

	if ($uid) {
		$row->checkout($my->id);
	} 

	// get the available element types
	$database->setQuery("SELECT id AS value, element_name AS text FROM #__mosform_elements");

	$elements = $database->loadObjectList();

	$elementslist = mosHTML::selectList($elements, 'element_id', 'class="inputbox" size="1"',

		'value', 'text', intval($row->id));

	html_content::editGroup($option, $row, $elementslist, $msg);
} 

/**
* Order the group within a specific form
* @param integer groupid
* @param string inc??
* @param string component name
* @param string action
* @return boolean false if not saved
*/


function orderMosFormFormGroup($uid, $inc, $option, $act){

	require_once("../components/" . $option . '/mosform_formgroup.class.php');

	global $database;
	
	$row = new mosForm_FormGroup($database);
	
	$row->load($uid);
	
	$row->move($inc, "");

}