<?php
/**
 * class.subscribers.php
 * 
 * <p>Includes {@link subscribers} class.</p>
 * 
 * @package MaMML
 * @subpackage classes
 * @copyright  2004 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.5.0
 * @since 0.4.3
 * @link http://www.schmalls.com
 */
 
 /**
  *  Ensures this file is being included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
 
 /**
  * Class with subscribers functions
  * 
  * <p>Class for both frontend and backend subscribers functions.</p>
  * 
  * @package MaMML
  * @subpackage classes
  * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
  * @version 0.5.0
  * @since 0.4.3
  */
 class subscribers {
	 
	 /**
	  * Gets the subscribers for a newsletter
	  * 
	  * <p>Gets the registeres subscribers then the unregistered subscribers 
	  * from the database as object arrays. Then it merges the two arrays 
	  * into one array and returns it.</P
	  * 
	  * @version 0.5.0
	  * @since 0.4.3
	  * @param int $listid the list to work with
	  * @param string $confirmed to be added to end of database query
	  * @global class access to the database
	  * @return boolean false on failure | array the subscriber information if successful
	  */
	 function getSubscribers($listid, $confirmed = ''){
		global $database;
		
		$listid = 'list_' . $listid;
		// get registered subscribers
		$query = "SELECT 
					N.subscriber_id AS id, 
					M.name AS name, 
					M.email AS email, 
					N.confirmed AS confirmed, 
					N.subscribe_date AS subscribe_date, 
					N.receive_html AS receive_html 
					FROM #__mamml_subscribers AS N, 
					#__users AS M 
					WHERE N." . $listid . " != 0 " 
					. $confirmed . " 
					AND M.id = N.subscriber_id";
		$database->setQuery($query);
        $registered = $database->loadObjectList();
        $error = $database->getErrorMsg();
		// quit on error
		if (!empty($error)) {
			echo '<p>Error (classes/class.subscribers.php->getSubscribers() line ' . __LINE__ . '): Could not get registered subscribers from database. Database error: <br />' . $error . '</p>';
			return false;
		} else {
			// get unregistered subscribers
	        $query = "SELECT U.unregistered_id AS id,
						U.name AS name,
						U.email AS email,
						U.confirmed AS confirmed,
						U.subscribe_date AS subscribe_date,
						U.receive_html AS receive_html
						FROM #__mamml_unregistered AS U
						WHERE U." . $listid . " != 0 "
						. $confirmed;
			$database->setQuery($query);
			$unregistered = $database->loadObjectList();
			$error = $database->getErrorMsg();
			// quit on error
			if (!empty($error)) {
				echo '<p>Error (classes/class.subscribers.php->getSubscribers() line ' . __LINE__ . '): Could not get unregistered subscribers from database. Database error: <br />' . $error . '</p>';
				return false;
			} else {
				// combine arrays and return
	        	$total = array_merge($registered, $unregistered);
				return $total;
			} // end if
		} // end if
	} // end function
	
 } // end class
?>
