<?
/**
* Xaneon Alias Manager 1.0 for Mambo 4.5.1
* @package Alias_Manager_1.0
* @version 1.0.3a
* @copyright (c) 2004 Xaneon Development (dev.xaneon.com)
* @license GNU/GPL
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

function sefGetLangMappings() {
  return array(
    // Checked as of 2004-11-14
    "albanian" => "sq",
    "arabic" => "ar",
    "bosnian" => "bs",
    "brazilian_portuguese" => "pt_BR",
    "bulgarian" => "bg",
    "catalan" => "ca",
    "croatian" => "hr",
    "czech1250" => "cs",
    "czechiso" => "cs",
    "danish" => "da",
    "dutch" => "nl",
    "english" => "en",
    "finnish" => "fi",
    "french" => "fr",
    "germanf" => "de",
    "germani" => "de",
    "greek" => "el",
    "hebrew" => "he",
    "hungarian_formal" => "hu",
    "hungarian_informal" => "hu",
    "italian" => "it",
    "korean" => "ko",
    "lithuanian" => "lt",
    "mongolian" => "mn",
    "norwegian" => "no",
    "polish" => "pl",
    "portuguese" => "pt",
    "romanian" => "ro",
    "serbian" => "sr",
    "simplified_chinese" => "zh_CN",
    "slovenian" => "sl",
    "spanish" => "es",
    "swedish" => "sv",
    "tagalog" => "tl",
    "thai" => "th",
    "traditional_chinese" => "zh_TW",
    "turkish" => "tr",
    "vietnamese" => "vi",
  );
}

function sefGetLangTitle( $langCode, $langName = "" ) {
  $langs = array(
    "ar" => "Arabic",
    "bg" => "Bulgarian",
    "bs" => "Bosnian",
    "ca" => "Catalan",
    "cs" => "Czech",
    "da" => "Danish",
    "de" => "German",
    "el" => "Greek",
    "en" => "English",
    "es" => "Spanish",
    "fi" => "Finnish",
    "fr" => "French",
    "he" => "Hebrew",
    "hr" => "Croatian",
    "hu" => "Hungarian",
    "it" => "Italian",
    "ko" => "Korean",
    "lt" => "Lithuanian",
    "mn" => "Mongolian",
    "nl" => "Dutch",
    "no" => "Norwegian",
    "pl" => "Polish",
    "pt" => "Portuguese",
    "pt_BR" => "Portuguese (Brazil)",
    "ro" => "Romanian",
    "sl" => "Slovenian",
    "sq" => "Albanian",
    "sr" => "Serbian",
    "sv" => "Swedish",
    "th" => "Thai",
    "tl" => "Tagalog",
    "tr" => "Turkish",
    "vi" => "Vietnamese",
    "zh_CN" => "Chinese (Simplified)",
    "zh_TW" => "Chinese (Traditional)",
  );
  return array_key_exists($langCode, $langs) ? $langs[$langCode] : null;
}

function sefGetLangISOCode( $langName ) {
  $langs = sefGetLangMappings();
  return array_key_exists($langName, $langs) ? $langs[$langName] : null;
}

function sefGetLangName( $langCode ) {
  $langs = sefGetLangMappings();
  return array_search( $langCode, $langs );
}

function sefGetLocale( $langCode, $langName ) {
  return $langCode;
}

?>