<?php
/**
* Xaneon Alias Manager 1.0 for Mambo 4.5.1
* @package Alias_Manager_1.0
* @version 1.0.3a
* @copyright (c) 2004 Xaneon Development (dev.xaneon.com)
* @license GNU/GPL
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//error_reporting( E_ALL );

require_once( $mainframe->getPath( "class" ) );
require_once( $mainframe->getPath( "admin_html" ) );

$act = trim( mosGetParam( $_REQUEST, "act", null ) );
$task = trim( mosGetParam( $_REQUEST, "task", null ) );
$cid = mosGetParam( $_REQUEST, "cid", array( 0 ) );
if (!is_array( $cid )) $cid = array ( 0 );

switch ($task) {
  case "publish":
    aliasPublish( $database, $cid, 1, $option );
    break;
  case "unpublish":
    aliasPublish( $database, $cid, 0, $option );
    break;
  case "new":
    aliasEdit( $database, '0', $option );
    break;
  case "edit":
    aliasEdit( $database, $cid[0], $option );
    break;
  case "cancel":
    aliasEditCancel( $database, $cid, $option );
    break;
  case "save":
    aliasSave( $database, $option );
    break;
  case "remove":
    aliasRemove( $database, $cid, $option );
    break;

  case "config":
    updateConfig( $database, $cid, $option );
    break;
  case "import":
    aliasImport( $database, $cid, $option );
    break;
  case "export":
    aliasExport( $database, $cid, $option );
    break;
  case "validate":
    validate( $database, $cid, $option );
    break;

  case "about":
    aliasAboutPage( $database, $option );
    break;
  case "aliases":
  default:
    aliasView( $database, $option );
    break;
}

function getViewURL( $option, $act = "" ) {
  global $mosConfig_list_limit;
  $limit = intval( mosGetParam( $_REQUEST, "limit", $mosConfig_list_limit ) );
  $limitstart = intval( mosGetParam( $_REQUEST, "limitstart", 0 ) );
  $url = "index2.php?option=$option";
  if ($act) $url .= "&act=$act";
  $url .= "&limit=$limit&limitstart=$limitstart";
  return $url;
}

function updateConfig( &$database, &$cid, $option ) {
  $config = new mosAliasConfig();
  $vars = get_object_vars( $config );
  foreach ($vars as $key => $value) {
    if ($key[0] != '_') {
      $config->$key = mosGetParam( $_POST, "config_$key", $config->$key );
    }
  }
  $config->store();

  mosRedirect( getViewURL( $option ) );
}

function aliasAboutPage( &$database, $option ) {
  $config = new mosAliasConfig();
  HTML_alias::aliasAboutPage( $option, $config );
}

function aliasView( &$database, $option ) {
  global $mainframe;
  global $mosConfig_list_limit, $mosConfig_absolute_path;

  $config = new mosAliasConfig();
  $limit = $mainframe->getUserStateFromRequest(
    "viewlistlimit", "limit", $mosConfig_list_limit );
  $limitstart = $mainframe->getUserStateFromRequest(
    "view{$option}limitstart", "limitstart", 0 );
  $search = $mainframe->getUserStateFromRequest(
    "search{$option}", "search", "" );
  $search = $database->getEscaped( trim( strtolower( $search ) ) );
  $language = $mainframe->getUserStateFromRequest(
    "language{$option}", "language", "*" );
  $language = $database->getEscaped( trim( strtolower( $language ) ) );

  $wheres = array();
  if (isset($search) && $search != "") {
    $wheres[] = "(url LIKE '%$search%' OR target LIKE '%$search%')";
  }
  if (isset($language) && $language != "" && $language != "*") {
    if ($language == "-") {
      $wheres[] = "(language IS NULL OR language = '')";
    }
    else {
      $wheres[] = "(language = '$language')";
    }
  }

  $database->setQuery( "SELECT COUNT(*)"
    . "\nFROM #__alias"
    . ($wheres ? " WHERE " . implode( " AND ", $wheres ) : "" )
  );
  $total = $database->loadResult();

  include_once( "$mosConfig_absolute_path/administrator/includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  $database->setQuery( "SELECT *"
    . "\nFROM #__alias"
    . ($wheres ? " WHERE " . implode( " AND ", $wheres ) : "" )
    . "\nORDER BY url ASC"
    . "\nLIMIT $pageNav->limitstart, $pageNav->limit"
  );

  $rows = $database->loadObjectList();
  if ($database->getErrorNum()) {
    echo( $database->stderr() );
    return false;
  }

  HTML_alias::aliasView( $rows, $pageNav, $search, $language, $option, $config );
}

function aliasPublish( &$database, &$cid, $publish = 1, $option ) {
  if (!is_array( $cid ) || count( $cid ) < 1) {
    $action = ($publish ? "publish" : "unpublish");
    die( HTML_alias::errorGoBack( "Select an item or items to $action." ) );
  }

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "UPDATE #__alias SET published = '$publish' WHERE id IN ($cids)" );
    if (!$database->query()) {
      die( HTML_alias::errorGoBack( $database->getErrorMsg() ) );
    }
  }

  mosRedirect( getViewURL( $option ) );
}

function aliasEdit( &$database, $id, $option ) {
  $catid = intval( mosGetParam( $_REQUEST, "catid", 0 ) );

  // Load the row from the db table
  $row = new mosAlias( $database );
  $row->load( $id );

  if ($id) {
    // Do stuff for existing records
    //global $my;
    //$row->checkout( $my->id );
  } else {
    // Do stuff for new records
    $row->published = '1';
  }

  HTML_alias::aliasForm( $row, $option );
}

function aliasEditCancel( &$database, $cid, $option ) {
  $row = new mosAlias( $database );
  $row->bind( $_POST );
  mosRedirect( getViewURL( $option ) );
}

function aliasSave( &$database, $option ) {
  global $mainframe, $acl;

  $row = new mosAlias( $database );
  if (!$row->bind( $_POST )) {
    die( HTML_alias::errorGoBack( $row->getError() ) );
  }

  // Pre-save checks
  if (!$row->check()) {
    die( HTML_alias::errorGoBack( $row->getError() ) );
  }

  // Save the changes
  if (!$row->store()) {
    die( HTML_alias::errorGoBack( $row->getError() ) );
  }

  mosRedirect( getViewURL( $option ) );
}  

function aliasRemove( &$database, &$cid, $option ) {
  if (!is_array( $cid ) || count( $cid ) < 1) {
    die( HTML_alias::errorGoBack( "Select an item or items to delete." ) );
  }

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__alias WHERE id IN ($cids)" );
    if (!$database->query()) {
      die( HTML_alias::errorGoBack( $database->getErrorMsg() ) );
    }
  }

  mosRedirect( getViewURL( $option ) );
}

function stripLiveSite( $url ) {
  global $mosConfig_live_site;
  if (substr( $url, 0, strlen( $mosConfig_live_site ) ) == $mosConfig_live_site) {
    return substr( $url, strlen( $mosConfig_live_site ) );
  }
  return $url;
}

function aliasImport( &$database, &$cid, $option ) {
  HTML_alias::beginOutput( "Importing Aliases..." );

  $strip = mosGetParam( $_POST, "import_strip", '' );
  $import = mosGetParam( $_POST, "import_text", '' );
  if (strlen( trim( $import ) ) == 0) {
    die( HTML_alias::errorGoBack( "Input some text to import." ) );
  }

  // Convert input to UNIX format, just in case.
  $import = str_replace( "\r\n", "\n", $import );

  $rows = explode( "\n", $import );
  foreach ($rows as $row) {
    $row = trim( $row );
    if (strlen( $row ) == 0 || $row[0] == '#') continue;
    $cols = explode( " ", $row, 2 );
    if (count($cols) == 1 || count($cols) == 2) {
      if (!isset( $cols[1] )) $cols[1] = "";
      $cols[0] = trim( stripLiveSite( $cols[0] ) );
      if ($strip == '1') {
        $cols[1] = trim( stripLiveSite( $cols[1] ) );
      }
      if (strlen( $cols[0] ) > 0) {
        HTML_alias::printLine( "Importing '$cols[0]' -> '$cols[1]' ...", "green" );
        $alias = $database->getEscaped( $cols[0] );
        $target = $database->getEscaped( $cols[1] );
        $query = "INSERT INTO #__alias (url, target)"
          . " VALUES ('$alias', '$target')";
        $err_level = error_reporting( 0 );
        $database->setQuery( $query );
        if (!$database->query()) {
          HTML_alias::printLine( stripslashes( $database->getErrorMsg() ), "red", 2 );
        }
        error_reporting( $err_level );
      }
    }
    else {
      HTML_alias::printLine( "Ignoring '$row'.", "orange" );
    }
  }

  HTML_alias::continueButton( getViewURL( $option ) );
  HTML_alias::endOutput();
}

function aliasExport( &$database, &$cid, $option ) {
  global $mosConfig_db, $mosConfig_dbprefix;

  HTML_alias::beginOutput( "Exporting Aliases..." );

  $method = $_SERVER["REQUEST_METHOD"];
  $params = ($method == "POST" ? $_POST : $_GET);
  $format = mosGetParam( $params, "export_format", "text" );

  $database->setQuery( "SELECT * FROM #__alias ORDER BY "
    . ($format == "sql" ? "id" : "url") );
  $rows = $database->loadObjectList();
  if ($database->getErrorNum()) {
    HTML_alias::printLine( stripslashes( $database->getErrorMsg() ), "red" );
    HTML_alias::continueButton( getViewURL( $option ) );
    HTML_alias::endOutput();
    return false;
  }

  $filename = "alias_export_" . date( "Ymd" );
  $filename .= ($format == "sql" ? ".sql" : ".txt");
  $heading = "# Xaneon Alias Manager 1.0.3a (dev.xaneon.com)\n"
    . "# Export of ${mosConfig_db}.${mosConfig_dbprefix}alias\n"
    . "# " . date( "Y-m-d H:i:s" ) . " / "
    . count( $rows ) . " rows in total.\n";
  foreach (explode( "\n", $heading) as $text)
    HTML_alias::printLine( $text, "purple" );

  $export = array();
  foreach ($rows as $row) {
    if ($format == "sql") {
      $data = "INSERT INTO ${mosConfig_dbprefix}alias"
        . " (id, language, published, url, target) VALUES"
        . " ($row->id, '$row->language', '$row->published', '$row->url', '$row->target');";
    }
    else {
      $data = "$row->url $row->target";
    }
    HTML_alias::printLine( $data );
    $export[] = $data;
  }

  HTML_alias::continueButton( getViewURL( $option ) );
  HTML_alias::endOutput();

  if (true) {
    // Get rid of all output buffers
    while (@ob_end_clean());
    ob_start();
    header( "Pragma: no-cache" );
    header( "Cache-Control: no-cache" );
    header( "Expires: -1" );
    if ($method == "POST") {
      header( "Content-Type: application/force-download" );
      header( "Content-Disposition: attachment; filename=$filename" );
    }
    else {
      header( "Content-Type: text/plain" );
    }
    echo( "$heading\n" );
    echo( implode( "\n", $export ) . "\n" );
    header("Content-Length: " . ob_get_length());
    ob_end_flush();
    exit;
  }
}

function validateURL( $url_info, $timeout = 4.0 ) {
  $port = (isset( $url_info["port"] ) ? intval( $url_info["port"] ) : 80);
  $host = $url_info["host"];

  if (($fp = @fsockopen( $host, $port, $errno, $errstr, $timeout ))) {
    socket_set_timeout($fp, $timeout);

    $uri = (!isset( $url_info["path"] ) ? "/" :
      $url_info["path"] . "?" .
      (isset( $url_info["query"] ) ? $url_info["query"] : ""));

    $request = "HEAD $uri HTTP/1.0\r\nHost: $host\r\nConnection: close\r\n\r\n";
    fputs( $fp, $request );
    $response = @fgets( $fp, 256 );
    fclose( $fp );

    if ($response) {
      $status_info = split( " ", $response, 3 );
      list($http_ver, $status_code, $status_msg) = $status_info;
      $msg = "$status_code $status_msg";
      $color = (intval( $status_code ) < 400 ? "green" : "red");
      HTML_alias::printLine( $msg, $color, 2 );
      return true;
    }
  }

  HTML_alias::printLine( "Error", "red", 2 );
  return false;
}

function validate( &$database, &$cid, $option ) {
  if (!is_array( $cid ) || count( $cid ) < 1) {
    die( HTML_alias::errorGoBack( "Select an item or items to validate." ) );
  }

  HTML_alias::beginOutput( "Validating Alias Targets..." );
  HTML_alias::printLine( "Note that this feature currently only validates external http:// links.", "orange" );
  HTML_alias::printLine();

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "SELECT * FROM #__alias WHERE id IN ($cids)" );
    $rows = $database->loadObjectList();
    if ($database->getErrorNum()) {
      HTML_alias::printLine( stripslashes( $database->getErrorMsg() ), "red" );
      return false;
    }

    foreach ($rows as $row) {
      $alias = $row->url;
      $target = $row->target;
      $url_info = @parse_url( $target );

      if (isset( $url_info["scheme"] )) {
        HTML_alias::printText( "'$alias' -> '$target'... " );
        switch ($url_info["scheme"]) {
          case "http":
            validateURL( $url_info );
            break;
          default:
            HTML_alias::printLine( "Skipped", "orange", 2 );
            break;
        }
      }
    }

  }

  HTML_alias::continueButton( getViewURL( $option ) );
  HTML_alias::endOutput();
  return true;
}

?>