<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.15 $
 */
 
 /**
  * php code to manipulate form elements
  */
  
  
require_once("../components/" . $option . "/mosform_elements.class.php");
  
require_once("../components/" . $option . "/mosform_table.class.php");

require_once("../components/" . $option . "/mosform_groups.class.php");

require_once("../components/" . $option . "/mosform_connection.class.php");

require_once("../components/" . $option . "/mosforms.class.php");

/**
* Copys an element
* @param array of keys to copy
* @return string component name
*/

function copyElement( $cid, $option ){

	//TODO : mosforms : 0.5 : check on duplicate element name when adding/moving to the same group
	//TODO : mosforms : 0.5 : add "move" button to move whole selections of elements to different groups
	
	global $database;

	
	if (!is_array( $cid ) || count( $cid ) < 1) {
		
		echo "<script> alert('Select an item to move'); window.history.go(-1);</script>\n";
		
		exit;
		
	}

	foreach($cid as $id){
		
		$oElement = new mosForm_Element($database);	

		$oElement->load($id);
		
		$ar = array("group_id"=>"$oElement->group_id");
		
		$oNewElement = new mosForm_Element($database);	
		
		$oNewElement->ordering  = getNextFreeGroupOrder( $oElement->group_id );

		$oNewElement->copyRow( $id, $ar );
	}
	
	displayMosFormElement($option);

}

/**
 * publish/unpublish a form group element
 * @param array/int elements to set publish state
 * @param bol publish on/off
 */
 
function publish($id, $state){
	
	global $database;
	
	$row = new mosForm_Element($database);
	
	$row->publish($id, $state);

}

/**
* Show all elements
* @param string component name
* @return boolean false if database error
*/

function displayMosFormElement($option)
{
	
	global $database, $mainframe, $mosConfig_offset, $mosConfig_list_limit; 
	
	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	
	$filter_elementTypeId = $mainframe->getUserStateFromRequest( "filter_elementTypeId", 'filter_elementTypeId', 0 );
	
	$filter_groupId 	= $mainframe->getUserStateFromRequest( "filter_groupId", 'filter_groupId', 0 );
	
	$search 			= $mainframe->getUserStateFromRequest( "filter_elementName", 'filter_elementName', '' );
	
	// used by filter
	if ( $filter_elementTypeId > 1 ) {
		
		$where[] = " #__mosform_elements.elementtype_id = '$filter_elementTypeId' ";
		
	}
	
		// used by filter
	if ( $filter_groupId > 1 ) {
		
		$where[] = " #__mosform_elements.group_id = '$filter_groupId' ";
		
	}
	
	// filter the element names
	if($search != ''){
		
		$where[] = " #__mosform_elements.element_name like '%$search%'";	
		
	}
	
	$totalSql = "SELECT count(*) FROM #__mosform_elements";
	
	if(!empty($where)){
		
		$totalSql .= " WHERE " . implode( ' AND ', $where ) . $ordering . $limit;
		
	}

	// get the total number of records
	
	$database->setQuery( $totalSql );

	$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}{elements}limitstart", 'limitstart', 0 );
	
	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$sql = "select *, #__mosform_elements.id as id from #__mosform_elements 

			left join #__mosform_groups 

			on #__mosform_elements.group_id = #__mosform_groups.id

			left join #__mosform_elementtypes 

			on #__mosform_elements.elementtype_id = #__mosform_elementtypes.elementtype_id";

			$ordering = " order by #__mosform_groups.id,  #__mosform_elements.ordering ";

			$limit = " LIMIT $pageNav->limitstart, $pageNav->limit";


	if(!empty($where)){
		
		$sql .= " WHERE " . implode( ' AND ', $where ) ;
		
	}
	
	$sql .= "$ordering $limit";
				
	$database->setQuery($sql);

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		
		echo $database->stderr();

		return false;
	} 

	//get all element types
		
	$database->setQuery("select elementtype_id as value, elementtype_name as text from #__mosform_elementtypes");
	
	$elementTypeId = $database->loadObjectList();

	$lists['elementId'] = mosHTML::selectList( $elementTypeId, 'filter_elementTypeId', 'class="inputbox"  onchange="document.adminForm.submit( );"', 'value', 'text', $filter_elementTypeId );

	//get all groups into a drop down list
	
	$database->setQuery("select id as value, group_name as text from #__mosform_groups");
	
	$aTmp[] = mosHTML::makeOption("-1", _PLEASE_SELECT);
	
	$groups = $database->loadObjectList();
	
	$groups = array_merge(  $aTmp, $groups );
	
	$lists['groupId'] = mosHTML::selectList( $groups, 'filter_groupId', 'class="inputbox"  onchange="document.adminForm.submit( );"', 'value', 'text', $filter_groupId );

	html_element_content::showAllElements($rows, $pageNav, $option, $lists, $search);
	
} 

/**
* Delete an element
* @param integer element id to delete
* @param string component name
* @param string action
*/

function deleteMosFormElement($cid, $option, $act)
{
	global $database;

	$msg = '';

	for ($i = 0, $n = count($cid); $i < $n; $i++) {

		$sql = "delete from #__mosform_elements where id = '" . $cid[$i] . "'";

		$database->setQuery($sql);

		if (!$database->query()) {
			
			$msg .= $database->getErrorMsg() . "\n";
			
		} 
		
	} 

	mosRedirect("index2.php?option=$option&mosmsg=$msg&act=$act");
	
} 

/**
 * when adding a new element this will ensure its added to all tables that the
 * elements group is associated with
 * @param int group id
 * @param int element type id
 * @param string element name
 * @param bol if the field is to be added or altered
 */
 
function addElementToDatabaseTable( $groupId, $objtypeid, $name, $new){
	
	global $database, $my;
	
	switch ($objtypeid) {
		
		case "2":
		
			$objtype = "varchar (255)";
			
			break;
		
		case "3":
		
			$objtype = "varchar (3)";
			
			break;
		
		case "4":
		
			$objtype = "varchar (3)";
			
			break;
		
		case "5":
		
			$objtype = "text";
			
			break;
		
		case "6":
		
			$objtype = "varchar (255)";
			
			break;
		
		case "7":
		
			$objtype = "";
			
			break;
		
		case "8":
		
			$objtype = "binary ()";
			
			break;
		
		case "9":
		
			$objtype = "";
		
			break;
			
		case "10":
		
			$objtype = "varchar (25)";
			
			break;
		
		default:
		
			$objtype = "varchar (255)";
			
			break;
	} 
	
	$oGroup = new mosForm_Group( $database );
	
	$oForm = new mosForms( $database );
	
	$oTable = new mosForm_Table( $database );
	
	$oConn = new mosForm_Connection( $database );
	
	$oGroup->load( $groupId );
	
	$afFormIds = $oGroup->getFormsIamIn();
	
	if(is_array($afFormIds)){

		foreach( $afFormIds as $formId ){
			
			$oForm->load($formId);
			
			$tableId = $oForm->table_id;
			
			$oTable->load($tableId);
			
			$tableName = $oTable->db_table_name;
			
			if($oTable->connection_id > 0){
				
				$oConn->load( $oTable->connection_id );
				
				$mosFormDb = $oConn->loadTableConnectionDB();
	
				$mosFormDb->setQuery("describe $tableName");
				
				$dbdescriptions = $mosFormDb->loadObjectList();
				
				foreach($dbdescriptions as $dbdescription) {
					
					$fieldname = $dbdescription->Field;
					
					$exitingfields[] = $fieldname;
					
				} 
				
				$lastfield = $fieldname;
				
				if($new){
				
					$sql =  "alter table $tableName ADD COLUMN $name $objtype after $lastfield" ;
	
				}else{
					
					$sql =  "alter table $tableName CHANGE $name $name $objtype" ;	
					
				}	
				
				$mosFormDb->setQuery($sql);
						
				if(!$mosFormDb->query()){
					
					echo $mosFormDb->getErrorMsg();
				
				}
				
			}
		
		}	
		
	}
	
}


/**
* Save the element
* @param string component name
* @param string action
*/

function saveMosFormElement($option, $aData){
	
	global $database, $my;
	
	$aData['element_name'] = preg_replace("/[^A-Za-z0-9]/", "_", $aData['element_name']);
	
	$groupId = 		mosGetParam( $_POST, 'group_id', '' );

	$objtypeid = 	mosGetParam($_POST, 'elementtype_id', '2');
	
	$name = 		preg_replace("/[^A-Za-z0-9]/", "_", mosGetParam( $_POST, 'element_name', '' ));
	
	if($aData['id'] == '0'){
		
		addElementToDatabaseTable($groupId, $objtypeid, $name, true);
		
	}else{
		
		addElementToDatabaseTable($groupId, $objtypeid, $name, false);
		
	}
	
	$aData['image_name'] = '';
	
	if(isset($aData['imagefiles'])){
		
		$aData['image_name'] = $aData['imagefiles'];
	
	}
	$row = new mosForm_Element( $database );

	// get the max current ordering value
	
	$ordering = getNextFreeGroupOrder( $aData['group_id'] );

	if (!isset($aData['ordering'])) {
		
		$aData['ordering'] = $ordering;
		
	} 

	if ($aData['ordering'] == 0) {
		
		$aData['ordering'] = $ordering;
		
	} 
	

	if (!$row->bind($aData)) {
		
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$isNew = ($row->id == 0);

	if (!$row->check()) {
		
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
		
	} 
	
	

	if (!$row->store()) {
		
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
		
	} 

	$row->checkin();
	
	//delete old validations for the element
	
	$database->setQuery("delete from #__mosform_validations where element_id = '$row->id'");
	
	$database->query();
	
	//add new validations

	if(isset($_POST['validation_rule_id'])){
			
		if(is_array($_POST['validation_rule_id'])){
	
			for($c = 0;$c<=count($_POST['validation_rule_id']);$c++){
				
				$valId = $_POST['validation_rule_id'][$c];
				
				if( $valId != ''){
					
					$errMessage = $_POST['message'][$c];
					
					$sql = "insert into #__mosform_validations (element_id, validation_rule_id, message) values ('$row->id', '$valId', '$errMessage')";
					
					$database->setQuery($sql);
					
					$database->query();
					
				}
				
			}
			
		}	

	}
		
} 

/**
 * returns the next free ordering id for an element in a given group
 * @param int group id
 * @return int element order value
 */
 
 function  getNextFreeGroupOrder( $groupId ){
 
 		global $database;
 		
 		$sql = "select max(ordering) from #__mosform_elements where group_id = '$groupId'";

		$database->setQuery( $sql );
	
		$ordering = $database->loadResult();
	
		$ordering ++; 
		
		return $ordering;
	
	}
	
/**
* Edit element
* @param integer element id
* @param string scope
* @param string component name
*/


function editMosFormElement($uid = 0, $scope = '', $option = 'com_mosforms')
{
	
	//TODO : mosforms : 0.5 : when editing element - you should show a drop down box for reordering it
	//TODO : mosforms : 0.5 : allow user to choose full folder path for images - rather than just /images/
	//TODO : mosforms : 0.5 : when specifiying the foregin key table - allow mosforms to "pull in" and display other columns from that table, linked by the foregin key 

	require_once ("../components/".$option."/mosform_connection.class.php");
	
	global $mosConfig_absolute_path, $database, $my, $mosConfig_live_site;
	 
	// check to see if a group exists if no group then we need to alert the user and go to the add group page
	
	$database->setQuery("SELECT count(*) FROM #__mosform_groups");
	
	$total = $database->loadResult();

	if ($total == 0) {
	
		require_once("../components/" . $option . "/mosform_groups.class.php");
		
		editMosFormGroup(0, '', $option , 'Please create a group first, before creating your element');
		
	} else {
	
		$row = new mosForm_Element($database);

		$row->load($uid); 

		// fail if checked out not by 'me'
		
		if ($row->checked_out && $row->checked_out <> $my->id) {
		
			mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=The form $row->title is currently being edited by another administrator");
			
		} 

		// if you are editing an element then $uid will be set, thus you can check it out to avoid other people editing it at the same time. //
		
		if ($uid) {
		
			$row->checkout($my->id); // $my->id is the id of the current user //
		
		} 
		
		
		if($uid == '0'){		// set the publsih default to 1
		
			$row->state = '1';
		
		}
		
		// get the available element types//
		
		$database->setQuery("SELECT elementtype_id AS value, elementtype_name AS text FROM #__mosform_elementtypes");

		$elementstypes = $database->loadObjectList(); 
		
		// put the avaialble element types in a selction list //
		
		$elementstypelist = mosHTML::selectList($elementstypes, 'elementtype_id', 'class="inputbox" onchange="dhtml.cycleTab(\'tab\'+this.options[this.selectedIndex].value)"  size="1"',

			'value', 'text', intval($row->elementtype_id)); 
		
		// get the available groups//
		
		$sql = "SELECT id AS value, group_name AS text FROM #__mosform_groups";

		$database->setQuery($sql);

		$groups = $database->loadObjectList(); 
		
		// put the avaialble groups in a selction list //
		
		$groupslist = mosHTML::selectList($groups, 'group_id', 'class="inputbox" size="1"', 'value', 'text', intval($row->group_id));
		 
		// get all mosimages//
		
		$img_path = "$mosConfig_absolute_path/images/";

		if (!is_dir($img_path)) {

		    mkdir($img_path);
		}
			
		$imgFiles = mosReadDirectory($img_path);
		
		if(is_array($imgFiles)){

			foreach ($imgFiles as $file) {
	
				if (eregi("bmp|gif|jpg|png", $file)) {
	
					$images[] = mosHTML::makeOption($file);
	
				} 
	
			} 

		}
		
		$imagelist = mosHTML::selectList($images, 'image_name', "class=\"inputbox\" size=\"1\"" . " ", 'value', 'text', $row->image_name); 

		// get list of directories

		$listdir = $mosConfig_absolute_path."/uploadfiles";
		
		$arDirs =  recursive_listdir( $listdir );

		$folders = array();

		$folders[] = mosHTML::makeOption( "uploadfiles" );
		
		if(is_array($arDirs)){
		
			foreach ($arDirs as $dir) {
					
					$folders[] = mosHTML::makeOption( substr($dir,strlen($mosConfig_absolute_path)) );
			}
	
		}
		
		// create folder selectlist

		$dirPath = mosHTML::selectList( $folders, 'ul_directory', "class=\"inputbox\" size=\"1\" "

		."onchange=\"goUpDir()\" ",

		'value', 'text', $row->ul_directory );
	
		//get the database connections

		$oConn = new mosForm_Connection( $database );
		
		$realCnns = $oConn->getConnections();
		
		$javascript = "onchange=\"changeDynaList( 'join_db_name', connectiontables, document.adminForm.join_conn_id.options[document.adminForm.join_conn_id.selectedIndex].value, 0, 0);\"";
		
		$lists['connections'] = $oConn->getConnectionsDd( $realCnns, $javascript, 'join_conn_id', $row->join_conn_id  );
		
		// get a list of tables from each connection

		$connectionTables = $oConn->getConnectionTables( $realCnns );

		$javascript = "";

		if($row->join_db_name != ""){

				$tableNames[] = mosHTML :: makeOption($row->join_db_name, $row->join_db_name);

		}else{
				$tableNames[] = mosHTML :: makeOption('-1', _CHOOSE_NO_TABLE);
				
		}

		$lists['tablename'] = mosHTML :: selectList($tableNames, 'join_db_name', 'class="inputbox" size="1" '.$javascript, 'value', 'text', $row->join_db_name);

		//get a list of each field for each connection table! 
		//TODO : mosforms : 0.5 : get field drop down to change when table selected . This should get put on a seperate page so we only query the correct database table rather than all tables in all databases (or use ajax)
			
		//$connectionTableFields = $oConn->getConnectionTableFields( $realCnns );
		
		$tabs = new mosTabs(1);
		
		//validation stuff
		
		//get this elements validations
		$sql = "select * from #__mosform_validations where element_id = '$uid'";
		
		$database->setQuery($sql);
		
		$oValidations = $database->loadObjectList();
		
		//get the validation rules
		
		$sql = "select id as value, validation_rule_label as text from #__mosform_validation_rules";
		
		$database->setQuery($sql);
		
		$oValidationRules = $database->loadObjectList();
		
		echo $database->getErrorMsg();
		
		//make a drop down validation type for each validation
		
		$aValidations = array();
		
		if(is_array($oValidations)){
			
			foreach($oValidations as $oVal){
				
				$validationrulelist = mosHTML::selectList($oValidationRules, 'validation_rule_id[]', "class=\"inputbox\"  size=\"1\" ", 'value', 'text', $oVal->validation_rule_id);
				
				$aValidations[] = array($oVal->message, $validationrulelist);
				
			}
			
		}
		
		$lists['validations'] = $aValidations;
		
		$validationrulelist = mosHTML::selectList($oValidationRules, 'validation_rule_id[]', "class=\"inputbox\"  size=\"1\" ", 'value', 'text', '');
		
		$lists['validationrulelist'] = $validationrulelist;
		
		$aligns[] = mosHTML::makeOption( "none" );
		
		$aligns[] = mosHTML::makeOption( "left" );
		
		$aligns[] = mosHTML::makeOption("right");
		
		$lists["image_float"] = mosHTML::selectList( $aligns, 'image_float', 'class=\"inputbox\" size=\"1\"' ,
		'value', 'text', $row->image_float );
		
		// make image drop down boxes
		
		$pathA 		= $mosConfig_absolute_path .'/images/stories';
		
		$pathL 		= $mosConfig_live_site .'/images/stories';
		
		$images 	= array();
		
		$folders 	= array();
		
		$folders[] 	= mosHTML::makeOption( '/' );
		
		mosAdminMenus::ReadImages( $pathA, '/', $folders, $images );
	
		// list of folders in images/stories/
		
		$lists['folders'] 			= mosAdminMenus::GetImageFolders( $folders, $pathL );
		
		// list of images in specfic folder in images/stories/
		
		$lists['imagefiles']		= mosAdminMenus::GetImages( $images, $pathL );		
		
		// draw the edit element page //
		
		html_element_content::editElement($option, $row, $elementstypelist, $groupslist, $imagelist, $dirPath, $lists, $connectionTables, $tabs, $images);
	} 
} 

/**
* Order element
* @param integer element id
* @param string inc ??
* @param string component name
* @param string action
*/


function orderMosFormElement($uid, $inc, $option, $act)
{
	global $database;

	$row = new mosForm_Element($database);

	$row->load($uid); 
	
	$row->move($inc, "");

	mosRedirect("index2.php?option=$option&act=$act");
} 

