<?
function setDirPermsOnGallery($dir, &$warning_num){

	global $ftpIsAvailable, $ftpUse;

	if(file_exists($dir)){
		if(is_dir($dir)){
			// check for correct permissions on the dir
			@chmod($dir, 0777);
			if((fileperms($dir) & 0777) != 0777){
				// can't change file perms, so see if
				// safemode patch installed and try it thru
				// ftp assist
				if(isset($ftpIsAvailable) && $ftpIsAvailable && $ftpUse && function_exists('chmodDir'))
					chmodDir($dir, '777');
			}
			if(fileperms($dir) & 0777 != 0777){
				// issue warning about not being able to change gallery dir perms to 777
				// this may or may NOT be a problem.  Let user decide.
				$warning_num = 2;
				return false;
			} else return true;

		} else {
			// existing gallery is a file rather than a directory
			// needs to be corrected by user first
			$warning_num = 1;
			return false;
		}
	}
	return true;
}

function com_install()
	{
	require_once("../configuration.php");
	global $mosConfig_absolute_path, $ftpIsAvailable, $ftpUse;
	$galleryDir = $mosConfig_absolute_path.'/images/gallery';
	$thumbsDir = $galleryDir.'/thumbs';
	$warning=false;
	
	// now check if there actually IS an existing gallery dir.  Perms should be
	// fixed by now.  If there is and we are running in safemode, then ownership
	// of the directory must be the ftp user.
	
	// for safemode, we compare file ownership to the mambo 'components' subdirectory
	// since if this is a successful and running MOS safemode installation, the
	// ownership of this subdirectory must be the FTP client id for this host.
	
	if(file_exists($galleryDir) && !is_dir($galleryDir)){
		// existing file with same name as gallery. Needs to be deleted by user
	   	echo "<p>Warning!  You already have an existing file with the name 'gallery' in the".
		   " MOS 'images' subdirectory.  This file will need to be deleted or renamed, and the ".
		   "$galleryDir subdirectory and its $thumbsDir subdirectory created manually ".
		   "using your host FTP client before the gallery can be used.</p>";
			echo "<p><b>RSGallery Installed With Warning!</b></p>";
			echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
			echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
			return;
	} elseif (is_dir($galleryDir)) {
		echo "<p>Detected existing Gallery directory: <strong>$galleryDir</strong>.</p>";
		if(ini_get('safe_mode') &&
	    	fileowner($galleryDir) != fileowner($mosConfig_absolute_path.'/components')){
	    	// error, existing gallery directory ownership must be changed
	    	// we will not even be able to read this directory beyond this point
	    	echo "<p>Warning!  You already have an existing Gallery directory ($galleryDir) that is not of the".
				" correct <b>file ownership</b>.  Since this host is running with <b>SafeMode</b> enabled, ".
				"all directories must be created and owned by the FTP host client id.  You will need" .
				" to delete or rename this existing directory, or correct the file ".
				" ownership issue before RSGallery will function correctly.</p>";
			echo "<p><b>RSGallery Installed With Warning!</b></p>";
			echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
			echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
			return;
		}
		// correct the permissions if we can on the existing gallery directory
		if(!setDirPermsOnGallery($galleryDir, $warning_num)){
			// could not set correct perms on an existing gallery dir
	    	echo "<p>Warning!  Could not set the correct permissions of '777' on the $galleryDir ".
				"subdirectory.  Permissions are currently set at: ". decoct(fileperms($galleryDir)).".".
				"  Please rectify this if deemed necessary before using RSGallery.</p>";
			$warning = true;
		}
		// check for thumbs subdirectory
		if(file_exists($thumbsDir) && !is_dir($thumbsDir)){
			// existing file with same name as thumbs subdir. Needs to be deleted by user
	   		echo "<p>Warning!  You already have an existing file with the name 'thumbs' in the".
		   " $galleryDir subdirectory.  This file will need to be deleted or renamed, and the ".
		   "$thumbsDir subdirectory created manually ".
		   "using your host FTP client before the RSGallery can be used.</p>";
			echo "<p><b>RSGallery Installed With Warning!</b></p>";
			echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
			echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
			return;
		} elseif (is_dir($thumbsDir)) {
			echo "<p>Detected existing Gallery thumbs subdirectory: <strong>$thumbsDir</strong>.</p>";
			if(ini_get('safe_mode') &&
	    		fileowner($thumbsDir) != fileowner($mosConfig_absolute_path.'/components')){
	    		// error, existing thumbs directory ownership must be changed
	    		echo "<p>Warning!  You already have an existing thumbs subdirectory $thumbsDir that is not of the".
				" correct <b>file ownership</b>.  Since this host is running with <b>SafeMode<b> enabled, ".
				"all directories must be created and owned by the FTP host client id.  You will need" .
				" to delete or rename this existing subdirectory, or correct the file " .
				" ownership issue before RSGallery will function correctly.</p>";
			echo "<p><b>RSGallery Installed With Warning!</b></p>";
			echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
			echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
			return;
			}
			// correct the permissions if we can and need to on the existing thumbs directory
			if(!setDirPermsOnGallery($thumbsDir, $warning_num)){
				// could not set correct perms on an existing thumbs subdir
	    		echo "<p>Warning!  Could not set the correct permissions of '777' on the $thumbsDir ".
					"subdirectory.  Permissions are currently set at: ". decoct(fileperms($thumbsDir)).".".
					"  Please rectify this if deemed necessary before using RSGallery.</p>";
				$warning=true;
			}
		} elseif(!file_exists($thumbsDir)){
			// no thumbs subdirectory.  Could be an old RSGallery format
			// go create a subdirectory
			if(isset($ftpIsAvailable) && $ftpIsAvailable && function_exists('makeDir') && $ftpUse)
				makeDir($thumbsDir, 0777);
			else
				@mkdir($thumbsDir, 0777);
			if(!file_exists($thumbsDir)){
				// error, directory not created
	    		echo "<p>Warning!  Cannot create the $thumbsDir subdirectory for unknown ".
				"reasons.  Please create this subdirectory manually thru your host FTP client ".
				"before using RSGallery.</p>";
				echo "<p><b>RSGallery Installed With Warning!</b></p>";
				echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
				echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
				return;
			} elseif ((fileperms($thumbsDir) & 0777) != 0777){
				// error, permissions are incorrect
	    		echo "<p>Warning!  Could not set the correct permissions of '777' on the $thumbsDir ".
					"subdirectory.  Permissions are currently set at: ". decoct(fileperms($thumbsDir)).".".
					"  Please rectify this if deemed necessary before using RSGallery.</p>";
				$warning=true;
			}
			// success!  thumbsDir created.
			echo "Created gallery thumbs subdirectory <strong>$thumbsDir</strong>... <b>OK</b><br />";
			echo "<p><b>RSGallery Installed" . ($warning ? " with Warnings" : " Successfully") ."!</b></p>";
			echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
			echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
			return;
		}

	}

	// If we get here, then there is no existing gallery directory.  Fresh install.

	if(isset($ftpIsAvailable) && $ftpIsAvailable && function_exists('makeDir') && $ftpUse){
		makeDir($galleryDir, 0777);
		makeDir($thumbsDir, 0777);
	} else {
		@mkdir($galleryDir, 0777);
		@mkdir($thumbsDir, 0777);
	}
	
	// Now do a final check to see if the gallery directory and thumbs subdir now exist with the proper
	// permissions

	if(!is_dir($galleryDir)){
	    echo "<p>Warning!  Cannot create the $galleryDir subdirectory for unknown ".
			"reasons.  Please create this subdirectory and the $thumbsDir manually thru your host FTP client ".
			"before using RSGallery.</p>";
		echo "<p><b>RSGallery Installed With Warning!</b></p>";
		echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
		echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
		return;
	} elseif(is_dir($galleryDir) && (fileperms($galleryDir) & 0777) != 0777){
	    echo "<p>Warning!  Created directory $galleryDir, but could not set the correct ".
			"permissions of '777'.  Permissions are currently set at: ". decoct(fileperms($galleryDir)).".".
			"  Please rectify this if deemed necessary before using RSGallery.</p>";
				$warning=true;
	}
	if(!is_dir($thumbsDir)){
	    echo "<p>Warning!  Cannot create the $thumbsDir subdirectory for unknown ".
			"reasons.  Please create this subdirectory manually thru your host FTP client ".
			"before using RSGallery.</p>";
		echo "<p><b>RSGallery Installed With Warning!</b></p>";
		echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
		echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
		return;
	} elseif(is_dir($thumbsDir) && (fileperms($thumbsDir) & 0777) != 0777){
	    echo "<p>Warning!  Created directory $thumbsDir, but could not set the correct ".
			"permissions of '777'.  Permissions are currently set at: ". decoct(fileperms($thumbsDir)).".".
			"  Please rectify this if deemed necessary before using RSGallery.</p>";
		$warning=true;
	}
	echo "<p><b>RSGallery Installed" . ($warning ? " with Warnings" : " Successfully") ."!</b></p>";
	echo "You can start using this gallery by going to <strong>Components->RSGallery</strong> and creating a new category.<br>";
	echo "If you want support, browse to the <a href=\"http://www.webdreamers.nl/index.php?option=com_simpleboard&Itemid=56\">Support Forum.</a>";
}
?>