<?php
//
// Copyright (C) 2003 Jan de Graaff
// All rights reserved.
//
// This program uses parts of the original Simpleboard Application
// 0.7.0b written by Josh Levine; http://www.joshlevine.net
//
// This source file is part of the SimpleBoard Component, a Mambo 4.5
// custom Component By Jan de Graaff - http://tsmf.jigsnet.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Please note that the GPL states that any headers in files and
// Copyright notices as well as credits in headers, source files
// and output (screens, prints, etc.) can not be removed.
// You can extend them with your own credits, though...
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class sb_auth {

   function validate_user ( &$forum, &$allow_forum, $groupid, &$acl)
   {

      if ($forum->pub_recurse) {
         $pub_recurse="RECURSE";
      } 
      else {
         $pub_recurse="NO_RECURSE";
      }

      if ($forum->admin_recurse) {
         $admin_recurse="RECURSE";
      } 
      else {
         $admin_recurse="NO_RECURSE";
      }

      if ($forum->pub_access == 0 || ($forum->pub_access == -1 && $groupid > 0) || in_array($forum->id,$allow_forum)) {
      //this is a public forum; let 'Everybody' pass
      //or this forum is for all registered users and this is a registered user
      //or this forum->id is already in the cookie with allowed forums
         return 1;
      }
      else {//access restrictions apply; need to check

         if( $groupid == $forum->pub_access ) {
         //the user has the same groupid as the access level requires; let pass
         return 1;
         }
         else {
            if ($pub_recurse=='RECURSE') {
               //check if there are child groups for the Access Level
               $group_childs=array();
               $group_childs=$acl->get_group_children( $forum->pub_access, 'ARO', $pub_recurse );

               if ( is_array( $group_childs ) && count( $group_childs ) > 0) {
                  //there are child groups. See if user is in any ot them
                  if ( in_array($groupid, $group_childs) ) {
                     //user is in here; let pass
                     return 1;
                  }
               }
            }
         }

         //no valid frontend users found to let pass; check if this is an Admin that should be let passed:

         if( $groupid == $forum->admin_access ) {
            //the user has the same groupid as the access level requires; let pass
            return 1;
         }
         else {
            if ($admin_recurse=='RECURSE') {
               //check if there are child groups for the Access Level
               $group_childs=array();
               $group_childs=$acl->get_group_children( $forum->admin_access, 'ARO', $admin_recurse );

               if (is_array( $group_childs ) && count( $group_childs ) > 0) {
                  //there are child groups. See if user is in any ot them
                  if ( in_array($groupid, $group_childs) ) {
                     //user is in here; let pass
                     return 1;
                  }
               }
            }
         }
      }
     //passage not allowed
     return 0;
   }//end validate function
}//end class
?>
