<?php
//
// Copyright (C) 2003 Jan de Graaff
// All rights reserved.
//
// This program uses parts of the original Simpleboard Application
// 0.7.0b written by Josh Levine; http://www.joshlevine.net
//
// This source file is part of the SimpleBoard Component, a Mambo 4.5
// custom Component By Jan de Graaff - http://tsmf.jigsnet.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Please note that the GPL states that any headers in files and
// Copyright notices as well as credits in headers, source files
// and output (screens, prints, etc.) can not be removed.
// You can extend them with your own credits, though...
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//

/**
 * @package com_simpleboard
 * @version $Revision: 1.1 $ by $Author: jigsjdg $ ($Date: 2005/07/27 10:09:40 $) 
 * @author Thomas Despoix
 */
 
// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

function sbJsEscape($msg) {
  // escape javascript quotes and backslashes, newlines, etc.
  static $convertions = array(
    '\\'=>'\\\\',
    "'" =>"\\'",
    '"' =>'\\"',
    "\r"=>'\\r',
    "\n"=>'\\n',
    '</'=>'<\/');
    
  return strtr($msg, $convertions);
}

function sbAlert ($msg) {
  $msg = sbJsEscape($msg);
  echo "<script> alert('$msg'); </script>\n";
}

function sbAssertOrGoBack($predicate, $msg) {
  if (!$predicate) {
    $msg = sbJsEscape($msg);
    echo "<script> alert('$msg'); window.history.go(-1); </script>\n";
    exit();
  }
}

function sbAssertOrGoTo($predicate, $msg, $url) {
  if (!$predicate) {
    $msg = sbJsEscape($msg);
    $url = sefRelToAbs($url);
    echo "<script> alert('$msg'); window.location=$url'; </script>\n";
  }
}

function sbSetTimeout($url,$time,$script=1) {
	   $url=sefRelToAbs($url);
	   if ($script)
	   		echo '<script language="javascript">setTimeout("location=\''.$url.'\'",$time)</script>';
	   else
	   		echo 'setTimeout("location=\''.$url.'\'",$time)';
}	

function sbRedirect($url,$time,$msg) {
	echo '<script language="javascript">';
	echo 'alert(\''. sbJsEscape($msg) .'\')';
	sbSetTimeout($url,$time,0);
	echo '</script>';
}


?>

