<?php 
/**
 * mamml.php
 * 
 * <p>Main frontend file for MaMML</p>
 * 
 * @package MaMML
 * @subpackage frontend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.5.0
 * @since 0.4.3
 * @link http://www.schmalls.com
 * @tutorial MaMML/MaMML.manual.pkg#frontend
 */

 /**
  * Makes sure this is included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

 // include required files
 require_once ($mainframe->getPath('front_html'));
 require_once ($mosConfig_absolute_path . '/administrator/components/com_mamml/classes/class.mailing.php');
 require_once ($mosConfig_absolute_path . '/administrator/components/com_mamml/classes/class.subscribers.php');
 require_once ($mosConfig_absolute_path . '/administrator/components/com_mamml/configuration.php');
 require_once ($mosConfig_absolute_path . '/administrator/components/com_mamml/classes/class.phpmailer.php' );
 require_once ($mosConfig_absolute_path . '/administrator/components/com_mamml/classes/class.smtp.php' );
  
 /**
  * Mailing class
  * 
  * @global class $mailing
  */
 $mailing = new mailing();
 
 /**
  * Subscriber class
  * 
  * @global class $subscribers
  */
 $subscribers = new subscribers();
 
 /**
  * The list to work with
  * 
  * @global int $listid
  */ 
 $listid = mosGetParam($_REQUEST, 'listid', 0);
 /**
  * The user's id
  * 
  * @global string $userid
  */
 $userid = $my->id;
 /**
  * The action to perform
  * 
  * @global string $action
  */
 $action = mosGetParam($_REQUEST, 'action', '');
 /**
  * The task to perform
  * 
  * @global string $task
  */
 $task = mosGetParam($_REQUEST, 'task', '');
 /**
  * The mailing to work with
  * 
  * @global string $letterid
  */
 $letterid = mosGetParam($_REQUEST, 'letterid', '');
 /**
  * The user type
  * 
  * @global string $type
  */
 $type = mosGetParam($_REQUEST, 'type', '');
 /**
  * Check for authentication
  * 
  * @global string $test
  */
 $test = mosGetParam($_REQUEST, 'test', '');
 /**
  * Message to be displayed
  * 
  * @global string $message
  */
 $message = mosGetParam($_REQUEST, 'message', '');

 // include language file, or default to english
 if (file_exists ($mosConfig_absolute_path . '/components/com_mamml/languages/' . $mosConfig_lang . '.php')) {
	include_once ($mosConfig_absolute_path . '/components/com_mamml/languages/' . $mosConfig_lang . '.php');
 } else {
	include_once ($mosConfig_absolute_path . '/components/com_mamml/languages/english.php');
 } // end if
 
 // get user's id if not defined
 if ($userid == '' && $test != '') {
	 $userid = mosGetParam($_REQUEST, 'userid', '');
	 if (!(registeredCheck() || unregisteredCheck())) {
		 $userid = '';
		 $action = '';
		 echo '<p>' . _NOT_AUTH . '</p>';
	 } // end if
 } // end if
 if ($action == '') {
	// set type to registered if user is logged in or unregistered if not
	if ($userid != '') {
		$action = 'registered';
		$type = 'registered';
	} else {
		$action = 'unregistered';
		$type = 'unregistered';
		$task = 'showOptions';
	} // end if
 } // end if
 
 // add any new registered users who are not in the mamml table
 $query = 'SELECT M.* FROM `#__users` AS M LEFT JOIN `#__mamml_subscribers` AS N ON M.id = N.subscriber_id WHERE N.subscriber_id IS NULL';
 $database->setQuery($query);
 $rows = $database->loadObjectList();
 $error = $database->getErrorMsg();
 // quit on error
 if (!empty($error)) {
	 echo '<p><b>Error (admin.mamml.php-> line ' . __LINE__ . '):</b> Error getting newly added mambo users. Database error: <br />' . $error . '</p>';
 } else {
	 foreach ($rows as $row) {
		 $query = 'INSERT INTO `#__mamml_subscribers` (`subscriber_id`, `subscribe_date`) VALUES (\'' . $row->id . '\', NOW())';
		 $database->setQuery($query);
		 $database->query();
		 $error .= $database->getErrorMsg();
	 } // end foreach
	 // output error messages
	 if (!empty($error)) {
		 echo '<p><b>Error (admin.mamml.php-> line ' . __LINE__ . '):</b> Error adding new users to subscribers table. Database error: <br />' . $error . '</p>';
	 } // end if
 } // end if
 
 // delete any deleted registered users who are still in the mamml table
 $query = 'SELECT M.* FROM `#__mamml_subscribers` AS M LEFT JOIN `#__users` AS N ON N.id = M.subscriber_id WHERE N.id IS NULL';
 $database->setQuery($query);
 $rows = $database->loadObjectList();
 $error = $database->getErrorMsg();
 // quit on error
 if (!empty($error)) {
	 echo '<p><b>Error (admin.mamml.php-> line ' . __LINE__ . '):</b> Error getting newly added mambo users. Database error: <br />' . $error . '</p>';
 } else {
	 foreach ($rows as $row) {
		 $query = 'DELETE FROM `#__mamml_subscribers` WHERE `subscriber_id` = \'' . $row->subscriber_id . '\'';
		 $database->setQuery($query);
		 $database->query();
		 $error .= $database->getErrorMsg();
	 } // end foreach
	 // output error messages
	 if (!empty($error)) {
		 echo '<p><b>Error (admin.mamml.php-> line ' . __LINE__ . '):</b> Error adding new users to subscribers table. Database error: <br />' . $error . '</p>';
	 } // end if
 } // end if
 
 // switch by action
 $displaySubscriptions = true;
 switch ($action) {
	// user is a registered subscriber
	case ('registered') :
		// call registered
		$type = 'registered';
		$displaySubscriptions = registered();
		break;
	// user is an unregistered subscriber
	case ('unregistered') :
		$type = 'unregistered';
		// call unregistered
		$displaySubscriptions = unregistered();
		break;
	// user is an administrator performing administrative tasks
	case ('admin') :
		// call admin and check whether to show subscriptions
		$displaySubscriptions = admin();
		break;
	// letter
	case ('letter') :
		// don't show subscriptions
		$displaySubscriptions = false;
		// call letter
		letter();
		break;
	case ('log') :
		// log statistics
		$displaySubscriptions = false;
		logStatistics();
 } // end switch
 
 // show subscriptions
 if ($displaySubscriptions) {
	showSubscriptions(); 
 } // end if
 
 /** Shows the subscriptions for user
  * 
  * <p>Gets the subscriber's subscriptions from the database and displays a 
  * subscriptions form.</p>
  * 
  * @version 0.4.9
  * @since 0.4.3
  * @global class access to the database
  * @global int the user's id
  * @global string the action to be taken
  * @global string md5 of email to check if here from link in email
  * @global string the user type
  * @uses frontend_html::showSubscriptions()
  * @return boolean to show whether successfull or not
  */
 function showSubscriptions() {
	global $database, $userid, $action, $test, $type;
	
	// get subscriptions from database
	switch ($type) {
		case ('unregistered') :
			$query = 'SELECT M.* FROM `#__mamml_unregistered` AS M WHERE M.unregistered_id = \'' . $userid . '\'';
			break;
		case ('registered') :
			$query = 'SELECT N.name, N.email, M.* FROM `#__mamml_subscribers` AS M, `#__users` AS N WHERE N.id = M.subscriber_id AND M.subscriber_id = \'' . $userid . '\'';
			break;
		default :
			echo '<p align="center"><b>Error (mamml.php->showSubscriptions() line ' . __LINE__ . '):</b> Unknown subscriber type.<p>';
			break;
	} // end switch
	$database->setQuery($query);
	$database->loadObject($subscriptions);
	$error = $database->getErrorMsg();
	// get letters from database
	$query = 'SELECT `id`, `list_name`, `hidden` FROM `#__mamml_letters`';
	$database->setQuery($query);
	$letters = $database->loadObjectList();
	$error .= $database->getErrorMsg();
	// if error, print error message and stop, else continue
	if ((!empty($error)) && (!empty($subscriptions))) {
		echo '<p align="center"><b>Error (mamml.php->showSubscriptions() line ' . __LINE__ . '):</b> Could not find subscriptions and/or letters. Database error : <br />' . $error . '</p>';
		return false;	
	} else {
		// finally show subscriptions
		frontend_html :: showSubscriptions($userid, $action, $subscriptions, $letters, $test, $type);
		return true;	
	} // end if
 } // end function
 
 /**
  * Does registered subscriber functions by task
  * 
  * <p>It can update the user's subscriptions, register a user to the site, 
  * or login the user.</p>
  * 
  * @version 0.5.0
  * @since 0.4.3
  * @global class access to the database
  * @global int the user's id
  * @global string the task to be performed
  * @uses updateRegisteredSubscriptions()
  * @uses frontend_html::registerForm()
  * @uses saveRegistration()
  * @uses frontend_html::showLogin()
  * @return boolean to check whether to display the subscriptions area
  */
 function registered() {
	 global $database, $userid, $task;
 	 
	 // switch by task
	 switch ($task) {
		// update subscriptions 
		case ('updateSubscriptions') :
			$result = updateRegisteredSubscriptions($userid);
			// check if update was successful
			if ($result) {
				echo '<p>' . _UPDATED_SUCCESSFULLY . '</p>';
			} else {
				echo '<p align="center"><b>Error (mamml.php->registered() line ' . __LINE__ . '):</b> Error updating subscriptions.</p>';
				return false;
			} // end if
			return true;
		// show registration form
		case ('register') :
			// get letters
			$query = 'SELECT * FROM `#__mamml_letters` WHERE `hidden` = 0';
			$database->setQuery($query);
			$letters = $database->loadObjectList();
			$error = $database->getErrorMsg();
			// quit on error
			if (!empty($error)) {
				echo '<p align="center"><b>Error (mamml.html.php->registerForm() line 140): Could not load letters. Database error: <br />' . $error . '</p>';
			} else {
				frontend_html :: registerForm($letters);
			} // end if
			return false;
		// register new user to site and add subscriptions
		case ('doRegistration') :
			// register user to mambo site
			$check = saveRegistration();
			// make sure user was registered
			if (!$check) {
				echo '<p align="center"><b>Error (mamml.php->registered() line ' . __LINE__ . '):</b> User not registered to mambo site.</p>';
				return false;
			} else {
				// get user's id
				$username = mosGetParam($_REQUEST, 'username', '');
				$query = 'SELECT `id` FROM `#__users` WHERE `username` = \'' . $username . '\'';
				$database->setQuery($query);
				$userid = $database->loadRow();
				$error = $database->getErrorMsg();
				$userid = $userid[0];
				// add user to database
				$query = 'INSERT INTO `#__mamml_subscribers` (`subscriber_id`) VALUES (\'' . $userid . '\')';
				$database->setQuery($query);
				$database->query();
				$error .= $database->getErrorMsg();
				// quit on error
				if (!empty($error)) {
					echo '<p align="center"><b>Error (mamml.php->registered() line ' . __LINE__ . '):</b> Error adding user to database. Database error: <br />' . $error . '</p>';
					return false;
				} else {
					// get letters from database
					$query = 'SELECT `id` FROM `#__mamml_letters`';
					$database->setQuery($query);
					$letters = $database->loadObjectList();
					$error = $database->getErrorMsg();
					// quit on error
					if (!empty($error)) {
						echo '<p align="center"><b>Error (mamml.php->registered() line ' . __LINE__ . '):</b> Could not find letters. Database error : <br />' . $error . '</p>';
						return false;	
					} else {
						// set subscription details
						foreach ($letters as $letter) {
							// get the value of each of the newsletter values (yes or no)
							$letterid = $letter->id;
							$newvalue = mosGetParam( $_REQUEST, $letterid, 0 );
							$query = 'UPDATE `#__mamml_subscribers` SET `list_' . $letterid . '` = \'' . $newvalue . '\' WHERE subscriber_id= \'' . $userid . '\'';
							$database->setQuery($query);
							$database->query();
							$error .= $database->getErrorMsg();
						} // end foreach
						// quit on error
						if (!empty($error)) {
							echo '<p align="center"><b>Error (mamml.php->registered() line ' . __LINE__ . '):</b> Could not add subscriptions to database. Database error: <br />' . $error . '</p>';
							return false;
						} else {
							// set the receive html and subscribe date parameters
							$receivehtml = mosGetParam( $_POST, 'receivehtml', 0);
							$query = 'UPDATE `#__mamml_subscribers` SET `receive_html` = \'' . $receivehtml . '\', `subscribe_date` = NOW() WHERE `subscriber_id` = \'' . $userid . '\'';
							$database->setQuery($query);
							$database->query();
							$error = $database->getErrorMsg();
							// quit on error
							if (!empty($error)) {
								echo '<p align="center"><b>Error (mamml.php->registered() line ' .__LINE__ . '):</b> Could not set receive html in database. Database error: <br />' . $error . '</p>';
								return false;
							} else {
								echo "<p>" . _INFO_UPDATED_SUCCESSFULLY . "</p>";
							} // end if
						} // end if
					} // end if
				} // end if				
			} // end if
			return true;
		// show login form
		case ('login') :
			frontend_html :: showLogin();
			return false;
		default :
			// make sure this is actually a registered subscriber
			if ($userid == 0) {
				return false;
			} else {
				return true;
			} // end if
	 } // end switch
 } // end function
 
 /** 
  * Does unregistered subscriber functions by task
  * 
  * <p>It can update the user's subscriptions, add an unregistered 
  * subscriber, confirm a subscriber, and show default options.</p>
  * 
  * @version 0.4.15
  * @since 0.4.3
  * @global class access to the database
  * @global int Itemid to help with the pathway
  * @global array configuration options
  * @global int the user's id
  * @global string the task to be performed
  * @global string md5 of email address to check if user clicked here from email
  * @global class access to mailing functions
  * @uses updateUnregisteredsubscriptions()
  * @uses frontend_html::newUnregistered()
  * @uses mailing::send()
  * @uses unregisteredCheck()
  * @return boolean to see whether to display the subscriptions area
  */
 function unregistered() {
	 global $database, $Itemid, $newsletterConfig, $userid, $task, $test, $mailing;
	 
	 $returnValue = true;
	 // switch by task
	 switch ($task) {
		 // update subscriptions
		 case ('updateSubscriptions') :
		 	$returnValue = unregisteredCheck();
			// make sure clicked on from email
			if ($returnValue) {
			 	$result = updateUnregisteredSubscriptions($userid);
				// check if update was successful
				if ($result) {
					echo '<p>' . _INFO_UPDATED_SUCCESSFULLY . '</p>';
				} else {
					echo '<p align="center"><b>Error (mamml.php->unregistered() line ' . __LINE__ . '):</b> Error updating subscriptions.</p>';
				} // end if
			} else {
				echo '<p>' . _CANNOTCHANGE . '</p>';	
			}// end if
			break;
		// new unregistered
		case ('newUnregistered') : 
			// get letters from database
			$query = 'SELECT `id`, `list_name` FROM `#__mamml_letters` WHERE `hidden` = 0';
			$database->setQuery($query);
			$letters = $database->loadObjectList();
			$error = $database->getErrorMsg();
			// if error, print error message and stop, else continue
			if (!empty($error)) {
				echo '<p align="center"><b>Error (mamml.php->unregistered() line ' . __LINE__ . '):</b> Could not find letters. Database error : <br />' . $error . '</p>';	
			} else {
				// show form and don't show subscriptions
				frontend_html :: newUnregistered($letters);	
			} // end if
			return false;
		// add new unregistered subscriber
		case ('addUnregistered') :
			// check if unregistered users are allowed
			if ($newsletterConfig['allow_unregistered'] != 0) {
				// if so, get email address
				$email = mosGetParam($_REQUEST, 'email', '');
				// make sure email address was received
				if ($email == '') {
					echo '<p align="center"><b>Error (mamml.php->unregistered() line ' . __LINE__ . '):</b> Email address not received.</p>';
					return false;
				} else {
					// check if email already in database
					$query = 'SELECT * FROM `#__mamml_unregistered` WHERE `email` = \'' . $email . '\'';
					$database->setQuery($query);
					$check = $database->loadRow();
					// quit if address in database
					if (count($check) > 1) {
						echo '<p>' . _EMAIL_ALREADY_REGISTERED . '</p>';
						return false;	
					} else {
						// add user to database
						$confirmed = $newsletterConfig['require_confirmation'] ? 0 : 1;
						$query = 'INSERT INTO `#__mamml_unregistered` (`email`, `subscribe_date`, `confirmed`) VALUES (\'' . $email . '\', NOW(), ' . $confirmed . ')';
						$database->setQuery($query);
						$database->query();
						$error = $database->getErrorMsg();
						// quit on error
						if (!empty($error)) {
							echo '<p align="center"><b>Error (mamml.php->unregistered() line ' . __LINE__ . '):</b> Could not insert new user into database. Database error: <br />' . $error . '</p>';
							return false;
						} else {
							// get user's new id
							$query = 'SELECT LAST_INSERT_ID()';
							$database->setQuery($query);
							$userid = $database->loadResult();
							$result = updateUnregisteredSubscriptions($userid);
							// check if update was successful
							if ($result) {
								echo '<p>' . _UNREGISTEREDADDED . '</p>';
								if ($newsletterConfig['require_confirmation'] != 0) {
									echo '<p>' . _PLEASECONFIRM . '</p>';
									// get subscriber information
									$name = mosGetParam($_REQUEST, 'name', '');
									$receivehtml = mosGetParam($_REQUEST, 'receivehtml', 0);
									// create subscriber array
									$subscriber = array ('subscriber_name' => $name, 'subscriber_email' => $email, 'receive_html' => $receivehtml, 'id' => $userid);
									// create content
									$content = $newsletterConfig['confirm_text'];
									// create to array
									$to = array('subscribe', $subscriber);
									// send the confirm message
									$mailing->send(_WELCOME_SUBJECT, $content, $content, $to, $newsletterConfig['confirm_fromname'], $newsletterConfig['confirm_fromemail'], $newsletterConfig['confirm_return'], $newsletterConfig['confirm_html']);
								} // end if
								// update test
								$test = md5($email);
							} else {
								echo '<p align="center"><b>Error (mamml.php->unregistered() line ' . __LINE__ . '):</b> Error adding subscriber.</p>';
								return false;
							} // end if
						} // end if
					} // end if
				} // end if
			} else {
				// if not, display message
				echo '<p>' . _UNREGISTERED_OFF . '</p>';
				$returnValue = false;
			} // end if
			break;
		// confirm subscriber
		case ('confirm') :
			$returnValue = unregisteredCheck();
			// make sure clicked on from email
			if ($returnValue) {
				// update database to confirmed
				$query = 'UPDATE `#__mamml_unregistered` SET `confirmed` = 1 WHERE `unregistered_id` = \'' . $userid . '\'';
				$database->setQuery($query);
				$database->query();
				$error = $database->getErrorMsg();
				// quit on error
				if (!empty($error)) {
					echo '<p align="center"><b>Error (mamml.php->unregistered() line ' . __LINE__ . '):</b> Error confirming subscriptions in database. Database error: <br />' . $error . '</p>';
					return false;
				} // end if
			} else {
				echo '<p>' . _CANNOTCHANGE . '</p>';	
			}// end if
			break;
		// show options for unregistered user
		case ('showOptions') :
			// make links
			$options = explode('%', _REGISTERED_OPTIONS);
			$linkedOptions = $options[0] . '<a href="index.php?option=com_mamml&Itemid=' . $Itemid . '&action=registered&task=login">' . $options[1] . '</a>' . $options[2] . '<a href="index.php?option=com_mamml&Itemid=' . $Itemid . '&action=registered&task=register">' . $options[3] . '</a>' . $options[4];
			// display message
			echo '<p>' . _WELCOME_MESSAGE . '</p><p>' . $linkedOptions . '</p>';
			// display unregistered option if enabled
			if ($newsletterConfig['allow_unregistered'] == '1') {
				echo '<p>' . _ORUNREGISTERED . ' <a href="index.php?option=com_mamml&Itemid=' . $Itemid . '&action=unregistered&task=newUnregistered">' . _HERE . '</a></p>';
			} // end if
			$returnValue = false;
			break;
	 } // end switch
	 return $returnValue;
 } // end function
 
 /**
  * Does administrative functions on the frontend
  * 
  * <p>Gives options to create, publish, preview, and save newsletters, and 
  * also to view the archive for a list.</p>
  * 
  * @version 0.5.0
  * @since 0.4.3
  * @global class access to mailing functions
  * @global int Itemid to help with the pathway
  * @global int the user's id
  * @global string tells whether it is a registered ot unregistered user
  * @global string the task to be performed
  * @global int the list to be viewed
  * @global int the letter to be viewed
  * @global string md5 of email address
  * @global string the action to perform
  * @uses mailing::getListData()
  * @uses mailing::getLetterData()
  * @uses mailing::getContentItems()
  * @uses frontend_html::createLetter()
  * @uses mailing::publish()
  * @uses mailing::save()
  * @uses frontend_html::previewMailing()
  * @return boolean whether to show subscriptions or not
  */
 function admin() {
	 global $mailing, $Itemid, $userid, $type, $task, $listid, $letterid, $test, $action;
	 
	 // check if user has adequate permissions
	 $permissions = checkPermissions($userid, $type, $listid);
	 if ($permissions < 2) {
	 	echo '<p>' . _NOT_AUTHORIZED . '</p>';
		return false;
	 } // end if
	 
	 // get parameters
	 $fromname = mosGetParam($_REQUEST, 'fromname', '');
	 $fromemail = mosGetParam($_REQUEST, 'fromemail', '');
	 $frombounce = mosGetParam($_REQUEST, 'frombounce', '');
	 
	 // show subscriptions
	 $showSubscriptions = false;
	 // switch by task
	 switch ($task) {
		// create or edit a letter
	 	case ('create') :
			// get layout for list
			$list_data = $mailing->getListData($listid);
			
			// get mailing items
			$list = $mailing->getLetterData($listid);
		  	
			// check if list is new
			$new = 0;
			if(empty($list)) {
				$new = 1;
				$list->list_subject = '';
				$list->list_content = '';
				$list->list_textonly = '';
				$list->attachments = array();
			} // end if
			
			// get contentitems
			$contentitems = $mailing->getContentItems();
			
			// show letter editing area
			frontend_html :: createLetter($userid, $listid, $permissions, $list_data, $list, $new, $contentitems, $type, $test);
			break;
		// publish a letter
		case ('publish') :
			$mailing->publish($listid, $fromname, $fromemail, $frombounce);
			$showSubscriptions = true;
			$action = $type;
			break;
		// preview a letter
		case ('preview') :
			// check if preview needs to be sent or if the preview options need to be displayed
			if(!empty($_POST['emailaddress'])){
				$check = $mailing->publish($listid, $fromname, $fromemail, $frombounce, true);
				// see if mailing was sent successfully
				if ($check) {
					$returnMessage = _MESSAGESENTSUCCESSFULLY;
				} else {
					$returnMessage = _MESSAGENOT;
				} // end if
				echo '<p>' . $returnMessage . '</p>';
				$showSubscriptions = true;
				$action = $type;
			} else {
				$mailing->save();
				frontend_html :: previewMailing($listid, $fromname, $fromemail, $frombounce, $type, $userid, $test);
			} // end if
			break;
		// save a letter
		case ('save') :
			if ($mailing->save()) {
				echo '<p>' . _MAILINGSAVED . '</p>';
			} // end if
			// show the subscriptions
			$showSubscriptions = true;
			$action = $type;
			break;
	 } // end switch
	 return $showSubscriptions;
 } // end function
 
 /**
  * Does newsletter functions for the frontend
  * 
  * <p>Displays the archive options and archive mailings.</p>
  * 
  * @version 0.4.11
  * @since 0.4.3
  * @global int the user's id
  * @global string tells whether it is a registered ot unregistered user
  * @global string the task to be performed
  * @global int the list to be viewed
  * @global class access to the database
  * @global class access to mailing functions
  * @global string url to main site
  * @global object information about the currently logged in user
  * @global string md5 of email address
  * @uses frontend_html::viewArchive()
  * @uses frontend_html::viewMailing()
  * @return boolean to tell if it was successful
  */
 function letter() {
	 global $userid, $type, $task, $listid, $database, $mailing, $mosConfig_live_site, $my, $test;
	 
	 // get and check permissions
	 $permissions = checkPermissions($userid, $type, $listid);
	 if (($permissions != 0) || ($my->id != '')) {
		 // switch by task
		 switch ($task) {
			 // view the archive
			 case ('viewarchive') :
			 	 $query = 'SELECT `send_date` as send_date, `list_subject` as list_subject FROM `#__mamml_mailing` WHERE `list_id` = \'' . $listid . '\'';
				 $database->setQuery($query);
				 $mailings = $database->loadObjectList();
				 $error = $database->getErrorMsg();
				 // quit on error
				 if (!empty($error)) {
					 echo '<p align="center"><b>Error (mamml.php->letter() line ' . __LINE__ . '):</b> Error getting mailings from database. Database error: <br />' . $error . '</p>';
					 return false;
				 } else {
					 // make sure we have an array
					 if (!is_array($mailings)) {
						 $mailings = array();
					 } // end if
					 frontend_html :: viewArchive($userid, $listid, $type, $permissions, $mailings, $test);
				 } // end if
				 break;
			 case ('view') :
			 	 $send_date = mosGetParam($_REQUEST, 'send_date', 0);
				 // make sure we have a send date
				 if ($send_date == 0) {
					 echo '<p align="center"><b>Error (mamml.php->letter() line ' . __LINE__ . '):</b> Error send date not found.</p>';
					 return false;
				 } else {
					 // get mailing from database
					 $query = 'SELECT * FROM `#__mamml_mailing` WHERE `list_id` = \'' . $listid . '\' AND `send_date` = \'' . $send_date . '\'';
					 $database->setQuery($query);
					 $database->loadObject($themailing);
					 $error = $database->getErrorMsg();
					 // quit on error
					 if (!empty($error)) {
						 echo '<p align="center"><b>Error (mamml.php->letter() line ' . __LINE__ . '):</b> Error getting mailing from database. Database error: <br />' . $error . '</p>';
						 return false;
					 } else {
						 // change contentitem placeholders to contentitems
						 $contentitems = array();
						 preg_match_all('/\{contentitem:(.{1,5})\|(.{1})}/', $themailing->list_content, $contentitems, PREG_SET_ORDER);
						 foreach ($contentitems as $contentitem) {
							 $contentid = $contentitem[1];
							 $thecontentitem = $mailing->getContentItem($contentid);
							 if ($contentitem[2] == '1') {
								 $themailing->list_content = str_replace($contentitem[0], '<br /><strong>' . $thecontentitem[0] . '</strong><br />' . $thecontentitem[1] . '<br />' . $thecontentitem[2], $themailing->list_content);
								 $themailing->list_textonly = str_replace($contentitem[0], "\n\r" . $thecontentitem[0] . "\n\r" . $thecontentitem[1] . "\n\r" . $thecontentitem[2], $themailing->list_textonly);
							 } else {
								 $themailing->list_content = str_replace($contentitem[0], '<br /><strong>' . $thecontentitem[0] . '</strong><br />' . $thecontentitem[1], $themailing->list_content);
								 $themailing->list_textonly = str_replace($contentitem[0], "\n\r" . $thecontentitem[0] . "\n\r" . $thecontentitem[1], $themailing->list_textonly);
							 } // end if
							 $images = $mailing->getImageArray($thecontentitem[3]);
							 foreach($images as $image) {
								 $imagestring = '<img src="' . $mosConfig_live_site . '/images/stories/' . $image['image'] . '" align="' . $image['align'] . '" alt="' . $image['alttext'] . '" border="' . $image['border'] . '" />';
								 $themailing->list_content = preg_replace('/{mosimage}/', $imagestring, $themailing->list_content, 1);
								 $themailing->list_textonly = str_replace('{mosimage}', '', $themailing->list_textonly);
							 } // end foreach
						 } // end foreach
						 frontend_html :: viewMailing($themailing, $send_date);
					 } // end if
				 } // end if
				 break;
		 } // end switch
	 } else {
		 echo '<p>' . _NOT_AUTH . '</p>';
		 return false;
	 } // end if
	 return true;
 } // end function
 
 /**
  * Checks the permissions of a user
  * 
  * <p>Gets the user's permissions for the list.
  * 	<ul>
  * 		<li>0: No permissions</li>
  * 		<li>1: Subscribee</li>
  * 		<li>2: Publisher</li>
  * 		<li>3: Admin</li>
  * 	</ul>
  * </p>
  * 
  * @version 0.5.0
  * @since 0.4.3
  * @param int $userid the user's id
  * @param string $type tells whether registered or unregistered
  * @param int $listid the list for which to check
  * @global class access to the database
  * @return int permissions information
  */
 function checkPermissions($userid, $type, $listid) {
	 global $database;
	 
	 // get permissions from database
 	 switch ($type) {
		 case ('unregistered') :
			 $query = 'SELECT `list_' . $listid . '` FROM `#__mamml_unregistered` WHERE `unregistered_id` = \'' . $userid . '\'';
			 break;
		 case ('registered') :
			 $query = 'SELECT `list_' . $listid . '` FROM `#__mamml_subscribers` WHERE `subscriber_id` = \'' . $userid . '\'';
			 break;
		 default :
			 echo '<p align="center"><b>Error (mamml.php->checkPermissions() line ' . __LINE__ . '):</b> Unknown subscriber type.';
			 return 0;
	 } // end switch
	 $database->setQuery($query);
	 $permissions = $database->loadRow();
	 $error = $database->getErrorMsg();
	 // check for database error, quit if there is one, otherwise return permissions
	 if(!empty($error)) {
		 echo '<p align="center"><b>Error (mamml.php->checkPermissions() line ' . __LINE__ . '):</b> Could not get permissions. Database error: <br />' . $error . '</p>';
		 return 0;
	 } else {
		 return $permissions[0];
	 } // end if
 } // end function
 
 /**
  * Updates a registered users subscriptions
  * 
  * <p>Updates the database with the new subscription options.</p>
  * 
  * @version 0.5.0
  * @since 0.4.3
  * @param int $userid the user's id
  * @global class access to the database
  * @return boolean to tell whether it was successful or not
  */
 function updateRegisteredSubscriptions($userid) {
	 global $database;
	 
	 // get current subscriptions
	 $query = 'SELECT M.subscriber_id as subscriber_id, M.* FROM `#__mamml_subscribers` as M WHERE M.subscriber_id = \'' . $userid . '\'';
	 $database->setQuery($query);
	 $database->loadObject($current);
	 $error = $database->getErrorMsg();
	 // quit on error
	 if (!empty($error)) {
		 echo '<p align="center"><b>Error (mamml.php->updateRegisteredSubscriptions() line ' . __LINE__ . '):</b> Could not get current subscriptions. Database error: <br />' . $error . '</p>';
		 return false; 
	 } else {
		 // remove subscriber_id, receive_html, confirmed, subscribe_date
		 unset($current->subscriber_id, $current->receive_html, $current->confirmed, $current->subscribe_date);
		 // update subscriptions
		 foreach ($current as $key => $value) {
			 // update database
			 $newValue = mosGetParam($_REQUEST, str_replace('list_', '', $key), 0);			 
			 $query = 'UPDATE `#__mamml_subscribers` SET `' . $key . '` = \'' . $newValue . '\' WHERE `subscriber_id` = \'' . $userid . '\'';			 
			 $database->setQuery($query);
			 $database->query();
			 $error .= $database->getErrorMsg();			 
		 } // end for
		 // quit on error
		 if (!empty($error)) {
			 echo '<p align="center"><b>Error (mamml.php->updateRegisteredSubscriptions() line ' . __LINE__ . '):</b> Could not update subscriptions. Database error: <br />' . $error . '</p>';
			 return false;
		 } else {
			 // update name, email, and receive html
			 $newName = mosGetParam($_REQUEST, 'name', '');
			 $newEmail = mosGetParam($_REQUEST, 'email', '');
			 $newReceiveHtml = mosGetParam($_REQUEST, 'receivehtml', 0);
			 $query = 'UPDATE `#__users` SET `name` = \'' . $newName . '\', `email` = \'' . $newEmail . '\' WHERE `id` = \'' . $userid . '\'';
			 $database->setQuery($query);
			 $database->query();
			 $error = $database->getErrorMsg();
			 $query = 'UPDATE `#__mamml_subscribers` SET `receive_html` = \'' . $newReceiveHtml . '\' WHERE `subscriber_id` = \'' . $userid . '\'';
			 $database->setQuery($query);
			 $database->query();
			 $error .= $database->getErrorMsg();
			 // quit on error
			 if (!empty($error)) {
				echo '<p align="center"><b>Error (mamml.php->updateRegisteredSubscriptions() line ' . __LINE__ . '):</b> Could not update name, email, and/or receive html. Database error: <br />' . $error . '</p>';
				return false;				 
			 } else {
				return true; 
			 } // end if
		 } // end if
	 } // end if	  
 } // end function
 
 /**
  * Updates an unregistered user's subscriptions
  * 
  * <p>Updates the database with the new subscription options.</p>
  * 
  * @version 0.5.0
  * @since 0.4.3
  * @param int $userid the user's id
  * @global class access to the database
  * @return boolean to tell whether it was successful
  */
 function updateUnregisteredSubscriptions($userid) {
	 global $database;
	 
	 // get current subscriptions
	 $query = 'SELECT * FROM `#__mamml_unregistered` WHERE `unregistered_id` = \'' . $userid . '\'';
	 $database->setQuery($query);
	 $database->loadObject($current);
	 $error = $database->getErrorMsg();
	 // quit on error
	 if (!empty($error)) {
		 echo '<p align="center"><b>Error (mamml.php->updateUnregisteredSubscriptions() line ' . __LINE__ . '):</b> Could not get current subscriptions. Database error: <br />' . $error . '</p>';
		 return false; 
	 } else {
		 // remove unregistered_id, receive_html, confirmed, subscribe_date
		 unset($current->unregistered_id, $current->receive_html, $current->confirmed, $current->subscribe_date);
		 // update subscriptions
		 foreach ($current as $key => $value) {
			 // update database
			 $newValue = mosGetParam($_REQUEST, str_replace('list_', '', $key), 0);	
			 $query = 'UPDATE `#__mamml_unregistered` SET `' . $key . '` = \'' . $newValue . '\' WHERE `unregistered_id` = \'' . $userid . '\'';
			 $database->setQuery($query);
			 $database->query();
			 $error .= $database->getErrorMsg();			 
		 } // end for
		 // quit on error
		 if (!empty($error)) {
			 echo '<p align="center"><b>Error (mamml.php->updateUnregisteredSubscriptions() line ' . __LINE__ . '):</b> Could not update subscriptions. Database error: <br />' . $error . '</p>';
			 return false;
		 } else {
			 // update name, email, and receive html
			 $newName = mosGetParam($_REQUEST, 'name', '');
			 $newEmail = mosGetParam($_REQUEST, 'email', '');
			 $newReceiveHtml = mosGetParam($_REQUEST, 'receivehtml', 0);
			 $query = 'UPDATE `#__mamml_unregistered` SET `name` = \'' . $newName . '\', `email` = \'' . $newEmail . '\', `receive_html` = \'' . $newReceiveHtml . '\' WHERE `unregistered_id` = \'' . $userid . '\'';
			 $database->setQuery($query);
			 $database->query();
			 $error = $database->getErrorMsg();
			 // quit on error
			 if (!empty($error)) {
				echo '<p align="center"><b>Error (mamml.php->updateUnregisteredSubscriptions() line ' . __LINE__ . '):</b> Could not update name, email, and/or receive html. Database error: <br />' . $error . '</p>';
				return false;				 
			 } else {
				return true; 
			 } // end if
		 } // end if
	 } // end if	  
 } // end function
 
 /**
  * Registers a new user to mambo
  * 
  * <p>Updates the database with the new user's information.</p>
  * 
  * @version 0.4.3
  * @since 0.4.3
  * @global class access to the database
  * @global class access to group control information
  * @global string the site's name
  * @global string url to the main site directory
  * @global string check to see whether to use user activation
  * @global string check if user registration is allowed
  * @global string the mail from address
  * @global string the mail from name
  * @return boolean whether it was successful or not
  */
 function saveRegistration() {
	global $database, $acl;
	global $mosConfig_sitename, $mosConfig_live_site, $mosConfig_useractivation, $mosConfig_allowUserRegistration;
	global $mosConfig_mailfrom, $mosConfig_fromname;
	
	if ($mosConfig_allowUserRegistration=="0") {
		mosNotAuth();
		return false;
	} // end if

	$row = new mosUser( $database );

	if (!$row->bind( $_POST, "usertype" )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	} // end if

	mosMakeHtmlSafe($row);

	$row->id = 0;
	$row->usertype = '';
	$row->gid = $acl->get_group_id('Registered','ARO');

	if ($mosConfig_useractivation=="1") {
		$row->activation = md5( mosMakePassword() );
		$row->block = "1";
	} // end if

	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	} // end if

	$pwd = $row->password;
	$row->password = md5( $row->password );
	$row->registerDate = date("Y-m-d H:i:s");

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	} // end if
	$row->checkin();

	$name = $row->name;
	$email = $row->email;
	$username = $row->username;

	$subject = sprintf (_SEND_SUB, $name, $mosConfig_sitename);
	$subject = html_entity_decode($subject, ENT_QUOTES);
	if ($mosConfig_useractivation=="1"){
		$message = sprintf (_USEND_MSG_ACTIVATE, $name, $mosConfig_sitename, $mosConfig_live_site."/index.php?option=com_registration&task=activate&activation=".$row->activation, $mosConfig_live_site, $username, $pwd);
	} else {
		$message = sprintf (_USEND_MSG, $name, $mosConfig_sitename, $mosConfig_live_site);
	} // end if

	$message = html_entity_decode($message, ENT_QUOTES);
	// Send email to user
	if ($mosConfig_mailfrom != "" && $mosConfig_fromname != "") {
		$adminName2 = $mosConfig_fromname;
		$adminEmail2 = $mosConfig_mailfrom;
	} else {
		$database->setQuery( "SELECT name, email FROM #__users"
		."\n WHERE usertype='superadministrator'" );
		$rows = $database->loadObjectList();
		$row2 = $rows[0];
		$adminName2 = $row2->name;
		$adminEmail2 = $row2->email;
	} // end if

	mosMail($adminEmail2, $adminName2, $email, $subject, $message);

	// Send notification to all administrators
	$subject2 = sprintf (_SEND_SUB, $name, $mosConfig_sitename);
	$message2 = sprintf (_ASEND_MSG, $adminName2, $mosConfig_sitename, $row->name, $email, $username);
	$subject2 = html_entity_decode($subject2, ENT_QUOTES);
	$message2 = html_entity_decode($message2, ENT_QUOTES);

	// get superadministrators id
	$admins = $acl->get_group_objects( 25, 'ARO' );

	foreach ( $admins['users'] AS $id ) {
		$database->setQuery( "SELECT email, sendEmail FROM #__users"
			."\n WHERE id='$id'" );
		$rows = $database->loadObjectList();

		$row = $rows[0];

		if ($row->sendEmail) {
			mosMail($adminEmail2, $adminName2, $row->email, $subject2, $message2);
		} // end if
	} // end foreach

	if ( $mosConfig_useractivation == "1" ){
		echo _REG_COMPLETE_ACTIVATE;
	} else {
		echo _REG_COMPLETE;
	} // end if
	return true;
 } // end function
 
 /**
  * Check unregistered subscriber
  * 
  * <p>Makes sure user clicked on link from email, just subscribed for the 
  * first time, or is going to subscribe.</p>
  * 
  * @version 0.4.10
  * @since 0.4.3
  * @global class access to the database
  * @global int the user's id
  * @global string md5 of email address
  * @return boolean to tell whether it was successful
  */ 
 function unregisteredCheck() {
	 global $database, $userid, $test;
	 
 	 $query = 'SELECT * FROM `#__mamml_unregistered` WHERE md5(`email`) = \'' . $test . '\' AND `unregistered_id` = \'' . $userid . '\'';
	 $database->setQuery($query);
	 $check = $database->loadRow();
	 $error = $database->getErrorMsg();
	 if (count($check) < 5) {
		return false; 
	 } else {		
		return true; 
	 } // end if
 } // end function
 
 /**
  * Log statistics
  * 
  * <p>Updates the database with the new statistics and outputs an empty 
  * png file.</p>
  * 
  * @version 0.4.3
  * @since 0.4.3
  * @global int the list to work with
  * @global class access to the database
  * @global string filesystem path to main site directory
  * @global string tells whether this is a registered or unregistered user
  */
 function logStatistics() {
	 global $listid, $database, $mosConfig_absolute_path, $type;
	 
	 // get parameters
	 $senddate = mosGetParam($_REQUEST, 'senddate', 0);
	 $subscriber = mosGetParam($_REQUEST, 'subscriber', 0);
	 // check if the subscriber was provided
	 if ($subscriber != 0) {
		 // if so, log detailed statistics
		 // switch by type
		 switch ($type) {
			 case ('unregistered') :
			 	 $query = 'REPLACE INTO `#__mamml_stats_detailed_unregistered` (`listid`, `send_date`, `subscriber_id`, `html`, `read`) VALUES (\'' . $listid . '\', \'' . $senddate . '\', \'' . $subscriber . '\', \'1\', \'1\')';
			 	 break;
			 case ('registered') :
			 	 $query = 'REPLACE INTO `#__mamml_stats_detailed` (`listid`, `send_date`, `subscriber_id`, `html`, `read`) VALUES (\'' . $listid . '\', \'' . $senddate . '\', \'' . $subscriber . '\', \'1\', \'1\')';
				 break;
		 } // end switch
		 $database->setQuery($query);
		 $database->query();
	 } // end if
	 // log views into global table
	 $query = 'UPDATE `#__mamml_stats_overall` SET `html_read` = `html_read` + 1 WHERE `listid` = \'' . $listid . '\' AND `send_date` = \'' . $senddate . '\'';
	 $database->setQuery($query);
	 $database->query();
	 // clear all output
	 ob_end_clean();
	 // open image file
	 $filename = $mosConfig_absolute_path . '/images/blank.png';
	 $handle = fopen($filename, 'r');
	 // get image contents
	 $contents = fread($handle, filesize($filename));
	 // close image file
	 fclose($handle);
	 // output content type
	 header("Content-type: image/png");
	 // print image
	 echo $contents;
	 // exit
	 exit();
 } // end function
 
 /**
  * Check registered subscriber
  * 
  * <p>Makes sure user clicked on link from email.</p>
  * 
  * @version 0.4.10
  * @since 0.4.10
  * @global class access to the database
  * @global int the user's id
  * @global string md5 of email address
  * @return boolean to tell whether it was successful
  */ 
 function registeredCheck() {
	 global $database, $userid, $test;
	 
 	 $query = 'SELECT * FROM `#__users` WHERE md5(`email`) = \'' . $test . '\' AND `id` = \'' . $userid . '\'';
	 $database->setQuery($query);
	 $check = $database->loadRow();
	 $error = $database->getErrorMsg();
	 if (count($check) < 5) {
		return false; 
	 } else {		
		return true; 
	 } // end if
 } // end function
 
 // show footer if enabled
 if ($newsletterConfig['show_footer'] == 1) {
	echo '<p align="center"><a href="http://mamboforge.net/projects/mamml/">MaMML 0.4.15</a> component by <a href="mailto:schmalls+mamml@gmail.com">Schmalls</a></p>'; 
 } // end if
 
?>