<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: admin.mambelfish.php,v 1.4 2005/03/16 13:45:34 akede Exp $
//
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mainframe->getPath( 'class' ) );
require_once( $mainframe->getPath( 'admin_html' ) );

if( !defined( '_MBF_LANG_INCLUDED') ) {
	if (file_exists($mosConfig_absolute_path .'/components/com_mambelfish/language/'.$mosConfig_lang.'.php')) {
		require_once ($mosConfig_absolute_path .'/components/com_mambelfish/language/'.$mosConfig_lang.'.php');
	} else {
		require_once ($mosConfig_absolute_path .'/components/com_mambelfish/language/english.php');
	}
	define( "_MBF_LANG_INCLUDED", true );
}

$mambelFishManager = new MambelFishManager( dirname( __FILE__ ) );

$task = mosGetParam( $_REQUEST, 'task', array(0) );
$act = mosGetParam( $_REQUEST, 'act', '' );
$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}
$fileCode = mosGetParam( $_REQUEST, 'fileCode', '' );

if($mosConfig_debug) {
	reset ($_POST);
	while (list ($key, $val) = each ($_POST)) {
   	echo "$key => $val<br />\n";
	}
}

// Setting default values if variables are not defined
$select_language_id = mosGetParam( $_REQUEST, 'select_language_id', -1 );
$catid = mosGetParam( $_REQUEST, 'catid', '' );
$option = mosGetParam( $_REQUEST, 'option', 'com_mambelfish' );
$language_id = mosGetParam( $_REQUEST, 'language_id', $select_language_id );
$contentid = mosGetParam( $_REQUEST, 'contentid', null );
$mbfc_id  = mosGetParam( $_REQUEST, 'mbfc_id ', null );

if( count($mambelFishManager->getActiveLanguages()) == 0 ) {
	$act = "config_component";
}

switch($act) {

	case "post_install":
		HTML_mambelfish::showPostInstall();
		break;
	
	case "dinnermenu":
		HTML_mambelfish::showDinnermenu();
		break;
	
	case "showInformation":
		HTML_mambelfish::showInformation( $fileCode );
		break;
	
	case "config_component":
		if($task=='saveedit') {
			$mambelFishManager->setCfg( 'noTranslation' , mosGetParam( $_REQUEST, 'frmTranslationMode', 0 ) );
			$mambelFishManager->setCfg( 'defaultText', mosGetParam( $_REQUEST, 'frmTranslationDefaultText', "" ) );
			$mambelFishManager->setCfg( 'frontendMode' , mosGetParam( $_REQUEST, 'frmFrontendMode', "" ) );
			$mambelFishManager->setCfg( 'textSpacer' , mosGetParam( $_REQUEST, 'frmTextSpacer', "" ) );
			
			
			$configSaved = $mambelFishManager->saveConfiguration();
			
			$languagesSaved=false;
			if( is_array($frmLanguageID) ) {
				$languagesSaved = true;
				for ($i=0; $i<count($frmLanguageID); $i++) {
					$mbfLang = new mbfLanguage($database);
					$mbfLang->id =$frmLanguageID[$i];
					$mbfLang->name = $frmLanguageName[$i];
					
					// The checkbox is only filled when it was active - so we have to check if
					// one box is fitting to your language
					if( isset($frmLanguageActive) ) {
						foreach( $frmLanguageActive as $langid ) {
							if( $langid == $mbfLang->id ) {
								$mbfLang->active = true;
								break;
							}
						}
					}
					$mbfLang->iso = $frmLanguageISO[$i];
					$mbfLang->mambo = $frmLanguageMambo[$i];
					$mbfLang->image = $frmLanguageImage[$i];
					$mbfLang->ordering = $frmLanguageOrder[$i];

					if( !$mbfLang->store() ) {
						echo "Error: ".$mbfLang->getError()."<br />";
						$languagesSaved=false;
					}
				}
			}
			
			if( $configSaved && $languagesSaved) {
				//mosRedirect("index2.php?option=$option&act=config_component", _MAMBELFISH_CONFIG_SAVED);
			}
			elseif (!$configSaved) {
				mosRedirect("index2.php?option=$option&act=config_component", _MAMBELFISH_CONFIG_PROBLEMS);
			}
			elseif (!$languagesSaved) {
				mosRedirect("index2.php?option=$option&act=config_component", _MAMBELFISH_LANG_PROBLEMS ." - " .$mbfLang->getError());
			}
		}
		showComponentConfiguration( $mambelFishManager );
		break;
	
	case "config_elements":
		switch ($task) {
			case "edit":
				showElementConfiguration( $mambelFishManager, $cid[0] );
				break;
				
			default:
				showElementOverview( $mambelFishManager, $option );
				break;
		}
		break;
	
	case "translate":
		switch ($task) {
			case "save":
				saveTranslation( $mambelFishManager, $language_id, $catid, $contentid, $mbfc_id );
				showTranslationOverview( $mambelFishManager, $select_language_id, $catid );
				break;
				
			case "edit":
				list($content_id, $language_id) = explode('|', $cid[0]);
				editTranslation( $mambelFishManager, $language_id, $catid, $content_id, $select_language_id );
				break;
			
			case "unpublish":
			case "publish":
				$publish = $task=="publish" ? 1 : 0;
				publishTranslation( $mambelFishManager, $catid, $cid, $publish );
				showTranslationOverview( $mambelFishManager, $select_language_id, $catid );
				break;
			
			case "remove":
				removeTranslation( $mambelFishManager, $catid, $cid );
				showTranslationOverview( $mambelFishManager, $select_language_id, $catid );
				break;
			
			default:
				showTranslationOverview( $mambelFishManager, $select_language_id, $catid );
				break;
		}
		break;
	
	default:
		HTML_mambelfish::showWelcome();
		break;
}

/**
 * Preparation for the component configuration
 */
function showComponentConfiguration( $mambelFishManager ) {
	global $mosConfig_absolute_path, $database;
	
	// 1. read all known languages from the database
	$languages=null;
	$database->setQuery( "SELECT l.* as text"
		. "\nFROM #__mbf_language AS l"
		. "\nORDER BY l.active desc, l.ordering, l.name"
	);
	$languages = $database->loadObjectList();
	
	// Read the languages dir to find new installed languages
	$languageBaseDir = mosPathName(mosPathName($mosConfig_absolute_path) . "language");
	$xmlFilesInDir = mosReadDirectory($languageBaseDir,".xml");

	$dirName = $languageBaseDir;
	$activeFiles = null;

	//mosDebugVar($xmlFilesInDir);
	foreach($xmlFilesInDir as $xmlfile) {
		// Read the file to see if it's a valid template XML file
		$xmlDoc =& new DOMIT_Lite_Document();
		$xmlDoc->resolveErrors( true );
		if (!$xmlDoc->loadXML( $dirName . $xmlfile, false, true )) {
			continue;
		}

		$element = &$xmlDoc->documentElement;

		if ($element->getTagName() != 'mosinstall') {
			continue;
		}
		if ($element->getAttribute( "type" ) != "language") {
			continue;
		}

		$language = getLanguageFromXML( $xmlfile );
		// Let's see if we find the language already
		$languageFound=false;
		foreach($languages as $dbLang) {
			if ($dbLang->mambo == $language->mambo) {
				$languageFound=true;
				break;
			}
		}
		
		if( !$languageFound ) {
			$languages[] = $language;
		}
	}
	HTML_mambelfish::showComponentConfiguration( $mambelFishManager, $languages);
}

/**
 * Helperfunction to retriev the language information from the XML files
 */
function getLanguageFromXML( $xmlfile ) {
	global $mosConfig_absolute_path, $database;

	// Read the language dir to find languages
	$languageBaseDir = mosPathName(mosPathName($mosConfig_absolute_path) . "language");
	$dirName = $languageBaseDir;
	$xmlDoc =& new DOMIT_Lite_Document();
	$xmlDoc->resolveErrors( true );
	if ($xmlDoc->loadXML( $dirName . $xmlfile, false, true )) {
		$lang = new mbfLanguage($database);
		$lang->mambo = substr($xmlfile,0,-4);
		$element = &$xmlDoc->getElementsByPath('name', 1);
		$lang->name = $element->getText();
		$lang->active=false;
	}
	return $lang;
}

/** Presentation of the content element list
 */
function showElementOverview( $mambelFishManager, $option ) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
	$search = $database->getEscaped( trim( strtolower( $search ) ) );

	require_once("includes/pageNavigation.php");
	$total=count($mambelFishManager->getContentElements());
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	HTML_mambelfish::showElementOverview( $mambelFishManager, $option, $search, $pageNav );
}

/** Detailinformation about one specific content element */
function showElementConfiguration( $mambelFishManager, $id ) {
	global $database, $mainframe;

	HTML_mambelfish::showElementConfiguration( $mambelFishManager, $id );
}

/** Presentation of the content's that must be translated
 */
function showTranslationOverview( $mambelFishManager, $language_id, $catid ) {
	global $database, $mainframe, $option;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
	$search = $database->getEscaped( trim( strtolower( $search ) ) );

	// Build up the rows for the table
	$rows=null;
	$total=0;
	if( isset($catid) && $catid!="" ) {
		$contentElement = $mambelFishManager->getContentElement( $catid );
		$database->setQuery( $contentElement->createContentSQL( $language_id, null, $limitstart, $limit ) );
		$rows = $database->loadObjectList();
		if ($database->getErrorNum()) {
			echo $database->stderr();
			return false;
		}
		
		$database->setQuery( $contentElement->countContentSQL($language_id) );
		$result = $database->loadObjectList();
		echo $database->getErrorMsg();
		$total = count( $result );
		
		// Manipulation of result based on further information
		for( $i=0; $i<count($rows); $i++ ) {
			$contentObject = new ContentObject( $language_id, $contentElement );
			$contentObject->readFromRow( $rows[$i] );
			$rows[$i] = $contentObject;
		}
	}
	
	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );
	
	// get list of active languages
	$langOptions[] = mosHTML::makeOption( '-1', _MAMBELFISH_SELECT_LANGUAGES );
	$langOptions[] = mosHTML::makeOption( 'NULL', _MAMBELFISH_SELECT_NOTRANSLATION );
	
	$langActive = $mambelFishManager->getActiveLanguages();
	
	if ( count($langActive)>0 ) {
		foreach( $langActive as $language )
		{
			$langOptions[] = mosHTML::makeOption( $language->id, $language->name );
		}
	}
	$langlist = mosHTML::selectList( $langOptions, 'select_language_id', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $language_id );

	// get list of element names
	$elementNames[] = mosHTML::makeOption( '', _MAMBELFISH_SELECT_ELEMENTS );
	//$elementNames[] = mosHTML::makeOption( '-1', '- All Content elements' );
	$elements = $mambelFishManager->getContentElements();
	foreach( $elements as $key => $element )
	{
		$elementNames[] = mosHTML::makeOption( $key, $element->Name );
	}
	$clist = mosHTML::selectList( $elementNames, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $catid );
	
	HTML_mambelfish::showTranslationOverview( $rows, $search, $pageNav, $langlist, $clist, $catid );
}

/** Details of one content for translation
 */
function editTranslation( $mambelFishManager, $language_id, $catid, $contentid, $select_language_id ) {
	global $database, $mainframe, $my;
	$actContentObject=null;
	
	if( isset($catid) && $catid!="" ) {
		$contentElement = $mambelFishManager->getContentElement( $catid );
		$actContentObject = new ContentObject( $language_id, $contentElement );
		$actContentObject->loadFromContentID( $contentid );
	}

	// fail if checked out not by 'me'
	if ($actContentObject->checked_out && $actContentObject->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=option=com_mambelfish&act=translate",
		"The content item $actContentObject->title is currently being edited by another administrator" );
	}
	
	// get list of active languages
	$langOptions[] = mosHTML::makeOption( 'NULL', _MAMBELFISH_SELECT_NOTRANSLATION );
	
	$langActive = $mambelFishManager->getActiveLanguages();
	
	if ( count($langActive)>0 ) {
		foreach( $langActive as $language )
		{
			$langOptions[] = mosHTML::makeOption( $language->id, $language->name );
		}
	}
	$langlist = mosHTML::selectList( $langOptions, 'language_id', 'class="inputbox" size="1"', 'value', 'text', $actContentObject->language_id );
	
	HTML_mambelfish::showTranslation( $actContentObject, $langlist, $catid, $select_language_id );
}

/** Saves the information of one translation
 */
function saveTranslation( $mambelFishManager, $language_id, $catid, $id, $mbfc_id ) {
	global $database, $mainframe;
	$actContentObject=null;
	
	if( isset($catid) && $catid!="" ) {
		$contentElement = $mambelFishManager->getContentElement( $catid );
		$actContentObject = new ContentObject( $language_id, $contentElement );
		$actContentObject->bind( $_POST );
		$actContentObject->store();
	}
}

/**
 * Reload all translations and publish/unpublish them
 */
function publishTranslation( $mambelFishManager, $catid, $cid, $publish ) {
	foreach( $cid as $cid_row ) {
		list($contentid, $language_id) = explode('|', $cid_row);
		
		$contentElement = $mambelFishManager->getContentElement( $catid );
		$actContentObject = new ContentObject( $language_id, $contentElement );
		$actContentObject->loadFromContentID( $contentid );
		if( $actContentObject->state>=0 ) {
			$actContentObject->setPublished($publish);
			$actContentObject->store();
		}
	}
}

/**
 * Deletes the selected translations (only the translations of course)
 */
function removeTranslation( $mambelFishManager, $catid, $cid ) {
	foreach( $cid as $cid_row ) {
		list($contentid, $language_id) = explode('|', $cid_row);

		$contentElement = $mambelFishManager->getContentElement( $catid );
		$actContentObject = new ContentObject( $language_id, $contentElement );
		$actContentObject->loadFromContentID( $contentid );
		$actContentObject->delete();
	}
}