<?php
/**
 * module/mod_mammlsubscribe.php
 * 
 * <p>Subscribe module for MaMML</p>
 * 
 * @package MaMML
 * @subpackage module
 * @copyright (C) 2004 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @author Matt Woodward
 * @version 0.2.0
 * @since 0.1.0
 * @link http://www.schmalls.com
 */

 /**
  * Makes sure this is included by a parent file
  */
 defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

 // Get the module parameters
 $showintro = 		$params->get('showintro');
 $shownamefield = 	$params->get('shownamefield');
 $receivehtmldefault = 	$params->get('receivehtmldefault');
 $showreceivehtml = 	$params->get('showreceivehtml');
 $listids =			$params->get('listids');
 $linear = 			$params->get('linear');
 $tablesuffix = 		$params->get('tablesuffix');
 
 // Include globals
 global $database, $my;

 // Get language file
 if (file_exists($mosConfig_absolute_path . '/components/com_mamml/languages/' . $mosConfig_lang . '.php')) {
	 include_once($mosConfig_absolute_path . '/components/com_mamml/languages/' . $mosConfig_lang . '.php');
 } else {
	 if (file_exists($mosConfig_absolute_path . '/components/com_mamml/languages/english.php')) {
		 include_once($mosConfig_absolute_path . '/components/com_mamml/languages/english.php');
	 } else {
		 die ("MaMML Module\n<br/>This module needs the MaMML component.");
	 } // end if
 } // end if
 
 // check if a user is logged in
 if ($my->username != '') {
	 $loggedin = 1;
 } else {
	 $loggedin = 0;
 } // end if
 
 // see if this is to be displayed linearly or not
 if ($linear) {
	 $tr = '';
	 $colspan = '';
	 $etr = '';
 } else {
	 $tr = '<tr>';
	 $colspan = 'colspan="2"';
	 $etr = '</tr>';
 } // end if
 // check if user is logged in
 if (!$loggedin) {
?>
<script language="javascript" type="text/javascript">
	function submitmammlmod() {
		var form = document.modMammlForm;
		// do field validation
<?php
 // check if name is shown
 if ($shownamefield) {
?>
		if (form.name.value == "") {
			alert( "<?php echo _REGWARN_NAME;?>" );
		} else <?php } // end if ?> if (form.email.value == "") {
			alert( "<?php echo _REGWARN_MAIL;?>" );
		} else {
			form.submit();
		}
	}
</script>
<?php
 } //end if
?>
<form action="index.php" method="post" name="modMammlForm">
<table border="0" cellspacing="0" cellpadding="0" align="center" class="moduletable<?php echo $tablesuffix; ?>">
<?php
 // check if intro should be displayed
 if ($showintro) {
?>
	<?php echo $tr . "\n"; ?>
		<td <?php echo $colspan; ?>>
			<?php echo _MODINTRO . "\n"; ?>
		</td>
	<?php echo $etr . "\n"; ?>
<?php
 } // end if
 
 // check if user is logged in or not
 if (!$loggedin) {
	 // check if name field should be displayed
	 if ($shownamefield) {
?>
	<?php echo $tr . "\n"; ?>
		<td <?php echo $colspan; ?>>
			<?php echo _INPUT_NAME . "\n"; ?> 
		</td>
	<?php echo $etr . "\n"; ?>
	<?php echo $tr . "\n"; ?>
		<td <?php echo $colspan; ?>>
			<input type="text" size="12" value="" class="inputbox" name="name" />
		</td>
	<?php echo $etr . "\n"; ?>
<?php
	 } // end if
?>
	<?php echo $tr . "\n"; ?>
		<td <?php echo $colspan; ?>>
			<?php echo _MODEMAILADDRESS . "\n"; ?>: 
		</td>
	<?php echo $etr . "\n"; ?>
	<?php echo $tr . "\n"; ?>
		<td <?php echo $colspan; ?>>
			<input type="text" size="12" value="" class="inputbox" name="email" />
		</td>
	<?php echo $etr . "\n"; ?>
<?php
 } else {
?>
	<?php echo $tr . "\n"; ?>
		<td <?php echo $colspan; ?>>		
			<?php echo _CHANGESUBSCRIPTIONS . "\n"; ?>
		</td>
	<?php echo $etr . "\n"; ?>
<?php	
 } // end if
 
 // see if the receive html link should be shown
 if ($showreceivehtml) {
	 if ($loggedin) {
		 $query = "SELECT `receive_html` FROM `#__mamml_subscribers` WHERE `subscriber_id` = " . $my->id;
		 $database->setQuery($query);
		 $row = $database->loadRow();
		 $checked = $row[0];
	 } else {
		 $checked = $receivehtmldefault;
	 } // end if
?>
	<?php echo $tr . "\n";	?>
		<td>
			&nbsp;<input type="checkbox" class="inputbox" value="<?php echo $receivehtmldefault; ?>" name="receivehtml" <?php if ($checked != 0) { echo 'checked="checked"'; } ?> />
		</td>
		<td>
			<?php echo _MODRECEIVEHTML . "\n"; ?>
		</td>
	<?php echo $etr . "\n"; ?>
<?php
 } else {
	 echo '<input type="hidden" value="'.$receivehtmldefault.'" name="receivehtml" />';
 } // end if
 
 // get lists to show
 $lists = explode("|", $listids);
 // if more than one, show options
 if (count($lists) > 1) {
	 echo $tr . "<td colspan=\"2\">Newsletters:</td>" . $etr;
	 for ($i = 0, $n = count($lists); $i < $n; $i++) {
		 $query = "SELECT `list_name` FROM `#__mamml_letters` WHERE `id` = " . trim($lists[$i]);
		 $database->setQuery($query);
		 $listname = $database->loadRow();
		 if ($loggedin) {
			 $query = "SELECT `list_" . trim($lists[$i]) . "` FROM `#__mamml_subscribers` WHERE `subscriber_id` = " . $my->id;
			 $database->setQuery($query);
			 $row = $database->loadRow();
			 $checked = $row[0];
		 } else {
			 $checked = 0;
		 } // end if
?>
	<?php echo $tr . "\n"; ?>
		<td>
			&nbsp;<input type="checkbox" class="inputbox" value="1" name="<?php echo trim($lists[$i]) ?>" <?php if ($checked != 0) { echo 'checked="checked"'; } ?> />
		</td>
		<td>
			<?php echo $listname[0] . "\n"; ?>
		</td>
	<?php echo $etr . "\n"; ?>
<?php
	 } // end foreach
 } // end if
 // check if user is logged in or not
 if (!$loggedin) {
?>
	<?php echo $tr . "\n"; ?>
		<td colspan="2">
			<input type="button" value="<?php echo _MODSUBSCRIBE; ?>" class="button" onclick="submitmammlmod();" />
		</td>
	<?php echo $etr . "\n"; ?>
</table>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="action" value="unregistered" />
	<input type="hidden" name="type" value="unregistered" />
	<input type="hidden" name="task" value="addUnregistered" />
<?php
 } else {
	 $query = 'SELECT `name`, `email` FROM `#__users` WHERE `id` = ' . $my->id;
	 $database->setQuery($query);
	 $row = $database->loadRow();
?>
	<?php echo $tr . "\n"; ?>
		<td colspan="2">
			<input type="submit" value="<?php echo _CHANGESUBSCRIPTIONS; ?>" class="button" />
		</td>
	<?php echo $etr . "\n"; ?>
</table>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="action" value="registered" />
	<input type="hidden" name="type" value="registered" />
	<input type="hidden" name="task" value="updateSubscriptions" />
	<input type="hidden" name="userid" value="<?php echo $my->id; ?>" />
	<input type="hidden" name="name" value="<?php echo $row[0]; ?>" />
	<input type="hidden" name="email" value="<?php echo $row[1]; ?>" />
<?php	
 } // end if
 // check if there is only one list
 if (count($lists) == 1) {
?>
	<input type="hidden" value="<?php echo trim($lists[0]); ?>" name="<?php echo trim($lists[0]); ?>" />
<?php
 } // end if
?>
</form>