<?php
/**
 * admin.mamml.html.php
 * 
 * <p>Includes {@link backend_html} class.</p>
 * 
 * @package MaMML
 * @subpackage backend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.5.0
 * @since 0.4.3
 * @link http://www.schmalls.com
 */
 
 /**
  *  Ensures this file is being included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
 
 /**
  * Class to display html output for backend
  * 
  * <p>Includes a lot of functions used by {@link admin.mamml.php} to output 
  * information.</p>
  * 
  * @package MaMML
  * @subpackage backend
  * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
  * @version 0.5.0
  * @since 0.4.3
  */
 class backend_html {
	 
	 /**
	  * Shows the subscribers
	  * 
	  * <p>Creates a list of subscribers and their options and 
	  * subscriptions which can be updated. There is also a filter box, 
	  * which allows the subscribers to be narrowed. Also there are options 
	  * to move between different pages of users, and change the amount of 
	  * subscribers on each page.</p>
	  * 
	  * @version 0.5.0
	  * @since 0.4.3
	  * @param array $subscribers the subscribers to display
	  * @param array $letters the newsletter information
	  * @param string $action the action to be passed on
	  * @param int $listid the list to work on
	  * @param int $start the subscriber to start on
	  * @param int $limit the total number of subscribers to show
	  * @param int $total the total number of subscribers
	  * @param string $emailsearch the email search filter
	  */
	 function showSubscribers($subscribers, $letters, $action, $listid, $start, $limit, $total, $showAdmin, $theLetterId, $emailsearch) {
?>
<script type="text/javascript">
	function checkcid(myField) {
		myField.checked = true;
		isChecked(true);
	}
</script>
<form action="index2.php" method="post" name="mammlFilterForm">
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="<?php echo $action; ?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" />
<p style="text-align: right;"><?php echo _FILTER; ?>:<input type="text" name="emailsearch" value="<?php echo $emailsearch; ?>" class="inputbox" onChange="document.mammlFilterForm.submit();" /></p>
</form>
<form action="index2.php" method="post" name="adminForm">
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="<?php echo $action; ?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" />
	<input type="hidden" name="start" value="<?php echo $start; ?>" />
	<input type="hidden" name="limit" value="<?php echo $limit; ?>" />
	<input type="hidden" name="emailsearch" value="<?php echo $emailsearch;?>" />
	<input type="hidden" name="boxchecked" value="0" />
<table width="100%"  border="0" cellspacing="0" cellpadding="4" class="adminlist">
	<tr>
		<th class="title">&nbsp;</th>
		<th class="title"><?php echo _INPUT_NAME; ?></th>
		<th class="title"><?php echo _INPUT_EMAIL; ?></th>
		<th class="title"><?php echo _SIGNUPDATE; ?></th>
		<th class="title"><?php echo _CONFIRMED; ?>?</th>
		<th class="title"><?php echo _SUBHTML; ?>?</th>
<?php
	  	foreach ($letters as $letter) {
			if ((($showAdmin) && ($letter->id == $theLetterId)) || (!$showAdmin)) {
?>
		<th class="title"><a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;listid=<?php echo $letter->id; ?>"><?php echo $letter->list_name; ?></a></th>
<?php
			} // end if 
		} // end foreach
?>
	</tr>
	<tr class="row0">
		<td colspan="6">&nbsp;</td>
<?php
	  	foreach ($letters as $letter) {
			if ((($showAdmin) && ($letter->id == $theLetterId)) || (!$showAdmin)) {
?>
		<td>
			<a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;task=subscribeAll&amp;listid=<?php echo $letter->id; ?>"><img src="images/tick.png" width="12" height="12" border="0" alt="Subscribe all" /></a>
			<a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;task=unsubscribeAll&amp;listid=<?php echo $letter->id; ?>"><img src="images/publish_x.png" width="12" height="12" border="0" alt="Unsubscribe all" /></a>
		</td>
<?php
			} // end if
		} // end foreach
?>
	</tr>
<?php
		$i = 0;
		if (!empty($subscribers[0])) {
			foreach ($subscribers as $subscriber) {
?>  
	<tr class="row<?php echo ($i + 1) % 2;?>">
		<td>
			<input type="checkbox" name="cid[<?php echo $subscriber['id']; ?>]" value="<?php echo $subscriber['id']; ?>" onclick="isChecked(this.checked);" />
		</td>
		<td><?php echo $subscriber['name']; ?></td>
		<td><?php echo $subscriber['email']; ?></td>
		<td><?php echo $subscriber['subscribe_date']; ?></td>
		<td>
			<input type="checkbox" name="<?php echo $subscriber['id']; ?>[confirmed]" value="1" <?php if ( $subscriber['confirmed'] == 1 ) { echo 'checked="checked"'; } ?> onClick="checkcid(document.adminForm.elements['cid[<?php echo $subscriber['id']; ?>]'])" />
		</td>
		<td>
			<input type="checkbox" name="<?php echo $subscriber['id']; ?>[receive_html]" value="1" <?php if ( $subscriber['receive_html'] == 1 ) { echo 'checked="checked"'; } ?> onClick="checkcid(document.adminForm.elements['cid[<?php echo $subscriber['id']; ?>]'])" />		
		</td>
<?php
				foreach ($letters as $letter) {
					$letterid = $letter->id;
					// check whether to show admin option box
					if ($showAdmin && ($theLetterId == $letterid)) {
?>
		<td>
			<select size="1" name="<?php echo $subscriber['id']; ?>[<?php echo $letter->id; ?>]" onClick="checkcid(document.adminForm.elements['cid[<?php echo $subscriber['id']; ?>]'])" >
				<option value="0" <?php if ( $subscriber['list_' . $letterid] == 0 ) { echo 'selected="selected"'; } ?> ></option>
				<option value="1" <?php if ( $subscriber['list_' . $letterid] == 1 ) { echo 'selected="selected"'; } ?> >Subscriber</option>
				<option value="2" <?php if ( $subscriber['list_' . $letterid] == 2 ) { echo 'selected="selected"'; } ?> >Publisher</option>
				<option value="3" <?php if ( $subscriber['list_' . $letterid] == 3 ) { echo 'selected="selected"'; } ?> >Admin</option>
			</select>
		</td>
<?php
					} else if ($showAdmin) {
?>
		<input type="hidden" name="<?php echo $subscriber['id']; ?>[<?php echo $letter->id; ?>]" value="<?php echo $subscriber['list_' . $letterid]; ?>" />
<?php
					} else {
?>
		<td>
<?php
						if ($subscriber['list_' . $letterid] == 2 || $subscriber['list_' . $letterid] == 3) {
?>
			<input type="hidden" name="<?php echo $subscriber['id']; ?>[<?php echo $letter->id; ?>]" value="<?php echo $subscriber['list_' . $letterid]; ?>" /> 
<?php
						} // end if
?>
			<input type="checkbox" name="<?php echo $subscriber['id']; ?>[<?php echo $letter->id; ?>]" value="1" <?php if ( $subscriber['list_' . $letterid] != 0 ) { echo 'checked="checked"'; } ?> <?php if ( $subscriber['list_' . $letterid] == 2 || $subscriber['list_' . $letterid] == 3) { echo 'disabled="disabled"'; } ?> onClick="checkcid(document.adminForm.elements['cid[<?php echo $subscriber['id']; ?>]'])" />
		</td>
<?php 
					} // end if
				} // end foreach
				$i++;
			} // end foreach
		} // end if
?>	
	</tr>
</table>
</form>
<table width="100%"  border="0" cellspacing="0" cellpadding="4" class="adminlist">
	<tr>
		<th colspan="<?php echo count($letters) + 6;?>" align="center">
			<a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;start=0&amp;limit=<?php echo $limit;?>" class="pageNav"><< </a>&nbsp;
<?php
		if (($limit * 5) < $start) {
			$i = $start - 50;
		} else {
			$i = 0;
		} // end if
		$last = 10 + (intval($i / $limit) + 1);
		for ($j = (intval($i / $limit) + 1); $i < $total && $j <= $last; $i += $limit, $j++) {
			if($i == $start) {
				echo $j . '&nbsp;';
			} else {
?>  			
			<a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;start=<?php echo $i; ?>&amp;limit=<?php echo $limit;?>" class="pageNav"><?php echo $j;?></a>&nbsp;
<?php
			} // end if
		} // end for
		if (($total - $limit) < 0) {
			$laststart = 0;
		} else {
			$laststart = $total - $limit;
		} // end if
?>
			<a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;start=<?php echo $laststart;?>&amp;limit=<?php echo $limit;?>" class="pageNav"> >></a>&nbsp;
		</th>
	</tr>
	<tr>
		<td colspan="<?php echo count($letters) + 6;?>" align="center">
			<form action="index2.php" method="post" name="selectForm">
				<select name="limit" class="inputbox" size="1" onchange="document.selectForm.submit();">
<?php
		for($i = 10; $i <= 50; $i += 10) {
?>
					<option value="<?php echo $i;?>" <?php if($i == $limit) { echo "selected=\"selected\""; } ?>><?php echo $i;?></option>
<?php
		} // end for
?>
				</select>
				<input type="hidden" name="option" value="com_mamml" />
				<input type="hidden" name="act" value="<?php echo $action; ?>" />
				<input type="hidden" name="task" value="" />
				<input type="hidden" name="listid" value="<?php echo $listid; ?>" />
				<input type="hidden" name="start" value="<?php echo $start; ?>" />
			</form>
			&nbsp;
<?php 
		if (($start + $limit) > $total) {
			$through = $total;
		} else {
			$through = $start + $limit;
		} // end if
		echo _RESULTS . ' ' . ($start + 1) . ' - ' . ($through) . ' of ' . $total; ?>
		</td>
	</tr>
</table>
<?php
	 } // end function
	 
	 /**
	  * Displays a new subscriber form
	  * 
	  * <p>Creates a form to accept a new unregistered subscriber's 
	  * information. Javascript makes sure a name and email address are 
	  * entered.</p>
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  * @param string $action the action to be sent back
	  * @param array $letters the newlsetters to display
	  */
	 function newSubscriber($action, $letters) {	 
?>
<script language="javascript" type="text/javascript">
	function submitbutton() {
		var form = document.adminForm;
				
		// do field validation
		if (form.name.value == "") {
			alert( "<?php echo _REGWARN_NAME;?>" );
		} else if (form.email.value == "") {
			alert( "<?php echo _REGWARN_MAIL;?>" );
		} else {
			form.submit();
		}
	}
</script>
<form action="index2.php" method="post" name="adminForm">
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="<?php echo $action; ?>" />
	<input type="hidden" name="task" value="doNew" />
<table cellpadding="0" cellspacing="0" align="center" class="adminform">
	<tr>
		<th colspan="3"><?php echo _INPUT_DETAILS; ?></th>
	</tr>
	<tr>
		<td width="100"><?php echo _INPUT_NAME; ?></td>
		<td colspan="2"><input type="text" name="name" size="40" value="" class="inputbox" /></td>
	</tr>
	<tr>
		<td width="100"><?php echo _INPUT_EMAIL; ?></td>
		<td colspan="2"><input type="text" name="email" size="40" value="" class="inputbox" /></td>
	</tr> 
<?php
		foreach ($letters as $letter) {
?>
	<tr>
		<td align="left" width="100"><?php echo $letter->list_name; ?></td>
		<td width="100">
			<select size="1" name="<?php echo $letter->id; ?>" >
				<option value="0" ></option>
				<option value="1" >Subscriber</option>
				<option value="2" >Publisher</option>
				<option value="3" >Admin</option>
			</select>
		</td>
		<td align="right"><a href="index2.php?option=com_mamml&amp;action=newsletter&amp;task=viewarchive&amp;listid=<?php echo $letter->id; ?>"><?php echo _VIEWARCHIVE; ?></a></td>
	</tr>
<?php	
	 	} // end foreach
?>
	<tr> 
		<td width="100"><?php echo _RECEIVE_HTML; ?></td>
		<td><input type="checkbox" name="receivehtml" value="1" class="inputbox" /></td> 
		<td></td>
	</tr>
	<tr> 
		<td width="100"><?php echo _CONFIRMED; ?></td>
		<td><input type="checkbox" name="confirmed" value="1" class="inputbox" /></td> 
		<td></td>
	</tr>  
</table> 
</form>

<?php
	 } // end function
	 
	 /**
	  * Displays the export options
	  * 
	  * <p>Creates a form button to output the csv export file.</p>
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  * @param string $action the action to pass on
	  * @param int $listid the list to work on
	  */
	 function export($action, $listid) {
?>
<form action="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;listid=<?php echo $listid; ?>" method="post" name="adminForm" >
	<input type="hidden" name="task" value="" />
	<br /><br />
	<input type="button" value="Export" class="button" onclick="submitbutton('doExport')" /> 
</form>
<?php
	 } // end function
	 
	 /**
	  * Displays the import options
	  * 
	  * <p>Creates a form to input the import file location and submit 
	  * it.</p>
	  * 
	  * @version 0.4.11
	  * @since 0.4.3
	  * @param string $action the action to pass on
	  * @param int $listid the list to work on
	  */
	 function import($action, $listid) {
?>
<script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
		var form = document.adminForm;
				
		// do field validation
		if (form.importfile.value == "") {
			alert( "Please select a file to import." );
		} else {
			submitform(pressbutton);
		}
	}
</script>
<form action="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;listid=<?php echo $listid; ?>" method="post" name="adminForm" enctype="multipart/form-data" >
	<input type="hidden" name="task" value="" />
<table cellpadding="0" cellspacing="0" align="center" class="adminform">
	<tr>
		<th><?php echo _SELECTIMPORTFILE; ?></th>
	</tr>
	<tr>
		<td>
			<input type="file" name="importfile" class="inputbox" />
		</td>
	</tr>
	<tr>
		<td>	
			<input type="button" value="Import" class="button" onclick="submitbutton('doImport')" /> 
		</td>
	</tr>
</table>
</form>
<?php
	 } // end function
	 
	 /**
	  * Displays an options screen for the backend
	  * 
	  * <p>The default view for the backend, which displays a list of 
	  * images with links to the different admin options.</p>
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function showMain() {
?>
<table>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=newsletter"><img src="components/com_mamml/images/newsletter.png" alt="Newsletter Management" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=registered"><img src="components/com_mamml/images/registered.png" alt="Registered Subscribers" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=unregistered"><img src="components/com_mamml/images/unregistered.png" alt="Unregistered Subscribers" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=mailing"><img src="components/com_mamml/images/mailing.png" alt="Mailing Management" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=statistics"><img src="components/com_mamml/images/statistics.png" alt="Statistics" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=configuration"><img src="components/com_mamml/images/configuration.png" alt="Configuration" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td align="left">
			<a href="index2.php?option=com_mamml&amp;act=update"><img src="components/com_mamml/images/update.png" alt="Update" border="0" align="left" /></a>
		</td>
	</tr>
	<tr>
		<td>
			<a href="http://mamml.schmalls.com" target="_blank"><img src="components/com_mamml/images/documentation.png" alt="Online Documentation" border="0" align="left" /></a>
		</td>
	</tr>
</table>
<?php
	 } // end function
	 
	 /**
	  * Shows the newsletters
	  * 
	  * <p>Creates a list of the newsletters with radio buttons to select 
	  * one of them.</p>
	  * 
	  * @version 0.4.11
	  * @since 0.4.3
	  * @param array $letters the newsletter information
	  */
	 function showLetters($letters, $action) {
?>
<form action="index2.php" method="post" name="adminForm">
<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th width="2%" class="title">#</td>
		<th width="3%" class="title">
		</th>
		<th width="40%" class="title"><?php echo _LISTNAME; ?></th>
		<th width="45%" class="title"><?php echo _LISTSENDER; ?></th>
    </tr>
<?php
		// go through each letter
		$i = 0;
		foreach ($letters as $letter) {
			$i++;
?>
	<tr class="row<?php echo ($i % 2); ?>">
		<td><?php echo $i; ?></td>
		<td><input type="radio" name="listid" value="<?php echo $letter->id; ?>" onClick="isChecked(this.checked);" /></td>
		<td>
			<a href="index2.php?option=com_mamml&amp;act=<?php echo $action; ?>&amp;task=edit&amp;listid=<?php echo $letter->id; ?>" ><?php echo $letter->list_name; ?></a>
		</td>
		<td><?php echo $letter->sendername; ?></td>
	</tr>
<?php
		} // end foreach
?>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="act" value="<?php echo $action; ?>" />
	<input type="hidden" name="boxchecked" value="0" />
</table>
</form>
<?php
	 } // end function
	 
	 /**
	  * Shows newsletter editing area
	  * 
	  * <p>Creates a form to create or edit a mailing. If it is an html 
	  * letter, then the configured wysiwyg editor will be used for html 
	  * fields. If we are editing, the fields will be filled with the 
	  * current values.</p>
	  * 
	  * @version 0.4.5
	  * @since 0.4.3
	  * @param array $letter the letter options
	  */
	 function showLetterEdit($letter) {
		 
		 // check whether this is a new newsletter
		 if ($letter->id != 0) {
			 $display = _CHANGE;
		 } else {
			 $display = _ENTER;
		 } // end if
		 // check whether it is html
		 if ($letter->html != 0) {
			 $html = true;
		 } else {
			 $html = false;
		 } // end if
?>
<script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		}

<?php
		getEditorContents( 'editor1', 'list_desc') ;
		if($html){
			getEditorContents( 'editor2', 'layout') ;
			getEditorContents( 'editor3', 'subscribemessage') ;
			getEditorContents( 'editor4', 'unsubscribemessage');
		} // end if

?>
		submitform( pressbutton );
	}
</script>
<form action="index2.php" method="post" name="adminForm">
<span class="sectionname"><?php echo $display . ' ' . _LISTVALUESBELOW; ?></span><br /><br />
<table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminform">
	<tr>
		<td width="100"><strong><?php echo _LISTNAME; ?>:</strong></td>
		<td width="85%"><input type="text" name="list_name" class="inputbox" size="40" maxlength="32" value="<?php echo $letter->list_name; ?>" /></td>
	</tr>
	<tr>
		<td><strong><?php echo _LISTDESC; ?>:</strong></td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
<?php
		editorArea( 'editor1',  $letter->list_desc , 'list_desc', 500, 150, '70', '10' ) ;
?>
		</td>
	</tr>
	<tr>
		<td><strong><?php echo _SENDERNAME; ?>:</strong></td>
		<td><input type="text" name="sendername" class="inputbox" size="40" maxlength="32" value="<?php echo $letter->sendername; ?>" /></td>
	</tr>
	<tr>
		<td><strong><?php echo _SENDEREMAIL; ?>:</strong></td>
		<td><input type="text" name="senderemail" class="inputbox" size="40" maxlength="64" value="<?php echo $letter->senderemail; ?>" /></td>
	</tr>
	<tr>
		<td><strong><?php echo _SENDERBOUNCE; ?>:</strong></td>
		<td><input type="text" name="bounceadres" class="inputbox" size="40" maxlength="64" value="<?php echo $letter->bounceadres; ?>" /></td>
	</tr>
	<tr>
		<td><strong><?php echo _LAYOUT; ?>:</strong></td>
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br />
			<?php echo _CONTENTREP; ?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
<?php
		 if ($html) {
			 editorArea( 'editor2',  $letter->layout , 'layout', 500, 200, '70', '20' ) ;
		 } else {
			 echo '<textarea name="layout" rows="20" cols="70">' . $letter->layout . '</textarea>';
		 } // end if
?>
		</td>
	</tr>
	<tr>
		<td valign="top"><strong><?php echo _SUBMESSAGE; ?></strong></td>
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br />
				<?php echo _NAMEANDCONFIRM; ?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
<?php
		if($html){
			editorArea( 'editor3',  $letter->subscribemessage , 'subscribemessage', 500, 200, '70', '20' ) ;
		} else {
			echo '<textarea name="subscribemessage" rows="20" cols="70">' . $letter->subscribemessage . '</textarea>';
		} // end if
?>
		</td>
	</tr>
	<tr>
		<td><strong><?php echo _UNSUBMESSAGE; ?></strong></td>
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br />
			<?php echo _NAMEREP; ?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
<?php
		if($html){
			editorArea( 'editor4',  $letter->unsubscribemessage , 'unsubscribemessage', 500, 200, '70', '20' ) ;
		} else {
			echo '<textarea name="unsubscribemessage" rows="20" cols="70">' . $letter->unsubscribemessage . '</textarea>';
		} // end if
?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
			<?php echo _HTMLMAILING; ?>:<br />
			<input type="checkbox" name="html" value="1" class="inputbox" <?php if ($letter->html) { echo 'checked="checked"'; } ?> />
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
			<?php echo _HIDEFROMFRONTEND; ?>:<br />
			<input type="checkbox" name="hidden" value="1" class="inputbox" <?php if ($letter->hidden != 0 ) { echo 'checked="checked"'; } ?> />
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
			<?php echo _AUTO_ADD_NEW_USERS; ?><br />
			<input type="checkbox" name="auto_add" value="1" class="inputbox" <?php if ($letter->auto_add != 0 ) { echo 'checked="checked"'; } ?> />
		</td>			
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
</table>
	<input type="hidden" name="listid" value="<?php echo $letter->id; ?>" />
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="newsletter" />
	<input type="hidden" name="task" value="" />
	<!--<input type="hidden" name="new_letter" value="<?php echo $letter->new_letter; ?>" />-->
</form>
<?php		 
	 } // end fucntion
	 
	 /**
	  * Show mailing editing area
	  * 
	  * <p>Creates a form to create or edit a mailing. If it is an html 
	  * mailing, then the configured wysiwyg editor will be used for html 
	  * fields. If we are editing, the fields are filled with their current 
	  * values.</p>
	  * 
	  * @version 0.4.12
	  * @since 0.4.3
	  * @param Object $letter the mailing information
	  * @param Object $layout the layout and html information
	  * @param int $new tells whether this is a new mailing or not
	  * @param array $contentitems array of content item objects
	  * @param string $action the action that is being performed
	  * @param int $listid the list's id
	  * @global string the filesystem path to the mambo root directory
	  */
	 function showMailingEdit($letter, $layout, $new, $contentitems, $action, $listid) {
		 global $mosConfig_absolute_path;
?>
<script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		} // end if
<?php 
		 if($layout->html != 0){
			 getEditorContents( 'editor1', 'content');
		 } // end if
?>
		submitform( pressbutton );
	} // end function
</script>

<form action="index2.php" method="post" name="adminForm">
<span class="sectionname"><?php echo _CREATEMAILINGBELOW; ?>:</span><br /><br />
<table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminform">
	<tr>
		<td width="100">
			<strong><?php echo _SUBJECT; ?>:</strong><br />
		</td>
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br />
			<?php echo _NAMEREP; ?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td width="85%"><input type="text" name="subject" class="inputbox" size="40" value="<?php echo $letter->list_subject; ?>" /></td>
	</tr>
	<tr> 
		<td width="100"><strong><?php echo _SENDERNAME . ' ' . _LEAVEBLANKFORDEF; ?>:</strong></td> 
		<td width="85%"><input type="text" name="fromname" class="inputbox" size="40" value="" /></td> 
    </tr> 
	<tr> 
		<td width="100"><strong><?php echo _SENDEREMAIL . " " . _LEAVEBLANKFORDEF; ?>:</strong></td> 
		<td width="85%"><input type="text" name="fromemail" class="inputbox" size="40" value="" /></td> 
	</tr> 
	<tr> 
		<td width="100"><strong><?php echo _SENDERBOUNCE . " " . _LEAVEBLANKFORDEF; ?>:</strong></td> 
		<td width="85%"><input type="text" name="return" class="inputbox" size="40" value="" /></td> 
	</tr> 
	<tr>
		<td valign="top"><strong><?php echo _CONTENT; ?>:</strong></td>
		<td><strong><?php echo _USABLETAGS; ?></strong><br />
		<?php echo _NAMEREP; ?>
	</tr>
	<tr>	
		<td>&nbsp;</td>
		<td>
<?php
		 $content = preg_replace('/<br \/>\{contentitem:(.{1,5})\|(.{1})}/','', $letter->list_content);
		 $content = preg_replace('/\n\r\{contentitem:(.{1,5})\|(.{1})}/','', $content);
		 $alt_content = preg_replace('/\n\r\{contentitem:(.{1,5})\|(.{1})}/','', $letter->list_textonly);
		 // check if the html editing area should be shown or not
		 if($layout->html != 0){
			 editorArea( 'editor1',  $content , 'content', 750, 450, '100', '30' ); 
?>
	<tr>
		<td valign="top"><strong><?php echo _NONHTML; ?>:</strong></td>
		<td><strong><?php echo _USABLETAGS; ?></strong><br />
		<?php echo _NAMEREP; ?>
	</tr>
	<tr>	
		<td>&nbsp;</td>
		<td>
			<textarea name="alt_content" cols="90" rows="30"><?php echo $alt_content; ?></textarea>
<?php
		 } else{
?>
			<textarea name="content" cols="100" rows="30"><?php echo $content; ?></textarea>
<?php
		 } // end if
?>
		</td>
	</tr>
	<tr>
		<td><strong><?php echo _ATTACHMENTS; ?>:</strong></td>
		<td><?php echo _SELECTMULTIPLE; ?></td>
	</tr>
	<tr>	
		<td>&nbsp;</td>
		<td>
<?php
		 $files = mosReadDirectory($mosConfig_absolute_path . '/images/stories/', '\.', true, true);
?>
			<select name="attachments[]" multiple="multiple" style="width: 600px;" size="10">
<?php
		 if(sizeof($files) > 0) {
			 foreach ($files as $file) {
				 $file = str_replace($mosConfig_absolute_path . '/images/stories/', '', $file);
				 if(in_array($file, $letter->attachments)) {
					 echo '<option selected="selected">' . $file . '</option>' . "\n";
				 } else {
					 echo '<option>' . $file . '</option>' . "\n";
				 } // end if
			 } // end foreach				      
		 } // end if
?>
			</select>
		</td>
	</tr>
	<tr>
		<td><strong><?php echo _CONTENTITEM; ?>:</strong></td>
		<td>
			<?php echo _CONTENTITEMSELECT; ?><br />
			<?php echo _SELECTMULTIPLE; ?>
		</td>
	</tr>
	<tr> 
		<td>&nbsp;</td> 
		<td>
			<select name="contentitems[]" multiple="multiple" class="inputbox" style="width: 600px;" size="10"> 
<?php
		 if(sizeof($contentitems) > 0){
			 foreach ($contentitems AS $contentitem){
				 if((substr_count($letter->list_content, '{contentitem:' . $contentitem->id . '|0}') != 0) || (substr_count($letter->list_content, "{contentitem:" . $contentitem->id . "|1}") != 0)){
					 echo '<option selected value=' . $contentitem->id . '>' . $contentitem->section . '/' . $contentitem->category . '/'. $contentitem->title . '</option>' . "\n";
				 } else {
					 echo '<option value=' . $contentitem->id . '>' . $contentitem->section . '/' . $contentitem->category . '/'. $contentitem->title . '</option>' . "\n";
				 } // end if
			 } // end foreach
		 } // end if
?> 
			</select>
		</td> 
	</tr> 
	<tr>
		<td><?php echo _INTROONLY; ?></td>
		<td>
			<input type="checkbox" value="1" name="introonly" />
		</td>
	</tr>
</table>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="new_list" value="<?php echo $new; ?>" />
	<input type="hidden" name="act" value="mailing" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" />
	<input type="hidden" name="html" value="<?php echo $layout->html; ?>" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="flush" value="1" />
</form>
<?php
	 } // end function
	
	/**
	 * Displays preview options
	 * 
	 * <p>Creates a form to enter receiver information for a preview 
	 * mailing.</p>
	 * 
	 * @version 0.4.9
	 * @since 0.4.3
	 * @param int $listid the list to work with
	 * @param string $fromname sender information to pass through
	 * @param string $fromemail sender information to pass through
	 * @param string $frombounce sender information to pass through
	 */
	function previewMailing($listid, $fromname, $fromemail, $frombounce){
?>
<script language="javascript" type="text/javascript">
<!--
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		} // end if
		submitform( pressbutton );
	} // end function
-->
</script> 
<span class="sectionname"><?php echo _WHICHEMAILTEST; ?>:</span><br /> 
<br /> 
<form action="index2.php" method="POST" name="adminForm"> 
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="mailing" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" /> 
	<input type="hidden" name="fromname" value="<?php echo $fromname; ?>" />
	<input type="hidden" name="fromemail" value="<?php echo $fromemail; ?>" />
	<input type="hidden" name="frombounce" value="<?php echo $frombounce; ?>" /> 
	<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="contentpane">
		<tr> 
			<td><?php echo _INPUT_NAME; ?></td> 
			<td><input type="text" name="name" class="inputbox" /></td> 
		</tr> 
		<tr> 
			<td><?php echo _INPUT_EMAIL; ?></td> 
			<td><input type="text" name="emailaddress" class="inputbox" /> 
		</tr> 
		<tr> 
			<td colspan="2"><?php echo _SENDINHTML; ?>
			<input type="checkbox" value="1" name="html" class="inputbox" /></td> 
    	</tr>
	</table> 
</form> 
<?php
	 } // end function
	 
	 /**
	  * Show the configuration editing area
	  * 
	  * <p>Creates a form ti input change the configuration options.</p>
	  * 
	  * @version 0.4.5
	  * @since 0.4.3
	  * @param array $newsletterConfig the configuration options
	  */
	 function showConfigurationEdit($newsletterConfig) {
?>
<script language="javascript" type="text/javascript">
<!--
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		} // end if
		submitform( pressbutton );
	} // end function
-->
</script> 
<form action="index2.php" method="post" name="adminForm">
<table cellpadding="2" cellspacing="4" border="0" width="100%" class="adminform">
	<tr>
		<td width="185"><?php echo _MAILSENDMETHOD; ?></td>
		<td width="350">
			<select name="config['emailmethod']" class="inputbox" size="1">
				<option value="mail" <?php if($newsletterConfig['emailmethod'] == 'mail') { echo 'selected="selected"'; } ?>>mail</option>
				<option value="sendmail" <?php if($newsletterConfig['emailmethod'] == 'sendmail') { echo 'selected="selected"'; } ?>>sendmail</option>
				<option value="smtp" <?php if($newsletterConfig['emailmethod'] == 'smtp') { echo 'selected="selected"'; } ?>>smtp</option>
			</select>
		</td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td><?php echo _SENDMAILPATH; ?></td>
		<td><input class="inputbox" type="text" name="config['sendmail_path']" size="50" value="<?php echo $newsletterConfig['sendmail_path']; ?>"></td>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td><?php echo _SMTPHOST; ?></td>
		<td><input class="inputbox" type="text" name="config['smtp_host']" size="50" value="<?php echo $newsletterConfig['smtp_host']; ?>"></td>
		<td><?php echo _SMTPHOST; ?> mail.site.com</td>
	</tr>
	<tr>
		<td><?php echo _SMTPAUTHREQUIRED; ?></td>
		<td>
			<select name="config['smtp_auth_required']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['smtp_auth_required'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['smtp_auth_required'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _SMTPAUTHREQUIRED_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _SMTPUSERNAME; ?></td>
		<td><input class="inputbox" type="text" name="config['smtp_username']" size="50" value="<?php echo $newsletterConfig['smtp_username']; ?>"></td>
		<td><?php echo _SMTPUSERNAME_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _SMTPPASSWORD; ?></td>
		<td><input class="inputbox" type="text" name="config['smtp_password']" size="50" value="<?php echo $newsletterConfig['smtp_password']; ?>"></td>
		<td><?php echo _SMTPPASSWORD_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td colspan="3"></td>
	</tr>
	<tr>
		<td><?php echo _ENABLEREADSTATS; ?></td>
		<td>
			<select name="config['enable_statistics']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['enable_statistics'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['enable_statistics'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _ENABLEREADSTATS_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _LOGVIEWSPERSUB; ?></td>
		<td>
			<select name="config['statistics_per_subscriber']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['statistics_per_subscriber'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['statistics_per_subscriber'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _LOGVIEWSPERSUB_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _PAUSEX; ?></td>
		<td><input class="inputbox" type="text" name="config['pause_time']" size="50" value="<?php echo $newsletterConfig['pause_time']; ?>"> </td>
		<td><?php echo _PAUSEX_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _EMAILS_BETWEEN_PAUSES; ?></td>
		<td><input class="inputbox" type="text" name="config['emails_between_pauses']" size="50" value="<?php echo $newsletterConfig['emails_between_pauses']; ?>"> </td>
		<td><?php echo _EMAILS_BETWEEN_PAUSES_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _WAIT_FOR_USER_AT_PAUSE; ?></td>
		<td>
			<select name="config['wait_for_user_at_pause']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['wait_for_user_at_pause'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['wait_for_user_at_pause'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _WAIT_FOR_USER_AT_PAUSE_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _SCRIPT_TIMEOUT; ?></td>
		<td><input class="inputbox" type="text" name="config['script_timeout']" size="50" value="<?php echo $newsletterConfig['script_timeout']; ?>"> </td>
		<td><?php echo _SCRIPT_TIMEOUT_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _SENDPERFDATA; ?></td>
		<td>
			<select name="config['send_data']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['send_data'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['send_data'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _SENDPERFDATA_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _ALLOWUNREG; ?></td>
		<td>
			<select name="config['allow_unregistered']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['allow_unregistered'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['allow_unregistered'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _ALLOWUNREG_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _REQCONFIRM; ?></td>
		<td>
			<select name="config['require_confirmation']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['require_confirmation'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['require_confirmation'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _REQCONFIRM_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td valign="top"><strong><?php echo _SUBMESSAGE; ?></strong></td>
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br />
			<?php echo _NAMEANDCONFIRM; ?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
			<textarea name="config['confirm_text']" rows="20" cols="70"><?php echo $newsletterConfig['confirm_text']; ?></textarea>
		</td>
	</tr>
	<tr>
		<td><?php echo _CONFIRMFROMNAME; ?></td>
		<td><input class="inputbox" type="text" name="config['confirm_fromname']" size="50" value="<?php echo $newsletterConfig['confirm_fromname']; ?>"></td>
		<td><?php echo _CONFIRMFROMNAME_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _CONFIRMFROMEMAIL; ?></td>
		<td><input class="inputbox" type="text" name="config['confirm_fromemail']" size="50" value="<?php echo $newsletterConfig['confirm_fromemail']; ?>"></td>
		<td><?php echo _CONFIRMFROMEMAIL_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _CONFIRMBOUNCE; ?></td>
		<td><input class="inputbox" type="text" name="config['confirm_return']" size="50" value="<?php echo $newsletterConfig['confirm_return']; ?>"></td>
		<td><?php echo _CONFIRMBOUNCE_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _HTMLCONFIRM; ?></td>
		<td>
			<select name="config['confirm_html']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['confirm_html'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['confirm_html'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _HTMLCONFIRM_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _USEEMBEDDED; ?></td>
		<td>
			<select name="config['use_embedded_images']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['use_embedded_images'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['use_embedded_images'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _USEEMBEDDED_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _SHOWFOOTER; ?></td>
		<td>
			<select name="config['show_footer']" class="inputbox" size="1">
				<option value="0" <?php if($newsletterConfig['show_footer'] == 0) { echo 'selected="selected"'; } ?>>No</option>
				<option value="1" <?php if($newsletterConfig['show_footer'] == 1) { echo 'selected="selected"'; } ?>>Yes</option>
			</select>
		</td>
		<td><?php echo _SHOWFOOTER_EXAMPLE; ?></td>
	</tr>
	<tr>
		<td><?php echo _UPDATE_URL; ?></td>
		<td><input class="inputbox" type="text" name="config['update_url']" size="50" value="<?php echo $newsletterConfig['update_url']; ?>"></td>
		<td><?php echo _UPDATE_URL_EXAMPLE; ?></td>
	</tr>
</table>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="configuration" />
	<input type="hidden" name="task" value="" />
</form>
<?php
	 } // end function
	 
	 /**
	  * Show the statistics
	  * 
	  * <p>Creates two tabs: one with overall statistics, and the other 
	  * with detailed statistics. They can be switched back and forth.</p>
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  * @param object $letter the letter details
	  * @param object $mailing the mailing details
	  * @param object $globalStats the global statistics for the mailing
	  * @param array $html_read the mailings that are html and have been read
	  * @param array $html_unread the mailings that are html and have not been read
	  * @param array $text the mailings that are text
	  * @param int $listid the list's id
	  */
	 function showStatistics($letter, $mailing, $globalStats, $html_read, $html_unread, $text, $listid) {
		 
?>
<script type="text/javascript" src="js/dhtml.js"></script>
<form action="index2.php" method="post" name="adminForm">
<table width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="adminlist">
	<tr>
		<td class="tabpadding">&nbsp;</td>
		<td id="tab1" class="offtab" onclick="dhtml.cycleTab(this.id);document.adminForm.tab.value=this.id" nowrap="nowrap"><?php echo _GLOBALSTATS;?></td>
		<td id="tab2" class="offtab" onclick="dhtml.cycleTab(this.id);document.adminForm.tab.value=this.id" nowrap="nowrap"><?php echo _DETAILEDSTATS; ?></td>
		<td width="90%" class="tabpadding">&nbsp;</td>
	</tr>
</table>
<table width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="adminlist">
	<tr>
		<th colspan="2" class="title"><?php echo _MAILINGLISTDETAILS; ?>:</th>
	</tr>
	<tr>
		<td width="200"><?php echo _MAILINGNAME; ?>:</td>
		<td><?php echo $letter->list_name; ?></td>
	</tr>
	<tr>
		<td width="200"><?php echo _DESCRIPTION; ?>:</td>
		<td><?php echo $letter->list_desc; ?></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td width="200"><?php echo _SENDON; ?>:</td>
		<td><?php echo $mailing->send_date; ?></td>
	</tr>
	<tr>
		<td width="200"><?php echo _SUBJECT; ?>:</td>
		<td><?php echo $mailing->list_subject;?></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
</table>
<div id="page1" class="pagetext">
	<table width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="adminlist">
<?php
		 // check if list was sent in html format
		 if($letter->html == 1) {
			 // if so, show html stats
?>
		<tr>
			<td width="200"><?php echo _SENDINHTMLFORMAT; ?>:</td>
			<td><?php echo $globalStats->html_sent; ?></td>
		</tr>
		<tr>
			<td width="200"><?php echo _VIEWSFROMHTML; ?>:</td>
			<td><?php echo $globalStats->html_read; ?></td>
		</tr>
<?php
		 } // end if
?>
		<tr>
			<td width="200"><?php echo _SENDINTEXTFORMAT; ?>:</td>
			<td><?php echo $globalStats->text_sent; ?></td>
		</tr>
	</table>
</div>
<div id="page2" class="pagetext">
	<table width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="adminlist">
		<tr>
			<td width="200">&nbsp;</td>
			<td valign="top">
				<table width="100%" cellpadding="4" cellspacing="0" border="1" align="center" class="adminlist">
					<tr>
						<td><?php echo _HTMLREAD; ?></td>
						<td><?php echo _HTMLUNREAD; ?></td>
						<td><?php echo _TEXTONLYSENT; ?></td>
					</tr>
					<tr>
						<td valign="top" width="33%">
<?php
		 // check if there are any read html mailings
		 if (sizeof($html_read) > 0) {
			 // if so, show them
			 foreach ($html_read as $htmlread){
				 echo $htmlread->name . ' (' . $htmlread->email . ')<br />';
			 } // end foreach
		 } // end if
?>
						</td>
						<td valign="top" width="33%">
<?php
		 // check if there are any unread html mailings
		 if (sizeof($html_unread) > 0) {
			 // if so, show them
			 foreach ($html_unread as $htmlunread){
				 echo $htmlunread->name . ' (' . $htmlunread->email . ')<br />';
			 } // end foreach
		 } // end if
?>
						</td>
						<td valign="top" width="33%">
<?php
		 // check if there are any text mailings
		 if (sizeof($text) > 0) {
			 // if so, show them
			 foreach ($text as $atext){
				 echo $atext->name . ' (' . $atext->email . ')<br />';
			 } // end foreach
		 } // end if
?>
					</tr>
				</table>
			</td>
		</tr>		
	</table>
</div>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="act" value="statistics" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" />
	<input type="hidden" name="senddate" value="<?php echo $mailing->send_date; ?>" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="tab" value="<?php echo $tab; ?>" />
</form>
<script language="javascript" type="text/javascript">
	dhtml.cycleTab('tab1');
</script>
<?php
	 } // end function
	 
	 /**
	  * Show a list of mailings for the newsletter
	  * 
	  * <p>Creates a list of mailings for a newsletter with radio buttons 
	  * so that one can be selected.</p>
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  * @param array $mailings the mailings
	  * @param string $action the action to be performed
	  * @param int $listid the list's id
	  */
	 function showMailings($mailings, $action, $listid) {
		 
?>
<form action="index2.php" method="post" name="adminForm">
<table width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="adminlist">
	<tr>
		<th width="32" height="20" align="center" class="title">&nbsp;</th>
		<th width="25%" height="20" class="title"><?php echo _HEADER_NEWSLETTER_DATE; ?></th> 
		<th height="20" class="title"><?php echo _HEADER_NEWSLETTER_SUBJECT; ?></th> 
		<th height="20" class="title"><?php echo _VISIBLE; ?></th> 
	</tr>
<?php
		 // check if there are mailings
		 if (!empty($mailings)) {
			 // if so, show them
			 $i = 0;
			 foreach ($mailings as $mailing){
?>
	<tr>
		<td width="32" height="20" align="center">
			<input type="radio" id="cb<?php echo $i;?>" name="senddate" value="<?php echo $mailing->send_date; ?>" onClick="isChecked(this.checked);" />
		</td>
		<td width="25%" height="20"><?php echo $mailing->send_date; ?></td>
		<td height="20"><?php echo $mailing->list_subject; ?></td>
<?php 
				 // check if mailing has been hidden or not
				 if ($mailing->visible == 1) {
					 // if not, set the image to published
					 $img = 'publish_y.png';
				 } else {
					 // if so, set the image to not published
					 $img = 'publish_x.png';
				 } // end if
?>
		<td height="20"><img src="images/<?php echo $img; ?>" width="12" height="12" border="0" alt="" /></td>
	</tr>
<?php
				 $i++;
			 } // end foreach
		 } // end if
?>
</table>
	<input type="hidden" name="option" value="com_mamml" />
    <input type="hidden" name="act" value="<?php echo $action; ?>" />
    <input type="hidden" name="listid" value="<?php echo $listid; ?>" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    </form>
<?php
	 } // end function
	 
	 /**
	  * View a message from the archive
	  * 
	  * <p>Displays a message's subject, senddate, html content, and text 
	  * content.</p>
	  * 
	  * @version 0.4.9
	  * @since 0.4.3
	  * @param object $mailing the mailing to show
	  */
	 function viewArchive($mailing) {
		 
?>
<form action="index2.php" method="post" name="adminForm">
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="mailing" />
	<input type="hidden" name="task" value="viewarchive" />
	<input type="hidden" name="listid" value="<?php echo $mailing->list_id; ?>" />
</form>
<table width="100%" cellpadding="4" cellspacing="0" border="0" align="left" class="adminlist">
	<tr>
		<th width="100%" align="left">
			<strong><?php echo _SUBJECT; ?>:</strong>
		</th>
	</tr>
	<tr>
		<td width="100%" align="left">
			<?php echo $mailing->list_subject; ?>
		</td>
	</tr>
	<tr>
		<th width="100%" align="left">
			<strong><?php echo _HEADER_NEWSLETTER_DATE; ?>:</strong>
		</th>
	</tr>
	<tr>			  
		<td width="100%" align="left">
			<?php echo $mailing->send_date; ?>
		</td>
	</tr>
	<tr>
		<th width="100%" align="left">
			<strong><?php echo _CONTENT; ?>:</strong>
		</th>
	</tr>
	<tr>
		<td width="100%" align="left">
			<?php echo $mailing->list_content; ?>
		</td>
	</tr>
	<tr>
		<th width="100%" align="left">
			<strong><?php echo _TEXTONLYSENT; ?>:</strong>
		<th>
	</tr>
	<tr>
		<td width="100%" align="left">
			<?php echo nl2br($mailing->list_textonly); ?>
		</td>
	</tr> 
</table>
<?php
	 } // end function
	 
	 /**
	  * Shows update options
	  * 
	  * <p>Creates a list of files that need update, added, and removed.</p>
	  * 
	  * @version 0.4.12
	  * @since 0.4.3
	  * @param array $localMammlVersion the local mamml version array
	  * @param array $globalMammlVersion the global mamml version array
	  * @param array $needUpdated array of files which need updated
	  * @param array $needAdded array of files which need added
	  * @param array $needRemoved array of files which need removed
	  * @param array $versions other versions that are available
	  * @param string $message the message to display
	  */
	 function showUpdateOptions($localMammlVersion, $globalMammlVersion, $needUpdated, $needAdded, $needRemoved, $mammlVersions, $message) {

		 if (!empty($message)) {
			 echo '<p>' . $message . '</p>';
		 } // end if
		 // make sure we need to show update options
		 if ((!empty($needAdded)) || (!empty($needRemoved)) || (!empty($needUpdated))) {		 
?>
<form action="index2.php" method="post" name="adminForm">
<table width="100%" cellpadding="4" cellspacing="0" border="0" align="left" class="adminlist">
	<tr>
		<th colspan="4"><?php echo _NEED_UPDATED; ?></th>
	</tr>
	<tr class="row0">
		<td>&nbsp;</td>
		<td><?php echo _FILENAME; ?></td>
		<td><?php echo _CURRENT_VERSION; ?></td>
		<td><?php echo _NEWEST_VERSION; ?></td>
	</tr>
<?php
		 	 // show files that need updated
		 	 foreach ($needUpdated as $file) {
?>
	<tr>
		<td><input type="checkbox" name="needUpdated[]" value="<?php echo $file; ?>" checked="checked" class="inputbox" /></td>
		<td><?php echo $file; ?></td>
		<td><?php echo $localMammlVersion[$file]; ?></td>
		<td><?php echo $globalMammlVersion[$file]; ?></td>
	</tr>
<?php
		 	 } // end foreach
?>
	<tr>
		<th colspan="4"><?php echo _NEED_ADDED; ?></th>
	</tr>
	<tr class="row0">
		<td>&nbsp;</td>
		<td><?php echo _FILENAME; ?></td>
		<td><?php echo _CURRENT_VERSION; ?></td>
		<td><?php echo _NEWEST_VERSION; ?></td>
	</tr>
<?php
		 	 // show files that need updated
		 	 foreach ($needAdded as $file) {
?>
	<tr>
		<td><input type="checkbox" name="needAdded[]" value="<?php echo $file; ?>" checked="checked" class="inputbox" /></td>
		<td><?php echo $file; ?></td>
		<td>&nbsp;</td>
		<td><?php echo $globalMammlVersion[$file]; ?></td>
	</tr>
<?php
		 	 } // end foreach
?>
	<tr>
		<th colspan="4"><?php echo _NEED_REMOVED; ?></th>
	</tr>
	<tr class="row0">
		<td>&nbsp;</td>
		<td><?php echo _FILENAME; ?></td>
		<td><?php echo _CURRENT_VERSION; ?></td>
		<td><?php echo _NEWEST_VERSION; ?></td>
	</tr>
<?php
		 	 // show files that need updated
		 	 foreach ($needRemoved as $file) {
?>
	<tr>
		<td><input type="checkbox" name="needRemoved[]" value="<?php echo $file; ?>" checked="checked" class="inputbox" /></td>
		<td><?php echo $file; ?></td>
		<td><?php echo $localMammlVersion[$file]; ?></td>
		<td>&nbsp;</td>
	</tr>
<?php
		 	 } // end foreach
?>
</table>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="act" value="update" />
	<input type="hidden" name="task" value="doUpdate" />
	<input type="hidden" name="currentversion" value="<?php echo $localMammlVersion['mamml']; ?>" />
</form>
<br />
<?php
		 } // end if
?>
<table width="100%" cellpadding="4" cellspacing="0" border="0" align="left" class="adminlist">
	<tr>
		<th><?php echo _INSTALL_DIFFERENT_VERSION; ?></th>
	</tr>
<?php
		 // output all other available versions
		 foreach ($mammlVersions as $version) {
?>
	<tr>
		<td><a href="index2.php?option=com_mamml&amp;act=update&amp;task=version&amp;version=<?php echo $version; ?>">MaMML <?php echo $version; ?></a></td>
	</tr>
<?php
		 } // end foreach
?>
</table>
<?php
	 } // end function
	 
 } // end class
?>