<?php
/**
 * uninstall.mamml.php
 * 
 * <p>Uninstall file for MaMML.</p>
 * 
 * @package MaMML
 * @subpackage backend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.4.11
 * @since 0.4.3
 * @link http://www.schmalls.com
 */

 /**
  *  Ensures this file is being included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
 
 /**
  * Mambo uninstall function
  * 
  * <p>Either removes MaMML tables or does nothing depending on the 
  * configuration. Returns a success or failure message.</p>
  * 
  * @version 0.4.10
  * @since 0.4.3
  * @return string success or failure message
  */
 function com_uninstall() {
	 
	 // remove tables
	 $check = removeTables();
	 if ($check) {
		 $message = '<p>Tables removed successfully.</p>';
	 } else {
		 $message = '<p>There was an error removing tables. Some may be left behind.</p>';
	 } // end if
	 return $message;
 } // end function
 
 /**
  * Remove table function
  * 
  * <p>Removes all MaMML database tables from the database.</p>
  * 
  * @version 0.4.11
  * @since 0.4.3
  * @global class access to the database
  * @return boolean whether it was successful or not
  */
 function removeTables() {
	 global $database;
	 
	 // create query array
	 $queries = array();
	 $queries[] = 'DROP TABLE `#__mamml_letters`';
	 $queries[] = 'DROP TABLE `#__mamml_subscribers`';
	 $queries[] = 'DROP TABLE `#__mamml_mailing`';
	 $queries[] = 'DROP TABLE `#__mamml_stats_overall`';
	 $queries[] = 'DROP TABLE `#__mamml_stats_detailed`';
	 $queries[] = 'DROP TABLE `#__mamml_unregistered`';
	 // perform queries
	 $error = '';
	 foreach ($queries as $query) {
		 $database->setQuery($query);
		 $database->query();
		 $error .= $database->getErrorMsg();
	 }
	 // check for errors
	 if (!empty($error)) {
		 echo '<p><b>Error (unistall.mamml.php-> line ' . __LINE__ . '):</b> Error removing database tables. Database error(s): <br />' . $error . '</p>';
		 return false;
	 } else {
		 return true;
	 } // end if
 } // end function
?>