<?php
 defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: ps_database.php,v 1.9 2005/01/27 19:33:40 soeren_nb Exp $
* @package mambo-phpShop

* @copyright (C) 2004-2005 Soeren Eberhardt
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/

/***********************************************************************
 Wrapper Class for Mambo's $database - Object 
************************************************************************/

class ps_DB {

  /** @var int   Current row in query result set */
  var $row = 0;
  /** @var stdclass	Current row record data */
  var $record = null;
  /** @var string  Error Message */
  var $error = "";
  /** @var int  Error Number */
  var $errno = "";
  /** @var string   The current sql Query    */
  var $_sql = "";
  /** @var boolean   true if next_record has already been called   */
  var $called = false;

  
    /**
    * Sets the SQL query string for later execution.
    *
    * This function replaces a string identifier <var>$prefix</var> with the
    * string held is the <var>_table_prefix</var> class variable.
    *
    * @param string The SQL query
    * @param string The common table prefix
    */
    function setQuery( $sql, $prefix='#__' ) {
        global $mosConfig_dbprefix, $database;
        
        $this->_sql = str_replace( $prefix, $mosConfig_dbprefix, $sql );
        $database->setQuery( $this->_sql );
    }
        
        
  /**
  * Runs query and sets up the query id for the class.
  *
  * @param string The SQL query
  */
  function query($q='') {
      global $database, $mosConfig_dbprefix;
      $prefix = "#__";
      
      if (empty($q)) {
          if (empty($this->_sql))
            return 0;
      }
      
      elseif( stristr( $q, $prefix ) ) {
          $q = str_replace( $prefix, $mosConfig_dbprefix, $q );
          $this->_sql = $q;
          $database->setQuery( $q );
      }
      $this->row = 0;
      $this->called = false;
      $this->record = null;
      $this->record = Array();

      if (strtoupper(substr( $this->_sql , 0, 6 )) == "SELECT" )
        $this->record = $database->loadObjectList();
      else
        $database->query();
    isset($database->_ticker) ? $database->_ticker++ : $database->_ticker = 1;
  }
  

  /**
  * Returns the next row in the RecordSet for the last query run.  
  * Returns False if RecordSet is empty or at the end.
  */
  function next_record() {

      if ( empty( $this->_sql ) ) {
        $this->error = "next_record called with no query pending.";
        return false;
      }
      if ( $this->called )
        $this->row++;
      else
        $this->called = true;
  
      if ($this->row < sizeof( $this->record ) ) {
        return true;
      }
      else
        return false;
  }
  

  /**
  *  Returns the value of the given field name for the current
  *  record in the RecordSet. 
  * f == field
  * @param string  The field name
  */
  function f($field_name) {
      if (isset($this->record[$this->row]->$field_name))
          return  stripslashes( $this->record[$this->row]->$field_name );
  }

  /**
  * Returns the value of the field name from the $vars variable
       if it is set, otherwise returns the value of the current
		  record in the RecordSet.  Useful for handling forms that have
		  been submitted with errors.  This way, fields retain the values 
		  sent in the $vars variable (user input) instead of the database
		  values.
      sf == selective field
  * @param string  The field name
  */
  function sf($field_name) {
      global $vars, $default;
  
      if (isset($vars["error"]) && !empty($vars["$field_name"])) {
          return  stripslashes($vars[$field_name] );
      } 
      elseif (isset($default[$field_name])) {
          return  stripslashes($default[$field_name]);
      } 
      elseif (isset($this->record[$this->row]->$field_name)) {
          return  stripslashes($this->record[$this->row]->$field_name );
      }
  }                             

  /**
  * Prints the value of the given field name for the current
  * record in the RecordSet.
  * p == print
  * @param string  The field name
  */
  function p($field_name) {
    if (isset($this->record[$this->row]->$field_name))
        print  stripslashes($this->record[$this->row]->$field_name );
  }                             

  /**
  * Prints the value of the field name from the $vars variable
      if it is set, otherwise prints the value of the current
		  record in the RecordSet.  Useful for handling forms that have
		  been submitted with errors.  This way, fields retain the values 
		  sent in the $vars variable (user input) instead of the database
		  values.
      sp == selective print
  * @param string  The field name
  */
  function sp($field_name) {
      global $vars, $default;
  
      if (isset($vars["error"]) && !empty($vars["$field_name"])) {
          print  stripslashes($vars["$field_name"] );
      } 
      elseif (isset($default["$field_name"])) {
          print  stripslashes($default["$field_name"] );
      } 
      elseif (isset($this->record[$this->row]->$field_name)) {
          print  stripslashes($this->record[$this->row]->$field_name );
      }
      else print "";
  }
  
  /**
  * Returns the number of rows in the RecordSet from a query.
  * 
  */
  function num_rows() { 
      
      return sizeof( $this->record );
  }
  /**
  * Returns the ID of the last AUTO_INCREMENT INSERT.
  * 
  */
  function last_insert_id() {
    global $database;
    return $database->insertid();
  }
  
  /**
  * Set the "next_record" pointer back to the first row.
  * 
  */
  function reset() {
    
    $this->row = 0;
    $this->called = false;
    
  }
}
?>
