<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// This file is designed so that site admins and 3PD developers will be
// able to develop their own addons that extend or replace the XE core
// and do additional URL handling according to fully custom rules.

// XE CORE FUNCTIONS

if (!function_exists( 'xeLoadSecurityHandler' )) {
  function xeLoadSecurityHandler( &$db, &$config, &$site ) {
    if (!defined( '_XE_SECURITY_HANDLER' )) {
      define( '_XE_SECURITY_HANDLER', 'xeSecurityHandler' );
      require_once( 'sef.security.php' );
    }
    $className = constant( '_XE_SECURITY_HANDLER' );
    $securityHandler =& new $className( $db, $config, $site );
    $securityHandler->setDebug( !empty( $config->debug ) );
    return $securityHandler;
  }
}

if (!function_exists( 'sefLoadSEFResolver' )) {
  function xeLoadSEFResolver( &$db, &$config, &$site ) {
    if (!defined( '_XE_SEF_RESOLVER' )) {
      define( '_XE_SEF_RESOLVER', 'xeSEFResolver' );
      require_once( 'sef.resolver.php' );
    }
    $className = constant( '_XE_SEF_RESOLVER' );
    $resolver =& new $className( $db, $config, $site );
    $resolver->setDebug( !empty( $config->debug ) );
    return $resolver;
  }
}

if (!function_exists( 'xeLoadSEFRewriter' )) {
  function xeLoadSEFRewriter( &$db, &$config, &$site ) {
    if (!defined( '_XE_SEF_REWRITER' )) {
      define( '_XE_SEF_REWRITER', 'xeSEFRewriter' );
      require_once( 'sef.rewriter.php' );
    }
    $className = constant( '_XE_SEF_REWRITER' );
    $rewriter =& new $className( $db, $config, $site );
    $rewriter->setDebug( !empty( $config->debug ) );
    return $rewriter;
  }
}

if (!function_exists( 'xeLoadSEFMapper' )) {
  function xeLoadSEFAutoMapper( &$db, &$config, &$site ) {
    if (!defined( '_XE_SEF_AUTOMAPPER' )) {
      define( '_XE_SEF_AUTOMAPPER', 'xeSEFAutoMapper' );
      require_once( 'sef.mapper.php' );
    }
    $className = constant( '_XE_SEF_AUTOMAPPER' );
    $autoMapper =& new $className( $db, $config, $site );
    $autoMapper->setDebug( !empty( $config->debug ) );
    return $autoMapper;
  }
}

if (!function_exists( 'xeLoadSEFExtension' )) {
  function xeLoadSEFExtension( $component ) {
    global $sefConfig;
    // TODO: PHP5 will have autoloading support, probably rendering this
    // function pretty much obsolete if we can take advantage of it.

    if (class_exists( 'sef_' . $component ))
      return true;

    $path = $GLOBALS['mosConfig_absolute_path'];
    $paths = array(
      "$path/administrator/components/com_sef/extensions/sef_ext.$component.php",
      "$path/administrator/components/com_$component/sef_ext.php",
      "$path/components/com_$component/sef_ext.php",
    );

    // We check whether the file exists, is readable, that it's not empty,
    // and then after loading that the class really exists; this is pretty
    // fail-safe and will move on to the next possible file if one doesn't
    // satisfy any of these conditions.
    $debug = !empty( $sefConfig->debug );
    foreach ($paths as $path) {
      if (file_exists( $path ) && is_readable( $path ) && filesize( $path ) > 0) {
        if (!$debug) ob_start();
        @include_once( $path );
        if (!$debug) ob_end_clean();
        if (class_exists( 'sef_' . $component ))
          return true;
      }
    }

    return false;
  }
}

// SEF CORE FUNCTIONS

if (!function_exists( 'sefEncode' )) {
  function sefEncode( $string ) {
    return urlencode( $string );
  }
}

if (!function_exists( 'sefDecode' )) {
  function sefDecode( $string ) {
    return urldecode( $string );
  }
}

if (!function_exists( 'sefRelToAbs' )) {
  function sefRelToAbs( $string ) {
    global $sefRewriter;
    if (!isset( $sefRewriter ) || !is_object( $sefRewriter )) {
      global $database, $sefConfig, $sefSite;
      $sefRewriter =& xeLoadSEFRewriter( $database, $sefConfig, $sefSite );
    }
    return $sefRewriter->rewrite( $string );
  }
}

if (!function_exists( 'sefIsMamboSEF' )) {
  function sefIsMamboSEF( $url ) {
    if ($url[0] == '/') $url = substr( $url, 1 );
    return (eregi( '^content/', $url )
      || eregi( '^component/.*option,com_', $url ));
  }
}

if (!function_exists( 'sefIsMamboURL' )) {
  function sefIsMamboURL( $url ) {
    if ($url[0] == '/') $url = substr( $url, 1 );
    return (eregi( '^index.php', $url )
      || eregi( '^index2.php', $url ));
  }
}

if (!function_exists( 'sefIsExternalURL' )) {
  function sefIsExternalURL( $url ) {
    return (eregi( '^(http|https|ftp)\://', $url ) ? true : false);
  }
}

if (!function_exists( 'sefRewriteToMamboSEF' )) {
  function sefRewriteToMamboSEF( $url, $path = null ) {
    $component = null;
    if (ereg( '[\?&]+option=com_([0-9a-zA-Z_\-]+)&', $url, $matches ))
      $component = $matches[1];
    $menu_id = 0;
    if (ereg( '&Itemid=([0-9]+)', $url, $matches ))
      $menu_id = $matches[1];

    if ($component == 'content') {
      $rewrites = array(
        '#^index\.php\?option=com_content#' => 'content',
        '#&([\w]+)=([\w\d]+)#'  => '/\\2',
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      );
    }
    else {
      $path = ($path ? $path : 'component/option,com_' .
        $component . '/Itemid,' . $menu_id . '/');
      $rewrites = array(
        '#^index\.php#'         => '',
        "#[\?&]+option=com_$component#" => '',
        '#[\?&]+Itemid=([\d]+)#' => '',
        '#\?#'                  => '&',
        '#&([\w]+)=([^&]+)#'    => '/\\1,\\2',
        '#^[/]?#'               => $path, // Consume one slash and prepend component path
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      );
    }
    return preg_replace( array_keys( $rewrites ),
      array_values( $rewrites ), $url );
  }
}

if (!function_exists( 'sefRewriteFromMamboSEF' )) {
  function sefRewriteFromMamboSEF( $url ) {
    if ($url[0] == '/') $url = substr( $url, 1 );
    if (ereg( '^content/', $url )) {
      // Mambo SEF-style content URLs
      // HACK: if any regex guru can improve on this, please do!
      $rewrites = array(
        '#^content#'           => '',
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&sectionid=\\2&id=\\3&Itemid=\\4&limit=\\5&limitstart=\\6',
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&id=\\2&Itemid=\\3&limit=\\4&limitstart=\\5',
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&sectionid=\\2&id=\\3&Itemid=\\4',
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&id=\\2&Itemid=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&task=\\1&id=\\2',
        '#/([^/]+)/#'           => '&task=\\1',
        '#^#'                   => 'index.php?option=com_content',
      );
    }
    else if (ereg( '^component/', $url )) {
      // Now this is pretty simple. Removed the earlier assumptions about the
      // 'option' parameter being the first, as phpShop among other doesn't
      // stick to any particular convention.
      $rewrites = array(
        '#^component/([^,]+),([^/]+)#' => 'index.php?\\1=\\2',
        '#/([^,]+),([^/]+)#'    => '&\\1=\\2',
        '#/$#'                  => '',
      );
    }
    return preg_replace( array_keys( $rewrites ),
      array_values( $rewrites ), $url );
  }
}

?>