/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 5.9a                                                       *
 ************************************************************************/

#include <iostream>
using namespace std;

double pot(double a, int n)
{
    double x = 1;       /* pocztkowa warto potgi, dla n = 0 */
    while (n != 0) {
        if (n%2 == 0)
            a = a*a;    /* wykadnik parzysty */
        else {          /* wykadnik nieparzysty */
            x = x*a;
            a = a*a;
        }
        n /= 2;         /* "poowa" wykadnika */
    }
    return x;
}

double adoen(double a, int n)
{
    if (a == 0 && n <= 0)
        exit(-1); /* symbol nieoznaczony */
    else if (a == 0)
        return 0;   /* 0^n = 0, dla n = 1, 2, 3... */
    else if (a == 1)
        return 1; /* 1^n = 1, dla dowolnego n */
    else {
        if (n < 0) {/* jeli wykadnik jest ujemny... */
            a = 1/a; /* odwrotno podstawy */
            n = -n;  /* zmiana znaku wykadnika */
        }
        /* wywoanie funkcji realizujcej szybkie potgowanie */
        return pot(a, n); /* wynik a ^ n */
    }
}

int main()
{
    system("chcp 1250");
    cout << "1^0 = " <<  adoen(1, 0) << endl;
    cout << "0^1 = " <<  adoen(0, 1) << endl;
    cout << "2^3 = " <<  adoen(2, 3) << endl;
    cout << "2^-3 = " <<  adoen(2, -3) << endl;
    cout << "5^-1 = " <<  adoen(5, -1) << endl;
    cout << "1.5^2 = " <<  adoen(1.5, 2) << endl;
    /* cout << "0^0 = " <<  adoen(0, 0) << endl; */
    cout << "0^-1 = " <<  adoen(0, -1) << endl; /* bd! */
    cout << "Kolejnego przykadu nie bdzie.\n" << endl;
    system("pause");
    return 0;
}
