/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 9.21a                                                      *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>

struct fraction {
    int licz;
    int mian;
};

int nwd(int m, int n)
{
    if (m == n)
        return m;
    else if (m > n)
        return nwd(m-n, n);
    else
        return nwd(n-m, m);
}

int main()
{
    system("chcp 1250");
    struct fraction cf[42], u, v;
    int i, n;
    printf("Obliczenie e - uamek acuchowy Eulera.\n\n");
    /* wczytywanie uamka do tablicy */
    cf[0].licz = 1;             /* cz cakowita */
    for(i = 1; i <= 42; ++i)
        cf[i].licz = 1;         /* liczniki */
    for(i = 1; i <= 42; ++i)
        cf[i].mian = 1;         /* mianowniki */
    for(i = 1; i <= 14; ++i)    /* zmiana wybranych mianownikw */
        cf[3*i].mian = 2*i;
    n = 20;                     /* liczba ogniw do zsumowania */
    /* wywietlanie uamka acuchowego */
    printf("u = %d", cf[0].licz);
    for(i = 1; i < n; ++i)
        printf("+%d/(%d", cf[i].licz, cf[i].mian);
    printf("+%d/%d", cf[n].licz, cf[n].mian);
    for(i = 1; i < n; ++i)
        printf(")");
    printf("\n");
    /* zamiana uamka acuchowego na zwyky */
    v = cf[n];
    for(i = n-1; i > 0; --i) {
        u = v;
        v.licz = cf[i].licz*u.mian;
        v.mian = cf[i].mian*u.mian+u.licz;
        int s = nwd(v.licz, v.mian);
        v.licz /= s;
        v.mian /= s;
    }
    u.mian = v.mian;
    u.licz = cf[0].licz*v.mian+v.licz;
    /* wywietlenie wyniku */
    printf("u = %d / %d\n", u.licz, u.mian);
    printf("e = %lf\n", (double)u.licz/u.mian+1);
    system("pause");
    return 0;
}
