/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 7.6                                                        *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>

void inputfrac(int* licz, int* mian)
{
    char znak;
    scanf("%d%c%d", licz, &znak, mian);
    if (*mian < 0) { /* korekta znakw licznika i mianownika */
        *licz = -*licz;
        *mian = -*mian;
    } else if (*mian == 0)
        *mian = 1;
}

void printfrac(int licz, int mian)
{
    if (mian != 0)
        printf("%d/%d", licz, mian);
    else
        printf(" * error * ");
}

int nwd(int m, int n)
{
    if (m == 0)
        return n;
    else if (n == 0)
        return m;
    else if (m == n)
        return m;
    else if (m > n)
        return nwd(m%n, n);
    else
        return nwd(n%m, m);
}

void abbrfrac(int* licz, int* mian)
{
    int wd = nwd(abs(*licz), abs(*mian));
    *licz /= wd;
    *mian /= wd;
}

void multfrac(int l1, int m1, int l2, int m2, int* pl3, int* pm3)
{
    abbrfrac(&l1, &m1);
    abbrfrac(&l2, &m2);
    *pl3 = l1*l2;
    *pm3 = m1*m2;
    abbrfrac(pl3, pm3);
}

void divfrac(int l1, int m1, int l2, int m2, int* pl3, int* pm3)
{
    multfrac(l1, m1, m2, l2, pl3, pm3);
    if (*pm3 < 0) { /* korekta znakw licznika i mianownika */
        *pl3 = -*pl3;
        *pm3 = -*pm3;
    }
}

int main()
{
    system("chcp 1250");
    int l1, m1, l2, m2, l3, m3;
    printf("Mnoenie i dzielenie uamkw.\n");
    printf("Podaj uamek (wg wzoru: licznik/mianownik): ");
    inputfrac(&l1, &m1);
    printf("u = ");
    printfrac(l1, m1);
    printf("\n");
    printf("Podaj uamek (wg wzoru: licznik/mianownik): ");
    inputfrac(&l2, &m2);
    printf("v = ");
    printfrac(l2, m2);
    printf("\n");
    multfrac(l1, m1, l2, m2, &l3, &m3);
    printf("u * v = ");
    printfrac(l3, m3);
    printf("\n");
    divfrac(l1, m1, l2, m2, &l3, &m3);
    printf("u : v = ");
    printfrac(l3, m3);
    printf("\n");
    system("pause");
    return 0;
}
