/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 ************************************************************************/

#include "funtrygo.h"

double deg2rad(double st)  /* zamiana stopni na radiany */
{
    return st*PI/180;
}

double rad2deg(double rad)  /* zamiana radianw na stopnie */
{
    return rad*180/PI;
}

void printdeg(double x)
{
    double st, min, sek;
    modf(60*modf(60*modf(x, &st), &min)+0.5, &sek);
    printf("%d%d'%d''", (int)st, (int)min, (int)sek);
}

void inputdeg(double * x)
{
    int st, min, sek, error;
    do {
        error = 0;
        printf("Podaj miar kta (stopnie minuty sekundy): ");
        scanf("%d%d%d", &st, &min, &sek);
        if ((st < 0) || (st > 360)) {
            printf("Niewaciwa liczba stopni!\n");
            error = 1;
        }
        if ((min < 0) || (min > 59)) {
            printf("Niewaciwa liczba minut!\n");
            error = 1;
        }
        if ((sek < 0) || (sek > 59)) {
            printf("Niewaciwa liczba sekund!\n");
            error = 1;
        }
    } while (error); /* powrt, gdy jest bd */
    if ((st == 360) && ((min > 0) || (sek > 0)))
        st = 0;
    *x = st+(double)min/60+(double)sek/3600; /* wynik */
}

double Sin(double st)
{
    return sin(st/180*PI);
}

double Cos(double st)
{
    return cos(st/180*PI);
}

double Tg(double st)
{
    return Sin(st)/Cos(st);
}

double Ctg(double st)
{
    return Cos(st)/Sin(st);
}

double cot(double rad)
{
    return 1/tan(rad);
}

double readSide(char opis)
{
    double x;
    do {
        printf("Podaj dugo boku %c = ", opis);
        scanf("%lf",&x);
        if (x <= 0)
            printf("Bd! Dugo boku ma by liczb dodatni!\n");
    } while (x <= 0); /* powtarzamy, gdy x nie jest dodatnie */
    return x; /* zwracamy wynik */
}

int isTriangle(double x, double y, double z)
{
    return x+y > z && y+z > x && z+x > y;
}
