(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad P7.8                                                       *
 ************************************************************************)

program tp7_8;

procedure inputfrac(var licz, mian: longint);
var znak: char;
begin
  readln(licz, znak, znak, mian);
  if mian < 0
    then begin {korekta znakw licznika i mianownika}
           licz := -licz;
           mian := -mian;
         end
    else if mian = 0
           then mian := 1;
end;

procedure printfrac(licz, mian: longint);
begin
  if mian <> 0
    then write(licz, ' / ', mian)
    else write(' * error * ');
end;

function nwd(m, n: longint): longint;
begin
  if (m = 0)
    then nwd := n
    else if (n = 0)
           then nwd := m
           else if (m = n)
                  then nwd := m
                  else if m > n
                         then nwd := nwd(m mod n, n)
                         else nwd := nwd(n mod m, m);
end;

procedure abbrfrac(var licz, mian: longint);
var wd: longint;
begin
  wd := nwd(abs(licz), abs(mian));
  licz := licz div wd;
  mian := mian div wd;
end;

function nww(m, n: longint): longint;
begin
  nww := m div nwd(m, n) * n;
end;

procedure addfrac(l1, m1, l2, m2: longint; var l3, m3: longint);
begin
  m3 := nww(m1, m2);
  l1 := m3 div m1 * l1;
  l2 := m3 div m2 * l2;
  l3 := l1+l2;
  abbrfrac(l3, m3);
end;

procedure subfrac(l1, m1, l2, m2: longint; var l3, m3: longint);
begin
  addfrac(l1, m1, -l2, m2, l3, m3);
end;

var l1, m1, l2, m2, l3, m3: longint;

begin
  writeln('Dodawanie i odejmowanie uamkw.');
  write('Podaj uamek (wg wzoru: licznik / mianownik): ');
  inputfrac(l1, m1);
  write('u = ');
  printfrac(l1, m1);
  writeln;
  write('Podaj uamek (wg wzoru: licznik / mianownik): ');
  inputfrac(l2, m2);
  write('v = ');
  printfrac(l2, m2);
  writeln;
  addfrac(l1, m1, l2, m2, l3, m3);
  write('u + v = ');
  printfrac(l3, m3);
  writeln;
  subfrac(l1, m1, l2, m2, l3, m3);
  write('u - v = ');
  printfrac(l3, m3);
  writeln;
  readln;
end.
