/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 2.11                                                       *
 ************************************************************************/

#include <iostream>
#include <math.h>
using namespace std;

double CzytajBok(char opis)
{
    double x;
    do {
        cout << "Podaj dugo boku " << opis << " = ";
        cin >> x;
        if (x <= 0)
            cout << "Bd! Dugo boku ma by liczb dodatni!\n";
    } while (x <= 0); /* powtarzamy, gdy x nie jest dodatnie */
    return x; /* zwracamy wynik */
}

int CzyTrojkat(double x, double y, double z)
{
    return x+y > z && y+z > x && z+x > y;
}

double WzorHerona(double x, double y, double z)
{
    if (x <= 0 || y <= 0 || z <= 0)
        return 0;
    else {
        double p = (x+y+z)/2;
        return sqrt(p*(p-x)*(p-y)*(p-z));
    }
}

int main ()
{
    system("chcp 1250");
    cout << "Obliczanie pola powierzchni trjkta  wzr Herona\n\n";
    /* wczytywanie danych */
    double a = CzytajBok('a');
    double b = CzytajBok('b');
    double c = CzytajBok('c');
    /* sprawdzanie czy trjkt istnieje i obliczenia */
    if (CzyTrojkat(a, b, c))
        cout << "Pole trjkata S = " << WzorHerona(a, b, c) << endl;
    else
        cout << "Trjkt o podanych bokach nie istnieje!\n";
    system("pause");
    return 0;
}

