/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 9.1                                                        *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct fraction {
    int licz;
    int mian;
};

void printfrac(struct fraction x)
{
    printf("%d / %d", x.licz, x.mian);
}

struct fraction setfrac(int l, int m)
{
    struct fraction z;
    z.licz = l;
    z.mian = m;
    return z;
}

struct fraction sqrfrac(struct fraction x)
{
    return setfrac(x.licz*x.licz, x.mian*x.mian);
}

struct fraction frac_x10(struct fraction x)
{
    return setfrac(10*x.licz, 10*x.mian);
}

struct fraction incfrac(struct fraction x)
{
    return setfrac(++x.licz, x.mian);
}

struct fraction decfrac(struct fraction x)
{
    return setfrac(--x.licz, x.mian);
}

int compfrac(struct fraction x, struct fraction y)
{
    int i;
    i = x.licz*y.mian-x.mian*y.licz;
    if (i < 0)
        return -1;
    else if (i > 0)
        return 1;
    else return -1;
}

int main()
{
    struct fraction a, dwa;
    int i, f;
    dwa = setfrac(2, 1);
    a = setfrac(1, 1);
    i = 1;
    do {
        f = 0;
        while (compfrac(sqrfrac(a), dwa) == -1) {
            a = incfrac(a);
            f = 1;
        }
        if (f) a = decfrac(a);
        printfrac(a);
        printf(" = %0.16lf\n", (double)a.licz/a.mian);
        a = frac_x10(a);
        ++i;
    } while (i < 11);
    printf("Wynik standardowej funkcji sqrt(2) = %0.16lf\n", sqrt(2));
    system("pause");
    return 0;
}
