(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad P9.17A                                                     *
 ************************************************************************)

program tp9_17a;

type fraction = record
                  licz: longint;
                  mian: longint;
                end;

function nwd(m, n: longint): longint;
begin
  if (m = n)
    then nwd := m
    else if m > n then nwd := nwd(m-n, n)
                  else nwd := nwd(n-m, m);
end;

var cf: array[0..12] of fraction;
    u, v: fraction;
    i, n: integer;
    s: longint;

begin
  writeln('Przyblienie 4/Pi z rozwinicia w uamek acuchowy (Brouncker).');

  {umieszczenie uamka w tablicy}
  cf[0].licz := 1;
  for i := 1 to 12 do
    cf[i].mian := 2;
  for i := 1 to 12 do
    cf[i].licz := (2*i-1)*(2*i-1);
  n := 11;

  {wywietlanie uamka acuchowego}
  write('u = ', cf[0].licz);
  for i := 1 to n-1 do
    write('+', cf[i].licz, '/(', cf[i].mian);
  write('+', cf[n].licz, '/', cf[n].mian);
  for i:= 1 to n-1 do
    write(')');
  writeln;

  {zamiana uamka acuchowego na zwyky}
  v := cf[n];
  for i := n-1 downto 1 do
    begin
      u := v;
      v.licz := cf[i].licz*u.mian;
      v.mian := cf[i].mian*u.mian+u.licz;
      s := nwd(v.licz, v.mian); {skracanie uamka v}
      v.licz := v.licz div s;
      v.mian := v.mian div s;
    end;
  u.mian := v.mian;
  u.licz := cf[0].licz*v.mian+v.licz;

  {wywietlenie wyniku}
  writeln('u = ', u.licz, ' / ', u.mian, ' = ', u.licz/u.mian:0:18);
  writeln('PI = ', u.mian/u.licz*4:0:18);
  readln;
end.
