/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 9.17a                                                      *
 ************************************************************************/

#include <iostream>
using namespace std;

struct fraction {
    int licz;
    int mian;
};

int nwd(int m, int n)
{
    if (m == n)
        return m;
    else if (m > n)
        return nwd(m-n, n);
    else
        return nwd(n-m, m);
}

int main()
{
    system("chcp 1250");
    fraction cf[26], u, v;
    int i, n;
    cout << "Obliczenie 4/Pi - uamek acuchowy Brounckera.\n\n";
    /* wczytywanie uamka do tablicy */
    cf[0].licz = 1;
    for(i = 1; i < 26; ++i)
        cf[i].mian = 2;
    for(i = 1; i < 26; ++i)
        cf[i].licz = (2*i-1)*(2*i-1);
    n = 11;             /* liczba ogniw do zsumowania */
    /* wywietlanie uamka acuchowego */
    cout << "u = " << cf[0].licz;
    for(i = 1; i < n; ++i)
        cout << "+" << cf[i].licz << "/(" << cf[i].mian;
    cout << "+" << cf[n].licz << "/" << cf[n].mian;
    for(i = 1; i < n; ++i)
        cout << ")";
    cout << "\n";
    /* zamiana uamka acuchowego na zwyky */
    v = cf[n];
    for(i = n-1; i > 0; --i) {
        u = v;
        v.licz = cf[i].licz*u.mian;
        v.mian = cf[i].mian*u.mian+u.licz;
        int s = nwd(v.licz, v.mian);
        v.licz /= s;
        v.mian /= s;
    }
    u.mian = v.mian;
    u.licz = cf[0].licz*v.mian+v.licz;
    /* wywietlenie wyniku */
    cout << "u = "<< u.licz << " / " << u.mian << endl;
    cout << "PI = " << (double)u.mian/u.licz*4 << endl;
    system("pause");
    return 0;
}
