/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 9.17a                                                      *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>

struct fraction {
    int licz;
    int mian;
};

int nwd(int m, int n)
{
    if (m == n)
        return m;
    else if (m > n)
        return nwd(m-n, n);
    else
        return nwd(n-m, m);
}

int main()
{
    system("chcp 1250");
    struct fraction cf[26], u, v;
    int i, n;
    printf("Obliczenie 4/Pi - uamek acuchowy Brounckera.\n\n");
    /* wczytywanie uamka do tablicy */
    cf[0].licz = 1;
    for(i = 1; i < 26; ++i)
        cf[i].mian = 2;
    for(i = 1; i < 26; ++i)
        cf[i].licz = (2*i-1)*(2*i-1);
    n = 11;             /* liczba ogniw do zsumowania */
    /* wywietlanie uamka acuchowego */
    printf("u = %d", cf[0].licz);
    for(i = 1; i < n; ++i)
        printf("+%d/(%d", cf[i].licz, cf[i].mian);
    printf("+%d/%d", cf[n].licz, cf[n].mian);
    for(i = 1; i < n; ++i)
        printf(")");
    printf("\n");

    /* zamiana uamka acuchowego na zwyky */
    v = cf[n];
    for(i = n-1; i > 0; --i) {
        int s;
        u = v;
        v.licz = cf[i].licz*u.mian;
        v.mian = cf[i].mian*u.mian+u.licz;
        s = nwd(v.licz, v.mian);
        v.licz /= s;
        v.mian /= s;
    }
    u.mian = v.mian;
    u.licz = cf[0].licz*v.mian+v.licz;

    /* wywietlenie wyniku */
    printf("u = %d/%d\n", u.licz, u.mian);
    printf("PI = %lf\n", (double)u.mian/u.licz*4);
    system("pause");
    return 0;
}
