/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 2.11                                                       *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double CzytajBok(char opis)
{
    double x;
    do {
        printf("Podaj dugo boku %c = ", opis);
        scanf("%lf",&x);
        if (x <= 0)
            printf("Bd! Dugo boku ma by liczb dodatni!\n");
    } while (x <= 0); /* powtarzamy, gdy x nie jest dodatnie */
    return x;         /* zwracamy wynik */
}

int CzyTrojkat(double x, double y, double z)
{
    return x+y > z && y+z > x && z+x > y;
}

double WzorHerona(double x, double y, double z)
{
    if (x <= 0 || y <= 0 || z <= 0)
        return 0;
    else {
        double p = (x+y+z)/2;
        return sqrt(p*(p-x)*(p-y)*(p-z));
    }
}

int main ()
{
    system("chcp 1250");
    double a, b, c;
    printf("Obliczanie pola powierzchni trjkta  wzr Herona\n\n");
    /* wczytywanie danych */
    a = CzytajBok('a');
    b = CzytajBok('b');
    c = CzytajBok('c');
    /* sprawdzanie czy trjkt istnieje i obliczenia */
    if (CzyTrojkat(a, b, c))
        printf("Pole trjkata S = %0.4lf\n", WzorHerona(a, b, c));
    else
        printf("Trjkt o podanych bokach nie istnieje!\n");
    system("pause");
    return 0;
}

