    #include <stdio.h>          /* Dla printf, fprintf */
    #include <string.h>         /* Dla strcmp */
    #include <ctype.h>          /* Dla isdigit */
    #include <fcntl.h>          /* Dla O_RDONLY */
    #include <dirent.h>         /* Dla readdir */
    #include <sys/stat.h>       /* Dla makr IS */
    #include <sys/types.h>      /* Dla modet */
    #include <time.h>           /* Dla localtime, asctime */


   /* Instrukcje #define */
   #define MAX_FILES     100
   #define MAX_FILENAME     50
   #define NOT_FOUND     -1
   #define FOREVER       -1
   #define DEFAULT_DELAY_TIME  10
   #define DEFAULT_LOOP_COUNT  FOREVER


   /* Zmienne logiczne */
   enum { FALSE, TRUE };


   /* Struktura status, jedna dla każdego pliku */
   struct statStruct
   {
        char fileName [MAX_FILENAME];      /* Nazwa pliku */
        int lastCycle, thisCycle;          /* Do wykrywania zmian */
        struct stat status;                /* Informacje zwrócone przez stat() */
   };


   /* Zmienne globalne */
   char* fileNames [MAX_FILES];            /* Dla każdego pliku podanego 
                                              w tekście polecenia */
   int fileCount;      /* Licznik plików podanych w tekście polecenia */
   struct statStruct stats [MAX_FILES];    /* Dla każdego zgodnego pliku */
   int loopCount = DEFAULT_LOOP_COUNT;     /* Ile razy wykonać pętlę */
   int delayTime = DEFAULT_DELAY_TIME;     /* Ile sekund odczekać pomiędzy 
                                              kolejnymi pętlami */

   /****************************************************************************/
   main (argc, argv)

   int argc;
   char* argv [];

   {
        parseCommandLine (argc, argv);      /* Przetwarzaj tekst polecenia */
        monitorLoop ();                     /* Wykonaj główną pętlę monitora */
        return (/* POPRAWNE_ZAKOŃCZENIE */ 0);
   }

   /****************************************************************************/

   parseCommandLine (argc, argv)

   int argc;
   char* argv [];

   /* Przetwarzaj parametry podane w tekście polecenia */

   {
        int i;

       for (i = 1; ( (i < argc) && (i < MAX_FILES) ); i++)
        {
          if (argv[i][0] == '-')
            processOptions (argv[i]);
          else
            fileNames[fileCount++] = argv[i];
        }

        if (fileCount == 0) usageError ();
   }

   /****************************************************************************/

   processOptions (str)

   char* str;

   /* Przetwarzaj opcje */

  {
        int j;

        for (j = 1; str[j] !=0; j++)
        {
          switch(str[j]) /* Przetwarzaj litery opcji */
          {
            case 't':
                 delayTime = getNumber (str, &j);
                 break;

            case 'l':
                 loopCount = getNumber (str, &j);
                 break;
          }
        }
  }

  /****************************************************************************/

  getNumber (str, i)

  char* str;
  int* i;

  /* Zamień opcję numeryczną ASCII na liczbę */

  {
       int number = 0;
       int digits = 0;                    /* Licznik cyfr w liczbie */

       while (isdigit (str[(*i) + 1]))    /* Zamień znaki na liczby całkowite */
       {
         number = number * 10 + str[++(*i)] - '0';
         ++digits;
       }

       if (digits == 0) usageError ();    /* Liczba musi być podana */
       return (number);
  }

  /****************************************************************************/

  usageError ()

  {
       fprintf (stderr, "Sposób użycia: monitor -t<sekundy> -l<powtórzenia> {nazwa_pliku}+\n");
       exit (/* NIEPOPRAWNE_ZAKOŃCZENIE */ 1);
  }
  /****************************************************************************/

  monitorLoop ()

  /* Główna pętla monitora */

  {
       do
       {
         monitorFiles ();        /* Sprawdź wszystkie pliki */
         fflush (stdout);        /* Opróżnij standardowe wyjście */
         fflush (stderr);        /* Opróżnij standardowy kanał błędów */
         sleep (delayTime);      /* Czekaj na następną pętlę */
       }
       while (loopCount == FOREVER || --loopCount > 0);
  }

  /****************************************************************************/

  monitorFiles ()
  /* Przetwarzaj wszystkie pliki */

  {
       int i;

       for (i = 0; i < fileCount; i++)
         monitorFile (fileNames[i]);

       for (i = 0; i < MAX_FILES; i++) /* Uaktualnij tablicę stats */
       {
         if (stats[i].lastCycle && !stats[i].thisCycle)
              printf ("USUNIĘTY %s\n", stats[i].fileName);

         stats[i].lastCycle=stats[i].thisCycle;
         stats[i].thisCycle = FALSE;
       }
  }

  /****************************************************************************/

  monitorFile (fileName)

  char* fileName;

  /* Przetwarzaj jeden plik lub katalog */

  {
       struct stat statBuf;
       mode_t mode;
       int result;

       result = stat (fileName, &statBuf);      /* Uzyskaj status pliku */

       if (result == -1)                        /* Status nie był dostępny */
       {
         fprintf (stderr, "Nie mogę uzyskać informacji o %s\n", fileName);
         return;
       }

       mode = statBuf.st_mode; /* Tryb pliku */

       if(S_ISDIR (mode)) /* Katalog */
         processDirectory (fileName);
       else if (S_ISREG (mode) || S_ISCHR (mode) || S_ISBLK (mode))
         updateStat (fileName, &statBuf);       /* Zwykły plik */
  }

  /****************************************************************************/

  processDirectory (dirName)

  char* dirName;

  /* Przetwarzaj wszystkie pliki znajdujące się w podanym katalogu */

  {
       struct dirent *dirEntry;
       DIR *dp;
       char fileName [MAX_FILENAME];

       if ((dp = opendir(dirName)) == NULL ) {
         fatalError ();
       }

       dirEntry = readdir(dp);

       while ( dirEntry != NULL ) /* Czytaj wszystkie wpisy w katalogu */
       {
         if (strcmp (dirEntry->d_name, ".") != 0&&
              strcmp (dirEntry->d_name, "..") != 0) /* Pomiń . i .. */
         {
              sprintf (fileName, "%s/%s", dirName, dirEntry->d_name);
              monitorFile (fileName);      /* Wywołaj rekurencyjnie */
         }

         dirEntry = readdir(dp);
       }

       closedir(dp);
  }

  /****************************************************************************/

  updateStat (fileName, statBuf)

  char* fileName;
  struct stat* statBuf;

  /* Dodaj wpis o statusie, jeżeli potrzeba */

  {
       int entryIndex;
       entryIndex = findEntry (fileName);            /* Znajdź istniejący wpis */

       if (entryIndex == NOT_FOUND)
         entryIndex = addEntry (fileName, statBuf);  /* Dodaj nowy wpis */
       else
         updateEntry (entryIndex, statBuf);      /* Uaktualnij istniejący wpis */

       if (entryIndex != NOT_FOUND)
         stats[entryIndex].thisCycle = TRUE;     /* Uaktualnij tablicę statusu */
  }

  /****************************************************************************/

  findEntry (fileName)

  char* fileName;

  /* Znajdź indeks podanego pliku w tablicy statusu */

  {
       int i;

       for (i = 0; i < MAX_FILES; i++)
         if (stats[i].lastCycle &&
              strcmp (stats[i].fileName, fileName) == 0) return (i);

       return (NOT_FOUND);
  }

  /****************************************************************************/

  addEntry (fileName, statBuf)

  char* fileName;
  struct stat* statBuf;

  /* Dodaj nowy wpis do tablicy statusu */

  {
       int index;

       index = nextFree();                  /* Znajdź pierwszy wolny wpis */
       if (index == NOT_FOUND) return (NOT_FOUND);     /* Nie ma już żadnych */
       strcpy (stats[index].fileName, fileName);       /* Dodaj nazwę pliku */
       stats[index].status = *statBuf;      /* Dodaj informacje o statusie */
       printf ("DODANY ");      /* Poinformuj przez standardowe wyjście */
       printEntry (index);      /* Wyświetl informacje o statusie */
       return (index);
  }

  /****************************************************************************/

  nextFree ()

  /* Zwraca kolejny wolny indeks w tablicy statusu */

  {
       int i;

       for (i = 0; i <MAX_FILES; i++)
         if (!stats[i].lastCycle && !stats[i].thisCycle) return (i);

       return (NOT_FOUND);
  }

  /****************************************************************************/

  updateEntry (index, statBuf)

  int index;
  struct stat* statBuf;

  /* Wyświetl informację, jeżeli plik został zmieniony */

  {
       if (stats[index].status.st_mtime != statBuf->st_mtime)
       {
         stats[index].status = *statBuf;  /* Przechowaj informacje o statusie */
         printf ("ZMIENIONY ");      /* Poinformuj przez standardowe wyjście */
         printEntry (index);
       }
  }

  /****************************************************************************/

  printEntry (index)

  int index;

  /* Wyświetl wpis z tablicy statusu */

  {
       printf ("%s ", stats[index].fileName);
       printStat (&stats[index].status);
  }

  /****************************************************************************/

  printStat (statBuf)

  struct stat* statBuf;

  /* Wyświetl bufor stanu */

  {
       printf ("rozmiar %lu bajtów, czas modyfikacji = %s", statBuf->st_size,
              asctime (localtime (&statBuf->st_mtime)));
  }

  /****************************************************************************/

  fatalError ()

  {
       perror ("monitor: ");
       exit (/* NIEPOPRAWNE_ZAKOŃCZENIE */ 1);
  }
