###############################################

# Uruchom jako użytkownik root bazy danych MySQL

DELETE FROM	mysql.user
	WHERE   user='';
FLUSH PRIVILEGES;
quit

###############################################

# Uruchom jako użytkownik root bazy danych MySQL

CREATE DATABASE	maxdb;

GRANT		ALL PRIVILEGES
	ON	maxdb.* to 'kuba'
	IDENTIFIED BY 'm0je_h@sło'
	WITH GRANT OPTION;

SELECT		user, password
	FROM	mysql.user;

###############################################

USE maxdb;

# Poniższe polecenia są konieczne tylko po ponownym uruchomieniu tego skryptu.
# drop table people; # tylko dla skryptu
# drop table stores; # tylko dla skryptu

CREATE TABLE	people (
		name CHAR(10),
		hired DATE,
		store INTEGER,
		hourly BOOL
		);
SHOW TABLES;

DESCRIBE people;

ALTER TABLE	people
	MODIFY	hourly BOOL DEFAULT TRUE;

DESCRIBE people;

# Przykład błędu.
# INSERT INTO	people
# 	VALUES ( tomek, '2012/11/01', 4, FALSE);

INSERT INTO	people
	VALUES ( 'tomek', '2012/11/01', 4, FALSE);

INSERT INTO	people (name, store)
	VALUES	( 'paweł', 2 ),
		( 'bartek', 2 );

LOAD DATA LOCAL INFILE '/home/kuba/addfile'
	INTO TABLE people;

SELECT		*
	FROM	people;

SELECT		*
	FROM	people
		ORDER BY name;

SELECT		name
	FROM	people
	WHERE	store = 4;

SELECT		name
	FROM	people
	WHERE	store > 2;

SELECT		name,
		store
	FROM	people
	WHERE	name LIKE '%m%';

DELETE FROM	people
	WHERE	name='bartek'
		OR name='paweł';

SELECT		name
	FROM	people;

UPDATE		people
	SET	hourly = TRUE
	WHERE	name = 'mateusz' OR
		name = 'tomek';

UPDATE		people
	SET	hired = CURDATE()
	WHERE name = 'kuba';

SELECT		*
	FROM	people;

CREATE TABLE	stores (
		name VARCHAR(20),
		number INTEGER,
		city VARCHAR(20)
		);

INSERT INTO	stores
	VALUES	( 'headquarters', 4, 'new york' ),
		( 'midwest', 5, 'chicago' ),
		( 'west coast', 6, 'san francisco' );

SELECT		*
	FROM	stores;

SELECT		*
	FROM	people, stores
	WHERE	store = number;

# Poniższe polecenie generuje błąd związany z niejednoznaczną nazwą kolumny
# SELECT		*
# 	FROM	people, stores
# 	WHERE	name = 'kuba';

SELECT		*
	FROM	people, stores
	WHERE	people.name = 'kuba';

SELECT		*
	FROM	people p JOIN stores s
	ON	p.store = s.number;

SELECT		*
	FROM	people p RIGHT JOIN stores s
	ON	p.store = s.number;

SELECT		*
	FROM	people p RIGHT JOIN stores s
	ON	s.number = p.store;

SELECT		p.name,
		city
	FROM	people p JOIN stores s
	ON	p.store = s.number;

SELECT		name
	FROM	people
	WHERE	store =
       (SELECT		number
		FROM	stores
		WHERE	city = 'new york'
       );
