#!/bin/bash
# Zmienia znak shebang w katalogu skryptów
#
################## Function Declarations ##########################
#
function errorOrExit {
	echo
	echo $message1
	echo $message2
	echo "Zamykanie skryptu..."
	exit
}
#
function modifyScripts {
	echo
	read -p "Nazwa katalogu, w którym mają być przechowywane nowe skrypty?" newScriptDir
	#
	echo "Czas rozpoczęcia modyfikacji skryptów: $(date +%N) ns"
	#
	count=0
	for filename in $(grep -l "/bin/sh" $scriptDir/*.sh)
	do
		newFilename=$(basename $filename)
		cat $filename | 
		sed '1c\#!/bin/bash' > $newScriptDir/$newFilename
		count=$[$count + 1] 
	done
	echo "Wykonano $count modyfikacji w $(date +%N) ns."
}
#
################# Sprawdzenie katalogu skryptów ######################
if [ -z $1 ]
then 
	message1="Brak nazwy katalogu zawierającego skrypty do sprawdzenia."
	message2="Podaj nazwę jako parametr."
        errorOrExit
else
	scriptDir=$1
fi 
#
################ Tworzenie raportu ############################
#
sed -sn '1F; 
1s!/bin/sh!/bin/bash!' $scriptDir/*.sh | 
gawk 'BEGIN {print ""
print "W poniższych skryptach znajduje się znak shebang /bin/sh:"
print "==================================================="}
{print $0}
END {print ""
print "Koniec raportu"}'
#
################## Zmienić skrypty? #################################
#
#
echo
#
read -p "Czy chcesz zmodyfikować znak shebang w tych skryptach? (T/n)? " answer
case $answer in
T | t)
	modifyScripts
	;;
N | n)
	message1="Żaden skrypt nie zostanie zmodyfikowany."
	message2="W razie potrzeby uruchom ten skrypt później, aby dokonać modyfikacji."
	errorOrExit
	;;
*)
	message1="Brak odpowiedzi T lub n."
	message2="Żaden skrypt nie zostanie zmodyfikowany."
	errorOrExit
	;;
esac
