#!/bin/bash
#
# Audit_System.sh - System monitoringu plików i kont
####################################################
#
### Inicjalizacja zmiennych #######################
#
runAccountAudit="false"
runPermAudit="false"
#
reportDir="/home/christine/scripts/AuditReports"
#
### Pobranie opcji (jeśli przekazane) #################
#
while getopts :Ap opt
do
     case "$opt" in
          A) runAccountAudit="true" ;;
          p) runPermAudit="true" ;;
          *) echo "Niepoprawna opcja."
             echo "Dostępne opcje: -A, -p, -Ap" 
             exit
          ;;
     esac
done
#
### Jeśli brak opcji ##################
#
if [ $OPTIND -eq 1 ]
then
     # Nie przekazano żadnych opcji. Ustawia wszystkie na "true" 
     runAccountAudit="true"
     runPermAudit="true"
fi
#
### Wykonanie wybranych audytów #######################
#
## Audyt kont ##################
#
if [ $runAccountAudit = "true" ]
then
    echo
    echo "****** Audyt kont *****"
    echo
#
# Sprawdzenie aktualnej liczby kont z powłoką false/nologin
#
    echo "Obecna liczba kont z powłoką false/nologin: "
#
    reportDate="$(date +%F%s)"
    accountReport=$reportDir/AccountAudit$reportDate.rpt
#
    # Utwrozenie bieżącego raportu
    cat /etc/passwd | cut -d: -f7 |
    grep -E "(nologin|false)" | wc -l |
    tee $accountReport
#
    # Zmiana atrybutów raportu:
    sudo chattr +i  $accountReport
#
# Pokazanie poprzedniej liczby powłok false/nologin
#
    prevReport="$(ls -1t $reportDir/AccountAudit*.rpt | sed -n '2p')"
    if [ -z $prevReport ]
    then
         echo
         echo "Brak poprzedniego raportu na temat powłok false/nologin do porównania."
    else
         echo
         echo "Liczba powłok false/nologin w poprzednim raporcie: "
         cat $prevReport
    fi
fi
#
## Audyt uprawnień ##############
#
if [ $runPermAudit = "true" ]
then
    echo
    echo "****** Audyt SUID/SGID *****"
    echo
    reportDate="$(date +%F%s)"
    permReport=$reportDir/PermissionAudit$reportDate.rpt
#
    # Tworzenie bieżącego raportu
    echo "Tworzenie raportu. To może chwilę potrwać..."
    sudo find / -perm /6000 >$permReport 2>/dev/null  
#
    # Zmiana atrybutów raportu:
    sudo chattr +i  $permReport
#
# Porównanie z poprzednim raportem na temat uprawnień
#
    #
    prevReport="$(ls -1t $reportDir/PermissionAudit*.rpt | sed -n '2p')"
    #
    if [ -z $prevReport ]
    then
         echo
         echo "Brak poprzedniego raportu na temat uprawnień do porównania."
    else
         echo
         echo "Różnice między tym i poprzednim raportem: "
         #
         differences=$(diff $permReport $prevReport)
         #
         if [ -z "$differences" ]
         then
             echo "Brak różnic."
         else
             echo $differences
         fi
    fi
fi
#
exit
