$ cat PackageMgrCheck.sh
#!/bin/bash
# sprawdza, czy w systemie znajdują się popularne menedżery pakietów
#
#################### Wprowadzenie użytkownika ######################
echo "########################################################"
echo
echo " Ten skrypt sprawdza, czy w używanym systemie Linux "
echo "znajdują się popularne menedżery pakietów i kontenery aplikacji, "
echo "wyświetla listę dostępnych narzędzi i na podstawie wyników zgaduje, "
echo "jaka jest podstawowa dystrybucja (Red Hat lub Debian)."
echo
echo "#######################################################"
#
##################### Testy dotyczące systemu Red Hat #######################
#
echo
echo "Szukanie menedżerów pakietów i kontenerów "
echo "aplikacji systemu Red Hat..."
#####
if (which rpm &> /dev/null)
then
    item_rpm=1
    echo "Masz podstawowe narzędzie rpm."
#
else
    item_rpm=0
#
fi
####
if (which dnf &> /dev/null)
then
    item_dnfyum=1
    echo "Masz menedżer pakietów dnf."
#
elif (which yum &> /dev/null)
then
    item_dnfyum=1
    echo "Masz menedżer pakietów yum."
else
    item_dnfyum=0
#
fi
####
if (which flatpak &> /dev/null)
then
    item_flatpak=1
    echo "Masz kontener aplikacji flatpak."
#
else
    item_flatpak=0
#
fi
####
redhatscore=$[$item_rpm + $item_dnfyum + $item_flatpak]
#
##################### Testy dotyczące systemu Debian #######################
#
echo
echo "Szukanie menedżerów pakietu i kontenerów"
echo " aplikacji systemu Debian..."
#####
if (which dpkg &> /dev/null)
then
    item_dpkg=1
    echo "Masz podstawowe narzędzie dpkg."
#
else
    item_dpkg=0
#
fi
####
if (which apt &> /dev/null)
then
    item_aptaptget=1
    echo "Masz menedżer pakietów apt."
#
elif (which apt-get &> /dev/null)
then
    item_aptaptget=1
    echo "Masz menedżer pakietów apt-get/apt-cache."
#
else
    item_aptaptget=0
fi
####
if (which snap &> /dev/null)
then
    item_snap=1
    echo "Masz kontener aplikacji snap."
#
else
    item_snap=0
#
fi
####
#
debianscore=$[$item_dpkg + $item_aptaptget + $item_snap]
#
#
##################### Określanie typu dystrybucji #######################
#
echo
if [ $debianscore -gt $redhatscore ]
then
    echo "Prawdopodobnie używasz dystrybucji opartej na Debianie."
    #
elif [ $redhatscore -gt $debianscore ]
then
    echo "Prawdopodobnie używasz dystrybucji opartej na systemie Red Hat."
else
    echo "Nie udało się określić bazowej dystrybucji Linuksa."
fi
#
echo
#
#############################################################
#
exit
$