#import <Foundation/Foundation.h>
#include <stdio.h>
#include <dlfcn.h>
#include <objc/objc.h>
#include <objc/runtime.h>

static inline BOOL validate_methods(const char *cls, const char *fname) {
    Class aClass = objc_getClass(cls);
    Method *methods;
    unsigned int nMethods;
    Dl_info info;
    IMP imp;
    char buf[128];
    Method m;

    if (!aClass)
        return NO;
    methods = class_copyMethodList(aClass, &nMethods);
    while(nMethods--) {
        m = methods[nMethods];
        printf("Walidacja [ %s %s ]\n",
            (const char *) class_getName(aClass),
            (const char *) method_getName(m));

        imp = method_getImplementation(m);
        if (!imp) {
            printf("Bd: niepowodzenie wykonania method_getImplementation(%s) \n",
                (const char *) method_getName(m));
            free(methods);
            return NO;
        }

        if (! dladdr(imp, &info)) {
            printf("Bd: niepowodzenie wykonania dladdr() dla %s\n",
                (const char *)method_getName(m));
            free(methods);
            return NO;
        }

        /* Walidacja cieki obrazu */
        if (strcmp(info.dli_fname, fname))
            goto FAIL;

        /* Walidacja nazwy klasy w symbolu */
        snprintf(buf, sizeof(buf), "[%s ",
            (const char *) class_getName(aClass));
        if (strncmp(info.dli_sname+1, buf, strlen(buf)))
        {
            snprintf(buf, sizeof(buf), "[%s(",
                (const char *) class_getName(aClass));
            if (strncmp(info.dli_sname+1, buf, strlen(buf)))
                goto FAIL;
        }

        /* Walidacja selektora w symbolu */
        snprintf(buf, sizeof(buf), " %s]",
            (const char *) method_getName(m));
        if (strncmp(info.dli_sname + (strlen(info.dli_sname) - strlen(buf)),
            buf, strlen(buf)))
        {
            goto FAIL;
        }
    }
    return YES;

FAIL:
    printf("Metoda %s nie przesza testu integralnoci:\n",
        (const char *)method_getName(m));
    printf("   dli_fname: %s\n", info.dli_fname);
    printf("   dli_sname: %s\n", info.dli_sname);
    printf("   dli_fbase: %p\n", info.dli_fbase);
    printf("   dli_saddr: %p\n", info.dli_saddr);
    free(methods);
    return NO;
}

@interface MyDelegate : NSObject
{

}
-(void)connectionDidFinishLoading:(NSURLConnection *)connection;
-(void)connection:(NSURLConnection *)connection 
    didFailWithError:(NSError *)error;
@end

@implementation MyDelegate

-(void)connectionDidFinishLoading:(NSURLConnection *)connection
{
    NSLog(@"%s Poczenie zakoczone powodzeniem", __func__);
    [ connection release ];
}

-(void)connection:(NSURLConnection *)connection 
    didFailWithError:(NSError *)error
{
    NSLog(@"%s Nieudane poczenie: %@", 
        __func__, 
        [ error localizedDescription ]);
    [ connection release ];
}
@end

int main(void) {
    NSAutoreleasePool *pool = [ [ NSAutoreleasePool alloc ] init ];
    MyDelegate *myDelegate = [ [ MyDelegate alloc ] init ];
    char buf[256];

    snprintf(buf, sizeof(buf), "%s/TestConnection",
        [ [ [ NSBundle mainBundle ] resourcePath ] UTF8String ]);

    /* Kilka testw, ktre powinny zakoczy si powodzeniem */

    if (NO == validate_methods("NSURLConnection", 
        "/System/Library/Frameworks/Foundation.framework/Foundation"))
    exit(0);

    if (NO == validate_methods("NSMutableURLRequest",
        "/System/Library/Frameworks/Foundation.framework/Foundation"))
    exit(0);

    if (NO == validate_methods("NSString",
        "/System/Library/Frameworks/Foundation.framework/Foundation"))
    exit(0);

    if (NO == validate_methods("MyDelegate", buf))
    exit(0);

    /* Kilka testw, ktre powinny zakoczy si niepowodzeniem */

    if (YES == validate_methods("MyDelegate",
        "/System/Library/Frameworks/Foundation.framework/Foundation"))
    exit(0);

    if (YES == validate_methods("NSURLConnection",
        "/System/Library/Frameworks/CoreFoundation.framework/CoreFoundation"))
    exit(0);

    /* Jestemy zweryfikowani. Czas wzi si do pracy. */

    NSURLRequest *request = [ [ NSURLRequest alloc ] 
        initWithURL: [ NSURL URLWithString: @"https://www.paypal.com" ]
    ];

    NSURLConnection *connection = [ [ NSURLConnection alloc ] 
        initWithRequest: request delegate: myDelegate ];

    if (!connection) {
       NSLog(@"%s Nieudane poczenie");
    } 

    CFRunLoopRun();
    [ pool release ];
    return 0;
}

