# Laboratorium r12

## Konfiguracja

Wdróż przesrzenie nazw i usługi:

```
kubectl apply -f lab/namespaces.yaml -f lab/services.yaml
```

Sprawdź liczbę rdzeni dostęnych na Twoim węźle:

```
kubectl get nodes -o jsonpath='{.items[].status.allocatable.cpu}'
```

> Kwoty powinny alokować 50% dla UAT, 25% dla testów i 25% dla programowania

## Przykładowe rozwiązanie

Mój węzeł ma 8 rdzeni CPU, dlatego mój [quotas.yaml](./solution/quotas.yaml) został skonfigurowany z 4 rdzeniami dla UAT, 2 dla programowania i 2 testowania.

Skonfiguruj kwoty:

```
kubectl apply -f lab/solution/quotas.yaml
```

Moja aplikacja Pi została ustawiona w [web.yaml](./solution/web.yaml), aby używać 0,5 rdzenia, bym w każdym środowisku mógł uruchomić co najmniej 4 repliki.

Wdróż w każdej przestrzeni nazw:

```
kubectl apply -f lab/solution/web.yaml -n pi-dev

kubectl apply -f lab/solution/web.yaml -n pi-test

kubectl apply -f lab/solution/web.yaml -n pi-uat
```

Powinieneś się przekonać, że wszystkie ReplicaSet zostały uruchomione z żądaną pojemnością:

```
kubectl get rs -l app=pi-web --all-namespaces
```

Na moim węźle UAT ma wystarczającą kwotę, aby uruchomić 8 replik:

```
kubectl scale deploy/pi-web --replicas 8 -n pi-uat
```

...tyle że tego nie robi:

```
kubectl get rs -l app=pi-web -n pi-uat\

# Zwraca uruchomionych 6 kapsuł z 8 żądanych
```

> Nie możesz użyć 100% CPU węzła, ponieważ komponenty systemu Kubernetesa same alokują CPU.

## Czyszczenie

Usuń przestrzenie nazw, a następnie usuń wszystko inne:

```
kubectl delete ns -l kiamol=ch12-lab
```