# Laboratorium r16

## Konfiguracja

Wdróż OPA Gatekeeper:

```
kubectl apply -f lab/gatekeeper.yaml
```

I szablon ograniczeń:

```
kubectl apply -f lab/restrictedPaths-template.yaml
```

## Przykładowe rozwiązanie

[Szablon ograniczeń](./restrictedPaths-template.yaml) używa parametru `paths` do utworzenia listy zastrzeżonych ścieżek.

Moje [ograniczenie](./solution/restrictedPaths-constraint.yaml) określa ścieżki i selektor etykiet.

Wdróż ograniczenie:

```
kubectl apply -f lab/solution/restrictedPaths-constraint.yaml
```

Spróbuj wdrożyć aplikację, która używa zastrzeżonych ścieżek:

```
kubectl apply -f lab/sleep.yaml

kubectl get all -l app=sleep

kubectl describe rs -l app=sleep
```

> Powinieneś zobaczyć, że ReplicaSet ma zero kapsuł, a szczegóły pokazują komunikat błędu z ograniczenia

Możesz to naprawić za pomocą [zaktualizowanej specyfikacji sleep](./solution/sleep.yaml):

```
kubectl apply -f lab/solution/sleep.yaml

kubectl get all -l app=sleep

kubectl describe rs -l app=sleep
```

## Czyszczenie

Usuń wszystkie zasoby:

```
kubectl delete -f lab/solution/sleep.yaml

kubectl delete RestrictedPaths,ConstraintTemplates --all

kubectl delete -f lab/gatekeeper.yaml
```