# Laboratorium r11

Skonfiguruj nowe zadanie Jenkinsa przez skopiowanie starego – na stronie głównej Jenkinsa kliknik _New Item_ i skopiuj projekt o nazwie _kiamol_:

![Kopiowanie potoku Jenkinsa](docs/jenkins-new-item.png)

Na stronie konfiguracji zasania przewiń w dół do sekcji _Pipeline_ i ustaw _Script Path_ na `ch11/lab/bulletin-board/Jenkinsfile`:

![Aktualizacja ścieżki skryptu](docs/jenkins-pipeline-path.png)

Projekt skompiluje się mniej więcej w minutę, a następnie ulegnie awarii – sprawdź dzienniki pod kątem etapu kompilacji.

## Przykładowe rozwiązanie

Gdy pogrzebiesz w dziennikach, znajdziesz takie komunikaty błędów:

```
#9 1.311 -----> Nodejs Buildpack version 1.6.30
#9 1.312 -----> Installing binaries
#9 1.312        engines.node (package.json): 10.6.0
#9 1.312        engines.npm (package.json): unspecified (use default)
#9 1.312        [31;1m**ERROR**[0m Unable to install node: no match found for 10.6.0 in [6.14.2 6.14.3 8.11.2 8.11.3 9.11.1 9.11.2 10.5.0 10.7.0]
#9 1.314 Failed to compile droplet: Failed to run all supply scripts: exit status 14
```

Używany przeze mnie Buildpack nie obsługuje wersji Node ustawionej w aplikacji. Obsługuje `10.5.0` i `10.7.0`, ale nie `10.6.0` (to stary Buildpack – późniejsze wersje obsługują nowsze wersje frameworku Node).

Przeszukaj pliki źrdłowe pod kątem `10.6.0`. Znajdziesz to w pliku:

- `ch11\lab\bulletin-board\src\package.json`

Zaktualizuj sekcję `engines` w tym pliku, aby używała wersji `10.7.0` Node.js:

```
{ 
    ...
      "engines": {
    "node": "10.7.0"
  }
}
```

Teraz zatwierdź zmiany i wyślij je do Gogs:

```
git add lab/bulletin-board/src/package.json

git commit -m 'Fix Node version'

git push gogs
```

Kolejna kompilacja się powiedzie. 

> To nieco trudniejsze laboratorium, ale pokazuje, że podejsćie PaaS obsługuje tylko określone platformy aplikacji i konkretne wersje. Jeśli będziesz miał aplikację, która nie spełnia odpowiednich kryteriów, nie będziesz mógł używać PaaS w sposób.

## Czyszczenie

Odinstaluj wydania Helma, a następnie będziesz mógł usunąć przestrzeń nazw i zasoby rozdziału:

```
helm uninstall bulletin-board-lab

kubectl delete ns kiamol-ch11-test

kubectl delete all -l kiamol=ch11
```