# Laboratorium r13

## Konfiguracja

Wdróż podsystem rejestrowania:

```
kubectl apply -f lab/logging/
```

## Przykładowe rozwiązanie

### Część I

Fluent Bit został [skonfigurowany](./logging/fluentbit-config.yaml) przechowywać wpisy z kapsuł w przestrzeni nazw `kiamol-ch13-lab`.

Utwórz tę przestrzeń nazw i skonfiguruj aplikację vweb:

```
kubectl create ns kiamol-ch13-lab

kubectl apply -f lab/vweb/ -n kiamol-ch13-lab
```

> Przejdź do strony aplikacji, co uruchomi dzienniki Nginx w kontenerze.

> Przejdź do Kibany i utwórz wzorzec indeksu dla indeksu o nazwie `lab` – sprawdź, czy dzienniki napływają.

![Część I laboratorium – dzienniki z serwera Nginx](./docs/part1.png)

## Część II

Dzienniki są na miejscu, ale nie są parsowane, więc mają po prostu postać tekstu.

Wdróż aktualizację [obiektu vweb Deployment](./solution/vweb-with-parser.yaml), która dodaje adnotację, by używać parsera serwera Nginx:

```
kubectl apply -f lab/solution/vweb-with-parser.yaml -n kiamol-ch13-lab
```

> Przejdź ponownie do aplikacji i odśwież Kibanę – dzienniki powinny mieć pola dla każdej ścieżki HTTP, kodu odpowiedzi itd.

![Część II laboratorium – sparsowane pola z serwera Nginx](./docs/part2.png)


### Część III

Teraz odfiltruj kody odpowiedzi 304 oraz wykonaj [filtrowanie grep](./solution/fluentbit-config-grep.yaml) dla konfiguracji Fluent Bita i zaktualizuj kapsułę:

```
kubectl apply -f lab/solution/fluentbit-config-grep.yaml

kubectl rollout restart ds/fluent-bit -n kiamol-ch13-lab-logging

kubectl wait --for=condition=ContainersReady pod -l app=fluent-bit -n kiamol-ch13-lab-logging

```

> Przejdź ponownie do aplikacji i odśwież Kibanę – nie widać żadnych kodów 304 dla najnowszych żądań

![Część III laboratorium – wykluczenie kodów 304 z serwera Nginx](./docs/part3.png)

## Czyszczenie

Usuń przestrzenie nazw, a następnie wszystko inne:

```
kubectl delete ns kiamol-ch13-lab

kubectl delete ns kiamol-ch13-lab-logging
```