# Skrypt wdrażający ElasticSearch i Kibana.

# Trzeba zacząć od utworzenia przestrzeni nazw logging.
kubectl create ns logging

# Następny krok to dodanie repozytorium Bitnami Chart Repo.
helm repo add bitnami https://charts.bitnami.com/bitnami

# Wdrożenie ElasticSearch, zdefiniowanie pewnych wartości dotyczących wielkości danych
# i replik w przestrzeni nazw logging.
helm install elasticsearch bitnami/elasticsearch --set master.persistence.size=1Gi,data.persistence.size=1Gi,data.replicas=2 --namespace logging

# Wdrożenie Kibana razem z wartościami wskazującymi serwer ES
# i portem przestrzeni nazw logging.
helm install kibana --set elasticsearch.hosts[0]=elasticsearch-elasticsearch-coordinating-only --set elasticsearch.port=9200,persistence.size=1Gi --namespace logging bitnami/kibana

# Wdrożenie fluentd - konfiguracja została zmodyfikowana i wskazuje odpowiednią
# usługę ES utworzoną podczas instalacji ES za pomocą Helm.
# To spowoduje wdrożenie do przestrzeni nazw kube-system.
kubectl create -f fluentd-config.yaml
kubectl create -f fluentd-ds.yaml

helm install falcosidekick -f ./falcosidekick/values.yaml ./falcosidekick --namespace logging
