#!/bin/bash
clear

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Włączenie audytu klastra"
echo -e "*******************************************************************************************************************"

echo -e "\n\n*******************************************************************************************************************"
echo -e "Krok 1. Utworzenie katalogu /var/log/k8s"
echo -e "*******************************************************************************************************************"
docker exec -ti cluster01-control-plane mkdir /var/log/k8s

echo -e "\n\n*******************************************************************************************************************"
echo -e "Krok 2. Utworzenie katalogu /etc/kubernetes/audit"
echo -e "*******************************************************************************************************************"
docker exec -ti cluster01-control-plane mkdir /etc/kubernetes/audit

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Krok 3. Kopiowanie polityki audytu do serwera API"
echo -e "*******************************************************************************************************************"
docker cp k8s-audit-policy.yaml cluster01-control-plane:/etc/kubernetes/audit/

tput setaf 3
echo -e "\n\n*******************************************************************************************************************"
echo -e "Zakończenie konfiguracji początkowej"
echo -e "\nKonieczne jest ręczne edytowanie pliku manifestu API, stosując się do zamieszczonych w rozdziale 8. informacji o włączaniu audytu"
echo -e "*******************************************************************************************************************\n"
tput setaf 2


