#!/bin/bash
clear

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Rozpoczęcie Instalowania Dockera..."
echo -e "*******************************************************************************************************************"

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Uaktualnienie repozytorium i dodanie klucza repozytorium Dockera (apt-key)"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo apt-get update
sudo apt-get install -y apt-transport-https ca-certificates curl gnupg-agent  software-properties-common
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Dodawanie repozytorium Dockera"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/ubuntu $(lsb_release -cs) stable"
sudo apt-get update

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Instalowanie Dockera"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo apt-get install -y docker-ce docker-ce-cli containerd.io

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Dodawanie bieżącego użytkownika do grupy Dockera"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo groupadd docker
sudo usermod -aG docker $USER

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Włączanie i uruchamianie Dockera - konieczne będzie podanie hasła dla sudo"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo systemctl enable docker && systemctl start docker

tput setaf 3
echo -e "\n \n*******************************************************************************************************************"
echo -e "Zakończenie Instalowania Dockera\n\n"
echo -e "Ponowne uruchomienie powłoki dla nowych grup - konieczne będzie podanie hasła dla sudo"
echo -e "*******************************************************************************************************************"
tput setaf 2
exec su -l $USER

